/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.config;

import com.github.sokyranthedragon.mia.integrations.jei.MiaJeiPlugin;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="mia", name="mia/jei")
@Config.LangKey(value="mia.config.jei.title")
@Mod.EventBusSubscriber(modid="mia")
public class JeiConfiguration {
    @Config.Name(value="Enable loot bag category")
    @Config.Comment(value={"If enabled, possible items from loot bags will be added to JEI (for example, from Dungeon Tactics or ExtraBotany)"})
    @Config.LangKey(value="mia.config.jei.loot_bag")
    public static boolean enableLootBagCategory = true;
    @Config.Name(value="Enable alchemical cauldron category")
    @Config.Comment(value={"If enabled, all possible alchemical cauldron recipes will be added to JEI (Dungeon Tactics required)"})
    @Config.LangKey(value="mia.config.jei.alchemical_cauldron")
    public static boolean enableAlchemicalCauldronCategory = true;
    @Config.Name(value="Enable orechid vacuam category")
    @Config.Comment(value={"If enabled, all possible orechid vacuam recipes will be added to JEI (Botania required)"})
    @Config.LangKey(value="mia.config.jei.orechid_vacuam")
    public static boolean enableOrechidVacuamCategory = true;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mia")) {
            ConfigManager.sync((String)"mia", (Config.Type)Config.Type.INSTANCE);
            if (enableLootBagCategory) {
                MiaJeiPlugin.unhideCategories("mia.loot_bag");
            } else {
                MiaJeiPlugin.hideCategories("mia.loot_bag");
            }
            if (enableAlchemicalCauldronCategory) {
                MiaJeiPlugin.unhideCategories("mia.alchemical_cauldron");
            } else {
                MiaJeiPlugin.hideCategories("mia.alchemical_cauldron");
            }
            if (enableOrechidVacuamCategory) {
                MiaJeiPlugin.unhideCategories("mia.orechid_vacuam");
            } else {
                MiaJeiPlugin.hideCategories("mia.orechid_vacuam");
            }
        }
    }
}

