/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.core;

import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.items.ItemMusicPlayer;
import com.github.sokyranthedragon.mia.items.ItemRingKobold;
import com.github.sokyranthedragon.mia.utilities.RegisterUtils;
import com.github.sokyranthedragon.mia.utilities.annotations.FieldsAreNullableByDefault;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@FieldsAreNullableByDefault
public class MiaItems {
    @Nonnull
    public static final List<Item> items = new LinkedList<Item>();
    public static ItemMusicPlayer musicPlayer = null;
    public static ItemRingKobold koboldRing = null;

    private MiaItems() {
    }

    public static <T extends Item> T registerItem(T item, IForgeRegistry<Item> registry) {
        return MiaItems.registerItem(item, registry, true);
    }

    public static <T extends Item> T registerItem(T item, IForgeRegistry<Item> registry, boolean registerCreative) {
        registry.register(item);
        if (registerCreative) {
            items.add(item);
        }
        return item;
    }

    public static void registerMiaItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        if (MiaConfig.musicPlayerEnabled) {
            musicPlayer = MiaItems.registerItem(new ItemMusicPlayer(), (IForgeRegistry<Item>)registry);
        }
        if (SizeUtils.isSizeComponentEnabled && (ModIds.BAUBLES.isLoaded || ModIds.AETHER.isLoaded)) {
            koboldRing = MiaItems.registerItem(new ItemRingKobold(), (IForgeRegistry<Item>)registry, GenericAdditionsConfig.enableSizeComponent);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerMiaItemRenderers() {
        RegisterUtils.registerItemRenderer(musicPlayer);
        if (koboldRing != null) {
            RegisterUtils.registerItemRenderer(koboldRing);
        }
    }
}

