/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.events;

import com.github.sokyranthedragon.mia.config.HarvestcraftConfiguration;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.MoCreaturesConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.pam.harvestcraft.item.ItemRegistry;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import drzhark.mocreatures.entity.ambient.MoCEntityCrab;
import drzhark.mocreatures.entity.aquatic.MoCEntityAnchovy;
import drzhark.mocreatures.entity.aquatic.MoCEntityBass;
import drzhark.mocreatures.entity.aquatic.MoCEntityClownFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityCod;
import drzhark.mocreatures.entity.aquatic.MoCEntityJellyFish;
import drzhark.mocreatures.entity.aquatic.MoCEntitySalmon;
import drzhark.mocreatures.entity.monster.MoCEntityRat;
import drzhark.mocreatures.entity.monster.MoCEntityWerewolf;
import drzhark.mocreatures.entity.passive.MoCEntityBoar;
import drzhark.mocreatures.entity.passive.MoCEntityDeer;
import drzhark.mocreatures.entity.passive.MoCEntityDuck;
import drzhark.mocreatures.entity.passive.MoCEntityTurkey;
import drzhark.mocreatures.entity.passive.MoCEntityTurtle;
import drzhark.mocreatures.init.MoCItems;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.world.entity.EntityCrab;
import vazkii.quark.world.entity.EntityFrog;
import vazkii.quark.world.feature.Crabs;
import vazkii.quark.world.feature.Frogs;

@Mod.EventBusSubscriber(modid="mia")
public class EntityEvents {
    @SubscribeEvent
    public static void onEntityHit(LivingHurtEvent event) {
        ItemSword sword;
        EntityPlayer player;
        ItemStack heldItem;
        if (ModIds.MO_CREATURES.isLoaded && MoCreaturesConfiguration.buffOtherModSilverWeapons && event.getAmount() < 10.0f && event.getSource() instanceof EntityDamageSource && event.getEntityLiving() instanceof MoCEntityWerewolf && !((MoCEntityWerewolf)event.getEntityLiving()).getIsHumanForm() && event.getSource().field_76373_n.equals("player") && event.getSource().func_76364_f() instanceof EntityPlayer && !(heldItem = (player = (EntityPlayer)event.getSource().func_76364_f()).func_184614_ca()).func_190926_b() && heldItem.func_77973_b() instanceof ItemSword && ((sword = (ItemSword)heldItem.func_77973_b()).func_150932_j().toLowerCase().contains("silver") || sword.func_77658_a().toLowerCase().contains("silver"))) {
            event.setAmount(10.0f);
        }
    }

    @SubscribeEvent
    public static void onEntityDrops(LivingDropsEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            return;
        }
        if (ModIds.HARVESTCRAFT.isLoaded) {
            if (HarvestcraftConfiguration.squidDropsCalamari && event.getEntityLiving() instanceof EntitySquid) {
                EntityEvents.dropFewItems(ItemRegistry.calamarirawItem, ItemRegistry.calamaricookedItem, event);
                return;
            }
            if (ModIds.MO_CREATURES.isLoaded) {
                if (event.getEntityLiving() instanceof MoCEntityAnchovy) {
                    EntityEvents.replaceItemDrop(event.getDrops(), Items.field_151115_aP, ItemRegistry.anchovyrawItem);
                    return;
                }
                if (event.getEntityLiving() instanceof MoCEntityBass) {
                    EntityEvents.replaceItemDrop(event.getDrops(), Items.field_151115_aP, ItemRegistry.bassrawItem);
                    return;
                }
                if (event.getEntityLiving() instanceof MoCEntitySalmon) {
                    EntityEvents.replaceItemDrop(event.getDrops(), Items.field_151115_aP, Items.field_151115_aP, Items.field_179566_aV, 1, event.getEntityLiving().func_70027_ad());
                    return;
                }
                if (event.getEntityLiving() instanceof MoCEntityJellyFish) {
                    EntityEvents.dropFewItems(ItemRegistry.jellyfishrawItem, event);
                    return;
                }
                if (event.getEntityLiving() instanceof MoCEntityDuck) {
                    EntityEvents.dropFewItems(ItemRegistry.duckrawItem, ItemRegistry.duckcookedItem, event);
                    return;
                }
                if (event.getEntityLiving() instanceof MoCEntityDeer) {
                    EntityEvents.dropFewItems(ItemRegistry.venisonrawItem, ItemRegistry.venisoncookedItem, event);
                    return;
                }
            }
        }
        if (ModIds.MO_CREATURES.isLoaded && EntityEvents.registerMoCreaturesDrops(event)) {
            return;
        }
        if (ModIds.QUARK.isLoaded && EntityEvents.registerQuarkDrops(event)) {
            return;
        }
    }

    private static void replaceItemDrop(List<EntityItem> drops, Item itemToReplace, Item targetItem) {
        EntityEvents.replaceItemDrop(drops, itemToReplace, Items.field_190931_a, targetItem, 0, false);
    }

    private static void replaceItemDrop(List<EntityItem> drops, Item itemToReplace, Item targetItem, int meta, boolean onFire) {
        EntityEvents.replaceItemDrop(drops, itemToReplace, Items.field_190931_a, targetItem, meta, false);
    }

    private static void replaceItemDrop(List<EntityItem> drops, Item itemToReplace, Item targetItem, Item cookedItem, boolean onFire) {
        EntityEvents.replaceItemDrop(drops, itemToReplace, targetItem, cookedItem, 0, onFire);
    }

    private static void replaceItemDrop(List<EntityItem> drops, Item itemToReplace, Item targetItem, Item cookedItem, int meta, boolean onFire) {
        if (targetItem == Items.field_190931_a || onFire && MiaConfig.addCookedDrops && cookedItem != Items.field_190931_a) {
            targetItem = cookedItem;
        }
        Item finalTargetItem = targetItem;
        drops.forEach(i -> {
            if (i.func_92059_d().func_77973_b() == itemToReplace) {
                i.func_92058_a(new ItemStack(finalTargetItem, i.func_92059_d().func_190916_E(), meta));
            }
        });
    }

    private static void dropFewItems(Item item, LivingDropsEvent event) {
        EntityEvents.dropFewItems(item, Items.field_190931_a, false, event.getEntityLiving(), event.getLootingLevel());
    }

    private static void dropFewItems(Item item, Item cooked, LivingDropsEvent event) {
        EntityEvents.dropFewItems(item, cooked, event.getEntityLiving().func_70027_ad(), event.getEntityLiving(), event.getLootingLevel());
    }

    private static void dropFewItems(Item item, Item cooked, boolean onFire, EntityLivingBase entity, int lootingLevel) {
        int i = entity.field_70170_p.field_73012_v.nextInt(3);
        if (lootingLevel > 0) {
            i += entity.field_70170_p.field_73012_v.nextInt(lootingLevel + 1);
        }
        if (item == null || onFire && MiaConfig.addCookedDrops && cooked != Items.field_190931_a) {
            item = cooked;
        }
        for (int j = 0; j < i; ++j) {
            entity.func_145779_a(item, 1);
        }
    }

    @Optional.Method(modid="mocreatures")
    private static boolean registerMoCreaturesDrops(LivingDropsEvent event) {
        if (MoCreaturesConfiguration.replaceFishDrops) {
            if (event.getEntityLiving() instanceof MoCEntityCod) {
                EntityEvents.replaceItemDrop(event.getDrops(), Items.field_151115_aP, Items.field_151115_aP, Items.field_179566_aV, 1, MiaConfig.addCookedDrops && event.getEntityLiving().func_70027_ad());
                return true;
            }
            if (event.getEntityLiving() instanceof MoCEntityClownFish) {
                EntityEvents.replaceItemDrop((List<EntityItem>)event.getDrops(), Items.field_151115_aP, Items.field_151115_aP, 2, event.getEntityLiving().func_70027_ad());
                return true;
            }
        }
        if (MiaConfig.addCookedDrops && event.getEntityLiving().func_70027_ad()) {
            if (event.getEntityLiving() instanceof MoCEntityAquatic) {
                EntityEvents.replaceItemDrop(event.getDrops(), Items.field_151115_aP, Items.field_179566_aV);
                return true;
            }
            if (event.getEntityLiving() instanceof MoCEntityDuck) {
                EntityEvents.replaceItemDrop(event.getDrops(), (Item)MoCItems.crabraw, (Item)MoCItems.ostrichcooked);
                return true;
            }
            if (event.getEntityLiving() instanceof MoCEntityCrab) {
                EntityEvents.replaceItemDrop(event.getDrops(), (Item)MoCItems.crabraw, (Item)MoCItems.crabcooked);
                return true;
            }
            if (event.getEntityLiving() instanceof MoCEntityRat) {
                EntityEvents.replaceItemDrop(event.getDrops(), (Item)MoCItems.ratRaw, (Item)MoCItems.ratCooked);
                return true;
            }
            if (event.getEntityLiving() instanceof MoCEntityTurkey) {
                EntityEvents.replaceItemDrop(event.getDrops(), (Item)MoCItems.rawTurkey, (Item)MoCItems.cookedTurkey);
                return true;
            }
            if (event.getEntityLiving() instanceof MoCEntityBoar) {
                EntityEvents.replaceItemDrop(event.getDrops(), Items.field_151147_al, Items.field_151157_am);
                return true;
            }
            if (ModIds.HARVESTCRAFT.isLoaded && event.getEntityLiving() instanceof MoCEntityTurtle) {
                EntityEvents.replaceItemDrop(event.getDrops(), (Item)MoCItems.turtleraw, ItemRegistry.turtlecookedItem);
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="quark")
    private static boolean registerQuarkDrops(LivingDropsEvent event) {
        if (MiaConfig.addCookedDrops) {
            if (Crabs.crabLeg != null && event.getEntity() instanceof EntityCrab) {
                EntityEvents.replaceItemDrop(event.getDrops(), (Item)Crabs.crabLeg, (Item)Crabs.cookedCrabLeg);
                return true;
            }
            if (Frogs.frogLeg != null && event.getEntity() instanceof EntityFrog) {
                EntityEvents.replaceItemDrop(event.getDrops(), (Item)Frogs.frogLeg, (Item)Frogs.cookedFrogLeg);
                return true;
            }
        }
        return false;
    }
}

