/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.events;

import com.gildedgames.the_aether.api.accessories.AccessoryType;
import com.gildedgames.the_aether.api.accessories.AetherAccessory;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.core.MiaItems;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mia")
public class RegistryEvents {
    @SubscribeEvent
    public static void missingBlockMappingsEvent(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            Block block;
            if (!entry.key.func_110624_b().equals("mia") || (block = RegistryEvents.getBlockFromPath(entry.key.func_110623_a())) == null) continue;
            entry.remap((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void missingItemMappingsEvent(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            Item itemBlock;
            Block block;
            if (!entry.key.func_110624_b().equals("mia") || (block = RegistryEvents.getBlockFromPath(entry.key.func_110623_a())) == null || (itemBlock = Item.func_150898_a((Block)block)) == Items.field_190931_a) continue;
            entry.remap((IForgeRegistryEntry)itemBlock);
        }
    }

    @Nullable
    private static Block getBlockFromPath(String path) {
        switch (path) {
            case "white_sandstone_wall_quark": {
                if (MiaBlocks.whiteSandstone == null) break;
                return MiaBlocks.whiteSandstone.wallFutureMc;
            }
            case "white_sandstone_wall_futuremc": {
                if (MiaBlocks.whiteSandstone == null) break;
                return MiaBlocks.whiteSandstone.wallQuark;
            }
        }
        return null;
    }

    @SubscribeEvent
    @Optional.Method(modid="aether_legacy")
    public static void onRegisterAetherAccessory(RegistryEvent.Register<AetherAccessory> event) {
        if (MiaItems.musicPlayer != null) {
            event.getRegistry().register((IForgeRegistryEntry)new AetherAccessory((Item)MiaItems.musicPlayer, AccessoryType.MISC));
        }
        if (SizeUtils.isSizeComponentEnabled && MiaItems.koboldRing != null) {
            event.getRegistry().register((IForgeRegistryEntry)new AetherAccessory((Item)MiaItems.koboldRing, AccessoryType.RING));
        }
    }
}

