/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations;

import com.github.sokyranthedragon.mia.integrations.jer.ResourceLocationWrapper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;

@ParametersAreNonnullByDefault
public enum ModIds {
    MIA("mia"),
    ARTEMISLIB("artemislib", "[1.0.6,]"),
    EXTRA_UTILITIES("extrautils2"),
    COFH_CORE("cofhcore"),
    THERMAL_FOUNDATION("thermalfoundation"),
    THERMAL_EXPANSION("thermalexpansion"),
    TINKERS_CONSTRUCT("tconstruct"),
    JEI("jei"),
    JER("jeresources", "[0.9.1.56,]"),
    ICE_AND_FIRE("iceandfire", "[1.9.0,]"),
    HATCHERY("hatchery"),
    BAUBLES("baubles"),
    THAUMCRAFT("thaumcraft"),
    THE_ONE_PROBE("theoneprobe"),
    MO_CREATURES("mocreatures"),
    HARVESTCRAFT("harvestcraft"),
    DUNGEON_TACTICS("dungeontactics"),
    BOTANIA("botania"),
    EXTRABOTANY("extrabotany"),
    QUARK("quark"),
    CRAFT_TWEAKER("crafttweaker"),
    FUTURE_MC("futuremc", "[0.2.0.0,]"),
    NATURA("natura"),
    BIOMES_O_PLENTY("biomesoplenty"),
    CONNECTED_TEXTURES("ctm"),
    CHISEL("chisel"),
    INDUSTRIAL_FOREGOING("industrialforegoing"),
    AETHER("aether_legacy"),
    AETHER_CONTINUATION("aether_legacy_addon"),
    AETHER_LOST_CONTENT("lost_aether"),
    ENDER_IO("enderio"),
    ENDER_IO_ZOO("enderiozoo"),
    CHARM("charm");

    public final String modId;
    public final boolean isLoaded;

    private ModIds(String modId) {
        this(modId, null);
    }

    private ModIds(String modId, String supportedVersion) {
        this.modId = modId;
        this.isLoaded = Loader.isModLoaded((String)modId) && this.isSpecifiedVersion(supportedVersion);
    }

    public ResourceLocation loadSimple(String path) {
        return new ResourceLocation(this.modId, path);
    }

    public ResourceLocationWrapper loadResource(String path) {
        return new ResourceLocationWrapper(this.modId, path);
    }

    public ResourceLocationWrapper loadResource(String path, int id) {
        return new ResourceLocationWrapper(this.modId, path, id);
    }

    public ModContainer getModContainer() {
        return (ModContainer)Loader.instance().getIndexedModList().get(this.modId);
    }

    public boolean isSpecifiedVersion(@Nullable String string) {
        if (string == null) {
            return true;
        }
        boolean match = true;
        ModContainer container = this.getModContainer();
        if (container != null) {
            try {
                VersionRange versionRange = VersionParser.parseRange((String)string);
                match = versionRange.containsVersion(container.getProcessedVersion());
            }
            catch (LoaderException loaderException) {
                // empty catch block
            }
        }
        return match;
    }

    public String toString() {
        return this.modId;
    }

    public static class ConstantIds {
        public static final String ARTEMISLIB = "artemislib";
        public static final String EXTRA_UTILITIES = "extrautils2";
        public static final String COFH_CORE = "cofhcore";
        public static final String THERMAL_FOUNDATION = "thermalfoundation";
        public static final String THERMAL_EXPANSION = "thermalexpansion";
        public static final String TINKERS_CONSTRUCT = "tconstruct";
        public static final String JEI = "jei";
        public static final String JER = "jeresources";
        public static final String ICE_AND_FIRE = "iceandfire";
        public static final String HATCHERY = "hatchery";
        public static final String BAUBLES = "baubles";
        public static final String THAUMCRAFT = "thaumcraft";
        public static final String THE_ONE_PROBE = "theoneprobe";
        public static final String MO_CREATURES = "mocreatures";
        public static final String HARVESTCRAFT = "harvestcraft";
        public static final String DUNGEON_TACTICS = "dungeontactics";
        public static final String BOTANIA = "botania";
        public static final String EXTRABOTANY = "extrabotany";
        public static final String QUARK = "quark";
        public static final String CRAFT_TWEAKER = "crafttweaker";
        public static final String FUTURE_MC = "futuremc";
        public static final String NATURA = "natura";
        public static final String BIOMES_O_PLENTY = "biomesoplenty";
        public static final String CONNECTED_TEXTURES = "ctm";
        public static final String CHISEL = "chisel";
        public static final String INDUSTRIAL_FOREGOING = "industrialforegoing";
        public static final String AETHER = "aether_legacy";
        public static final String AETHER_CONTINUATION = "aether_legacy_addon";
        public static final String AETHER_LOST_CONTENT = "lost_aether";
        public static final String ENDER_IO = "enderio";
        public static final String ENDER_IO_ZOO = "enderiozoo";
        public static final String CHARM = "charm";

        private ConstantIds() {
        }
    }
}

