/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.aether;

import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.items.ItemsAether;
import com.github.sokyranthedragon.mia.config.AetherConfig;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.aether.ChiselAetherIntegration;
import com.github.sokyranthedragon.mia.integrations.aether.DungeonTacticsAetherIntegration;
import com.github.sokyranthedragon.mia.integrations.aether.ExtraUtilsAetherIntegration;
import com.github.sokyranthedragon.mia.integrations.aether.FutureMcAetherIntegration;
import com.github.sokyranthedragon.mia.integrations.aether.IndustrialForegoingAetherIntegration;
import com.github.sokyranthedragon.mia.integrations.aether.JerAetherIntegration;
import com.github.sokyranthedragon.mia.integrations.aether.ThermalExpansionAetherIntegration;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.ThaumcraftHelpers;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class Aether
implements IBaseMod {
    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (ModIds.FUTURE_MC.isLoaded && AetherConfig.enableFutureMcIntegration) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcAetherIntegration());
        }
        if (ModIds.DUNGEON_TACTICS.isLoaded && AetherConfig.enableDungeonTacticsIntegration) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsAetherIntegration());
        }
        if (ModIds.THERMAL_EXPANSION.isLoaded && AetherConfig.enableTeIntegration) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionAetherIntegration());
        }
        if (AetherConfig.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerAetherIntegration());
        }
        if (ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            modIntegration.accept(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoingAetherIntegration());
        }
        if (ModIds.CHISEL.isLoaded && AetherConfig.enableChiselIntegration) {
            modIntegration.accept(ModIds.CHISEL, new ChiselAetherIntegration());
        }
        if (ModIds.EXTRA_UTILITIES.isLoaded && AetherConfig.enableXu2Integration) {
            modIntegration.accept(ModIds.EXTRA_UTILITIES, new ExtraUtilsAetherIntegration());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!AetherConfig.aetherAdditionsEnabled) {
            return;
        }
        BlocksAether.aether_dirt.setHarvestLevel("shovel", -1);
        BlocksAether.aether_grass.setHarvestLevel("shovel", -1);
        BlocksAether.quicksoil.setHarvestLevel("shovel", -1);
        if (!MiaConfig.disableOreDict) {
            OreDictionary.registerOre((String)"listAllMilk", (ItemStack)new ItemStack(ItemsAether.skyroot_bucket, 1, 4));
            OreDictionary.registerOre((String)"slimeball", (ItemStack)new ItemStack(ItemsAether.swetty_ball));
            OreDictionary.registerOre((String)"bookshelf", (ItemStack)new ItemStack(BlocksAether.skyroot_bookshelf));
            OreDictionary.registerOre((String)"grass", (ItemStack)new ItemStack(BlocksAether.aether_grass));
            OreDictionary.registerOre((String)"dirt", (ItemStack)new ItemStack(BlocksAether.aether_dirt));
            OreDictionary.registerOre((String)"blockMossy", (ItemStack)new ItemStack(BlocksAether.mossy_holystone));
            OreDictionary.registerOre((String)"listAllBerry", (ItemStack)new ItemStack(ItemsAether.blue_berry));
            OreDictionary.registerOre((String)"listAllFruit", (ItemStack)new ItemStack(ItemsAether.blue_berry));
        }
    }

    @Override
    public void registerAspects(AspectRegistryEvent event) {
        AspectEventProxy register = event.register;
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAether.holystone), new ItemStack(Blocks.field_150347_e), register, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAether.mossy_holystone), new ItemStack(Blocks.field_150341_Y), register, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAether.enchanted_aether_grass), new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 2).add(Aspect.MAGIC, 2), register);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAether.icestone), new AspectList().add(Aspect.COLD, 5), register);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAether.quicksoil), new AspectList().add(Aspect.EARTH, 3).add(Aspect.MOTION, 5), register);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.zanite_gemstone), new AspectList().add(Aspect.DESIRE, 15).add(Aspect.CRYSTAL, 15).add(Aspect.MAGIC, 1), register);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAether.zanite_block), new ItemStack(ItemsAether.zanite_gemstone), register, 9.0f);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.ambrosium_shard), new AspectList().add(Aspect.AIR, 10).add(Aspect.MAGIC, 5), register);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAether.enchanted_gravitite), new AspectList().add(Aspect.FLIGHT, 5).add(Aspect.AIR, 5).add(Aspect.MAGIC, 5).add(Aspect.METAL, 15), register);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAether.ambrosium_torch), new AspectList().add(Aspect.LIGHT, 5).add(Aspect.ENERGY, 1), register);
        AspectList target = AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150343_Z));
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.obsidian_helmet), target, register, 2.5f);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.obsidian_chestplate), target, register, 4.0f);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.obsidian_leggings), target, register, 3.5f);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.obsidian_boots), target, register, 2.0f);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.obsidian_gloves), target, register, 1.0f);
        target = new AspectList().add(Aspect.FIRE, 15);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.phoenix_helmet), target, register, 2.5f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.phoenix_chestplate), target, register, 4.0f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.phoenix_leggings), target, register, 3.5f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.phoenix_boots), target, register, 2.0f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.phoenix_gloves), target, register, 1.0f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.phoenix_bow), target, register, 1.0f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.flaming_sword), target, register, 2.0f, false);
        target = new AspectList().add(Aspect.WATER, 15);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.neptune_helmet), target, register, 2.5f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.neptune_chestplate), target, register, 4.0f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.neptune_leggings), target, register, 3.5f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.neptune_boots), target, register, 2.0f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.neptune_gloves), target, register, 1.0f, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.chain_gloves), new ItemStack((Item)Items.field_151023_V), register, 0.25f, false);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.lightning_sword), new AspectList().add(Aspect.ENERGY, 16), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.lightning_knife), new AspectList().add(Aspect.ENERGY, 4).add(Aspect.AVERSION, 4), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.vampire_blade), new AspectList().add(Aspect.LIFE, 15).add(Aspect.UNDEAD, 5), register);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.dart_shooter, 1, 0), new ItemStack(ItemsAether.dart_shooter, 1, 1), register, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.dart_shooter, 1, 0), new ItemStack(ItemsAether.dart_shooter, 1, 2), register, false, new AspectList().add(Aspect.MAGIC, 10));
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.dart, 1, 0), new ItemStack(ItemsAether.dart, 1, 1), register, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.dart, 1, 0), new ItemStack(ItemsAether.dart, 1, 2), register, false, new AspectList().add(Aspect.MAGIC, 1));
        target = new AspectList().add(Aspect.PLANT, 5).add(Aspect.SENSES, 5).add(Aspect.LIFE, 1);
        ThaumcraftHelpers.addAspects(new ItemStack(BlocksAether.purple_flower), target, register);
        ThaumcraftHelpers.addAspects(new ItemStack(BlocksAether.white_flower), target, register);
        ThaumcraftHelpers.addAspects(new ItemStack(BlocksAether.berry_bush), target, register);
        ThaumcraftHelpers.addAspects(new ItemStack(BlocksAether.berry_bush_stem), target, register);
        target = AspectHelper.getObjectAspects((ItemStack)new ItemStack(Items.field_151034_e));
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.blue_berry), target, register, false);
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.enchanted_blueberry), target, register, 3.0f, false, new AspectList().add(Aspect.MAGIC, 5));
        ThaumcraftHelpers.transferAspects(new ItemStack(ItemsAether.white_apple), target, register, false);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.skyroot_bucket, 1, 0), new AspectList().add(Aspect.VOID, 5), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.skyroot_bucket, 1, 1), new AspectList().add(Aspect.VOID, 5).add(Aspect.WATER, 20), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.skyroot_bucket, 1, 2), new AspectList().add(Aspect.VOID, 5).add(Aspect.DEATH, 10).add(Aspect.MAGIC, 5), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.skyroot_bucket, 1, 3), new AspectList().add(Aspect.VOID, 5).add(Aspect.LIFE, 10).add(Aspect.MAGIC, 15), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.skyroot_bucket, 1, 4), new AspectList().add(Aspect.VOID, 5).add(Aspect.LIFE, 10).add(Aspect.BEAST, 5).add(Aspect.WATER, 5), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.healing_stone), new AspectList().add(Aspect.LIFE, 10).add(Aspect.MAGIC, 10), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.golden_amber), new AspectList().add(Aspect.PLANT, 1).add(Aspect.DESIRE, 1), register);
        ThaumcraftHelpers.addAspects(new ItemStack(ItemsAether.aechor_petal), new AspectList().add(Aspect.PLANT, 5).add(Aspect.SENSES, 5), register);
        ThaumcraftHelpers.addAspects(new ItemStack(BlocksAether.aerogel), new AspectList().add(Aspect.COLD, 5).add(Aspect.FIRE, 5), register);
        ThaumcraftHelpers.addAspects(new ItemStack(BlocksAether.sun_altar), new AspectList().add(Aspect.MAGIC, 50).add(Aspect.LIGHT, 15).add(Aspect.FIRE, 30), register);
        for (Item item : ItemsAether.itemRegistry) {
            if (item.getRegistryName() == null || !item.getRegistryName().func_110624_b().equals("aether_legacy") && !item.getRegistryName().func_110624_b().equals("lost_aether")) continue;
            NonNullList stacks = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, stacks);
            ThaumcraftHelpers.addAspect((NonNullList<ItemStack>)stacks, register, Aspect.AIR);
        }
        for (Block block : BlocksAether.blockList) {
            if (block.getRegistryName() == null || !block.getRegistryName().func_110624_b().equals("aether_legacy") && !block.getRegistryName().func_110624_b().equals("lost_aether")) continue;
            NonNullList stacks = NonNullList.func_191196_a();
            block.func_149666_a(null, stacks);
            ThaumcraftHelpers.addAspect((NonNullList<ItemStack>)stacks, register, Aspect.AIR);
        }
    }
}

