/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.aether_continuation;

import com.gildedgames.the_aether.addon.blocks.BlocksAetherAddon;
import com.github.sokyranthedragon.mia.config.AetherConfig;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.aether_continuation.DungeonTacticsAetherContinuationIntegration;
import com.github.sokyranthedragon.mia.integrations.aether_continuation.FutureMcAetherContinuationIntegration;
import com.github.sokyranthedragon.mia.integrations.aether_continuation.ThermalExpansionAetherContinuationIntegration;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.ThaumcraftHelpers;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class AetherContinuation
implements IBaseMod {
    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (ModIds.DUNGEON_TACTICS.isLoaded && AetherConfig.enableDungeonTacticsIntegration) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsAetherContinuationIntegration());
        }
        if (ModIds.THERMAL_EXPANSION.isLoaded && AetherConfig.enableTeIntegration) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionAetherContinuationIntegration());
        }
        if (ModIds.FUTURE_MC.isLoaded && AetherConfig.enableFutureMcIntegration) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcAetherContinuationIntegration());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!AetherConfig.aetherContinuationAdditionsEnabled) {
            return;
        }
        if (!MiaConfig.disableOreDict) {
            OreDictionary.registerOre((String)"trapdoorWood", (ItemStack)new ItemStack(BlocksAetherAddon.skyroot_trapdoor));
            OreDictionary.registerOre((String)"buttonWood", (ItemStack)new ItemStack(BlocksAetherAddon.skyroot_button));
            OreDictionary.registerOre((String)"pressurePlateWood", (ItemStack)new ItemStack(BlocksAetherAddon.skyroot_pressure_plate));
        }
    }

    @Override
    public void registerAspects(AspectRegistryEvent event) {
        AspectEventProxy register = event.register;
        AspectList target = new AspectList().add(Aspect.MECHANISM, 5).add(Aspect.TRAP, 5);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAetherAddon.skyroot_door), target, register);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAetherAddon.zanite_door), target, register);
        target = new AspectList().add(Aspect.MOTION, 5);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAetherAddon.skyroot_trapdoor), target, register);
        ThaumcraftHelpers.transferAspects(new ItemStack(BlocksAetherAddon.zanite_trapdoor), target, register);
    }
}

