/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.base;

import com.gendeathrow.morechickens.core.ModItems;
import com.gildedgames.the_aether.api.freezables.AetherFreezableFuel;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.AetherConfig;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.ThaumcraftConfiguration;
import com.github.sokyranthedragon.mia.gui.client.ErrorToast;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.aether.Aether;
import com.github.sokyranthedragon.mia.integrations.aether_continuation.AetherContinuation;
import com.github.sokyranthedragon.mia.integrations.aether_lost_content.AetherLostContent;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.base.LootTableIntegrator;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.BiomesOPlenty;
import com.github.sokyranthedragon.mia.integrations.botania.Botania;
import com.github.sokyranthedragon.mia.integrations.charm.Charm;
import com.github.sokyranthedragon.mia.integrations.chisel.Chisel;
import com.github.sokyranthedragon.mia.integrations.cofhcore.CofhCore;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.DungeonTactics;
import com.github.sokyranthedragon.mia.integrations.ender_io.EnderIo;
import com.github.sokyranthedragon.mia.integrations.ender_io_zoo.EnderIoZoo;
import com.github.sokyranthedragon.mia.integrations.extrabotany.ExtraBotany;
import com.github.sokyranthedragon.mia.integrations.futuremc.FutureMc;
import com.github.sokyranthedragon.mia.integrations.harvestcraft.Harvestcraft;
import com.github.sokyranthedragon.mia.integrations.hatchery.Hatchery;
import com.github.sokyranthedragon.mia.integrations.iceandfire.IceAndFire;
import com.github.sokyranthedragon.mia.integrations.industrialforegoing.IndustrialForegoing;
import com.github.sokyranthedragon.mia.integrations.jei.Jei;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import com.github.sokyranthedragon.mia.integrations.mia.MiaSelfIntegrations;
import com.github.sokyranthedragon.mia.integrations.mocreatures.MoCreatures;
import com.github.sokyranthedragon.mia.integrations.natura.Natura;
import com.github.sokyranthedragon.mia.integrations.quark.Quark;
import com.github.sokyranthedragon.mia.integrations.tconstruct.TinkersConstruct;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.Thaumcraft;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.ThaumcraftHelpers;
import com.github.sokyranthedragon.mia.integrations.theoneprobe.TheOneProbe;
import com.github.sokyranthedragon.mia.integrations.thermalexpansion.ThermalExpansion;
import com.github.sokyranthedragon.mia.integrations.thermalfoundation.ThermalFoundation;
import com.github.sokyranthedragon.mia.integrations.xu2.ExtraUtilities2;
import com.setycz.chickens.ChickensMod;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class ModIntegrator {
    private Map<ModIds, IBaseMod> modIntegrations = new LinkedHashMap<ModIds, IBaseMod>();
    private boolean modsRegistered = false;
    private boolean modsPreInitialized = false;
    private boolean modsInitialized = false;
    private boolean modsPostInitialized = false;
    private boolean modsLoadCompleted = false;
    private boolean registeredBlocks = false;
    private boolean registeredItems = false;
    private boolean registeredRenders = false;
    private boolean registeredLootTableListeners = false;
    private boolean registeredDispenserBehaviors = false;
    private boolean registeredAspects = false;
    private boolean registeredAetherFreezable = false;

    public void registerMods() {
        if (this.modsRegistered) {
            Mia.LOGGER.warn("ModIntegrator.registerMods() was called more than once, this is not something that should happen.");
            return;
        }
        this.modsRegistered = true;
        this.modIntegrations.put(ModIds.MIA, new MiaSelfIntegrations());
        if (ModIds.EXTRA_UTILITIES.isLoaded) {
            this.modIntegrations.put(ModIds.EXTRA_UTILITIES, new ExtraUtilities2());
        }
        if (ModIds.COFH_CORE.isLoaded) {
            this.modIntegrations.put(ModIds.COFH_CORE, new CofhCore());
        }
        if (ModIds.THERMAL_FOUNDATION.isLoaded) {
            this.modIntegrations.put(ModIds.THERMAL_FOUNDATION, new ThermalFoundation());
        }
        if (ModIds.THERMAL_EXPANSION.isLoaded) {
            this.modIntegrations.put(ModIds.THERMAL_EXPANSION, new ThermalExpansion());
        }
        if (ModIds.TINKERS_CONSTRUCT.isLoaded) {
            this.modIntegrations.put(ModIds.TINKERS_CONSTRUCT, new TinkersConstruct());
        }
        if (ModIds.JEI.isLoaded) {
            this.modIntegrations.put(ModIds.JEI, new Jei());
        }
        if (ModIds.JER.isLoaded) {
            this.modIntegrations.put(ModIds.JER, new JustEnoughResources());
        }
        if (ModIds.ICE_AND_FIRE.isLoaded) {
            this.modIntegrations.put(ModIds.ICE_AND_FIRE, new IceAndFire());
        }
        if (ModIds.HATCHERY.isLoaded) {
            this.modIntegrations.put(ModIds.HATCHERY, new Hatchery());
        }
        if (ModIds.THAUMCRAFT.isLoaded) {
            this.modIntegrations.put(ModIds.THAUMCRAFT, new Thaumcraft());
        }
        if (ModIds.THE_ONE_PROBE.isLoaded) {
            this.modIntegrations.put(ModIds.THE_ONE_PROBE, new TheOneProbe());
        }
        if (ModIds.MO_CREATURES.isLoaded) {
            this.modIntegrations.put(ModIds.MO_CREATURES, new MoCreatures());
        }
        if (ModIds.DUNGEON_TACTICS.isLoaded) {
            this.modIntegrations.put(ModIds.DUNGEON_TACTICS, new DungeonTactics());
        }
        if (ModIds.HARVESTCRAFT.isLoaded) {
            this.modIntegrations.put(ModIds.HARVESTCRAFT, new Harvestcraft());
        }
        if (ModIds.BOTANIA.isLoaded) {
            this.modIntegrations.put(ModIds.BOTANIA, new Botania());
        }
        if (ModIds.EXTRABOTANY.isLoaded) {
            this.modIntegrations.put(ModIds.EXTRABOTANY, new ExtraBotany());
        }
        if (ModIds.QUARK.isLoaded) {
            this.modIntegrations.put(ModIds.QUARK, new Quark());
        }
        if (ModIds.FUTURE_MC.isLoaded) {
            this.modIntegrations.put(ModIds.FUTURE_MC, new FutureMc());
        }
        if (ModIds.NATURA.isLoaded) {
            this.modIntegrations.put(ModIds.NATURA, new Natura());
        }
        if (ModIds.BIOMES_O_PLENTY.isLoaded) {
            this.modIntegrations.put(ModIds.BIOMES_O_PLENTY, new BiomesOPlenty());
        }
        if (ModIds.CHISEL.isLoaded) {
            this.modIntegrations.put(ModIds.CHISEL, new Chisel());
        }
        if (ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            this.modIntegrations.put(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoing());
        }
        if (ModIds.AETHER.isLoaded) {
            this.modIntegrations.put(ModIds.AETHER, new Aether());
            if (ModIds.AETHER_CONTINUATION.isLoaded) {
                this.modIntegrations.put(ModIds.AETHER_CONTINUATION, new AetherContinuation());
            }
            if (ModIds.AETHER_LOST_CONTENT.isLoaded) {
                this.modIntegrations.put(ModIds.AETHER_LOST_CONTENT, new AetherLostContent());
            }
        }
        if (ModIds.ENDER_IO.isLoaded) {
            this.modIntegrations.put(ModIds.ENDER_IO, new EnderIo());
        }
        if (ModIds.ENDER_IO_ZOO.isLoaded) {
            this.modIntegrations.put(ModIds.ENDER_IO_ZOO, new EnderIoZoo());
        }
        if (ModIds.CHARM.isLoaded) {
            this.modIntegrations.put(ModIds.CHARM, new Charm());
        }
        if (!this.modIntegrations.isEmpty()) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering integrations", (int)this.modIntegrations.size());
            for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
                progressBar.step(mod.getKey().modId);
                mod.getValue().register(this::registerIntegration);
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @ParametersAreNonnullByDefault
    private void registerIntegration(ModIds mod, IModIntegration integration) {
        IBaseMod baseMod = this.modIntegrations.get((Object)mod);
        if (baseMod != null) {
            baseMod.addIntegration(integration);
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
        if (this.modsPreInitialized) {
            Mia.LOGGER.warn("ModIntegrator.preInit() was called more than once, this is not something that should happen.");
            return;
        }
        this.modsPreInitialized = true;
        for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
            try {
                mod.getValue().preInit(event);
            }
            catch (Exception e) {
                Mia.LOGGER.error("An exception occurred in preInit phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                if (event.getSide() != Side.CLIENT) continue;
                ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
            }
        }
    }

    public void init(FMLInitializationEvent event) {
        if (this.modsInitialized) {
            Mia.LOGGER.warn("ModIntegrator.init() was called more than once, this is not something that should happen.");
            return;
        }
        this.modsInitialized = true;
        for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
            try {
                mod.getValue().init(event);
            }
            catch (Exception e) {
                Mia.LOGGER.error("An exception occurred in init phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                if (event.getSide() != Side.CLIENT) continue;
                ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
            }
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (this.modsPostInitialized) {
            Mia.LOGGER.warn("ModIntegrator.postInit() was called more than once, this is not something that should happen.");
            return;
        }
        this.modsPostInitialized = true;
        for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
            try {
                mod.getValue().postInit(event);
            }
            catch (Exception e) {
                Mia.LOGGER.error("An exception occurred in postInit phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                if (event.getSide() != Side.CLIENT) continue;
                ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
            }
        }
    }

    public void loadCompleted(FMLLoadCompleteEvent event) {
        if (this.modsLoadCompleted) {
            Mia.LOGGER.warn("ModIntegrator.loadCompleted() was called more than once, this is not something that should happen.");
            return;
        }
        this.modsLoadCompleted = true;
        for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
            try {
                mod.getValue().loadCompleted(event);
            }
            catch (Exception e) {
                Mia.LOGGER.error("An exception occurred in loadCompleted phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                if (event.getSide() != Side.CLIENT) continue;
                ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
            }
        }
    }

    public void registerBlocks(RegistryEvent.Register<Block> event, Side side) {
        if (this.registeredBlocks) {
            Mia.LOGGER.warn("ModIntegrator.registerBlocks() was called more than once, this is not something that should happen.");
            return;
        }
        this.registeredBlocks = true;
        for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
            try {
                mod.getValue().registerBlocks(event);
            }
            catch (Exception e) {
                Mia.LOGGER.error("An exception occurred in registerBlocks phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                if (side != Side.CLIENT) continue;
                ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
            }
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event, Side side) {
        if (this.registeredItems) {
            Mia.LOGGER.warn("ModIntegrator.registerItems() was called more than once, this is not something that should happen.");
            return;
        }
        this.registeredItems = true;
        for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
            try {
                mod.getValue().registerItems(event);
            }
            catch (Exception e) {
                Mia.LOGGER.error("An exception occurred in registerItems phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                if (side != Side.CLIENT) continue;
                ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenders(ModelRegistryEvent event) {
        if (this.registeredRenders) {
            Mia.LOGGER.warn("ModIntegrator.registerRenders() was called more than once, this is not something that should happen.");
            return;
        }
        this.registeredRenders = true;
        for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
            try {
                mod.getValue().registerRenders(event);
            }
            catch (Exception e) {
                Mia.LOGGER.error("An exception occurred in registerRenders phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
            }
        }
    }

    public void registerLootTableListeners(HashSet<LootTableIntegrator.LootTableListener> integrations, Side side) {
        if (this.registeredLootTableListeners) {
            Mia.LOGGER.warn("ModIntegrator.registerLootTableListeners() was called more than once, this is not something that should happen.");
            return;
        }
        this.registeredLootTableListeners = true;
        for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
            try {
                LootTableIntegrator.LootTableListener listener = mod.getValue().registerLootListener();
                if (listener == null) continue;
                integrations.add(listener);
            }
            catch (Exception e) {
                Mia.LOGGER.error("An exception occurred in registerLootTableListeners phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                if (side != Side.CLIENT) continue;
                ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
            }
        }
    }

    public void registerDispenserBehaviors(Side side) {
        if (this.registeredDispenserBehaviors) {
            Mia.LOGGER.warn("ModIntegrator.registerDispenserBehaviors() was called more than once, this is not something that should happen.");
            return;
        }
        this.registeredDispenserBehaviors = true;
        if (!this.modIntegrations.isEmpty()) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering dispenser behaviors", (int)this.modIntegrations.size());
            for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
                try {
                    progressBar.step(mod.getKey().modId);
                    mod.getValue().registerDispenserBehaviors();
                }
                catch (Exception e) {
                    Mia.LOGGER.error("An exception occurred in registerDispenserBehaviors phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                    if (side != Side.CLIENT) continue;
                    ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Optional.Method(modid="thaumcraft")
    public void registerAspects(AspectRegistryEvent event, Side side) {
        if (this.registeredAspects) {
            Mia.LOGGER.warn("ModIntegrator.registerAspects() was called more than once, this is not something that should happen.");
            return;
        }
        this.registeredAspects = true;
        if (!ThaumcraftConfiguration.registerAspects) {
            return;
        }
        if (this.modIntegrations.size() > 0) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Thaumcraft registerAspects", (int)this.modIntegrations.size());
            for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
                try {
                    progressBar.step(mod.getKey().modId);
                    mod.getValue().registerAspects(event);
                }
                catch (Exception e) {
                    Mia.LOGGER.error("An exception occurred in registerAspects phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                    if (side != Side.CLIENT) continue;
                    ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
        AspectEventProxy register = event.register;
        for (ItemStack bookshelf : OreDictionary.getOres((String)"bookshelf", (boolean)false)) {
            ThaumcraftHelpers.transferAspects(bookshelf, new AspectList().add(Aspect.MIND, 8), register);
        }
        if (Loader.isModLoaded((String)"chickens")) {
            register.registerObjectTag(new ItemStack(ChickensMod.liquidEgg, 1, 0), new AspectList().add(Aspect.WATER, 20));
            register.registerObjectTag(new ItemStack(ChickensMod.liquidEgg, 1, 1), new AspectList().add(Aspect.FIRE, 20));
        }
        if (Loader.isModLoaded((String)"morechickens")) {
            register.registerObjectTag(new ItemStack(ModItems.solidXp), new AspectList().add(Aspect.MIND, 20));
        }
    }

    @Optional.Method(modid="aether_legacy")
    public void registerFreezableFuel(RegistryEvent.Register<AetherFreezableFuel> event, Side side) {
        if (this.registeredAetherFreezable) {
            Mia.LOGGER.warn("ModIntegrator.registerFreezableFuel() was called more than once, this is not something that should happen.");
            return;
        }
        this.registeredAetherFreezable = true;
        if (MiaConfig.disableAllRecipes || !AetherConfig.allowNewFreezerFuel) {
            return;
        }
        if (this.modIntegrations.size() > 0) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Aether registerFreezableFuel", (int)this.modIntegrations.size());
            IForgeRegistry registry = event.getRegistry();
            for (Map.Entry<ModIds, IBaseMod> mod : this.modIntegrations.entrySet()) {
                try {
                    progressBar.step(mod.getKey().modId);
                    mod.getValue().registerFreezableFuel((IForgeRegistry<AetherFreezableFuel>)registry);
                }
                catch (Exception e) {
                    Mia.LOGGER.error("An exception occurred in registerFreezableFuel phase of " + mod.getKey().modId + ", this is not really good... Please let the MIA developer know about this.", (Throwable)e);
                    if (side != Side.CLIENT) continue;
                    ErrorToast.tryAddToast(Minecraft.func_71410_x().func_193033_an());
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }
}

