/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.botania;

import com.github.sokyranthedragon.api.botania.MiaBotaniaAPI;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.block.BlockBotaniaSpecialFlower;
import com.github.sokyranthedragon.mia.config.BotaniaConfiguration;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.ChiselBotaniaIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.DungeonTacticsBotaniaIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.FutureMcBotaniaIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.HatcheryBotaniaIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.IBotaniaIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.JeiBotaniaIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.JerBotaniaIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.ThermalExpansionBotaniaIntegration;
import com.github.sokyranthedragon.mia.integrations.botania.crafting.MiaPetalRecipes;
import com.github.sokyranthedragon.mia.integrations.botania.lexicon.MiaLexiconData;
import com.github.sokyranthedragon.mia.integrations.botania.subtile.SubTileOrechidVacuam;
import com.github.sokyranthedragon.mia.integrations.botania.wiki.PartialSimpleWikiProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.wiki.IWikiProvider;

public class Botania
implements IBaseMod {
    private final Map<ModIds, IBotaniaIntegration> modIntegrations = new HashMap<ModIds, IBotaniaIntegration>();

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (BotaniaConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsBotaniaIntegration());
        }
        if (BotaniaConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionBotaniaIntegration());
        }
        if (ModIds.JEI.isLoaded) {
            modIntegration.accept(ModIds.JEI, new JeiBotaniaIntegration());
        }
        if (BotaniaConfiguration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerBotaniaIntegration());
        }
        if (BotaniaConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcBotaniaIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryBotaniaIntegration(BotaniaConfiguration.enableHatcheryIntegration));
        }
        if (BotaniaConfiguration.enableChiselIntegration && ModIds.CHISEL.isLoaded) {
            modIntegration.accept(ModIds.CHISEL, new ChiselBotaniaIntegration());
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!BotaniaConfiguration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof IBotaniaIntegration) {
            this.modIntegrations.put(integration.getModId(), (IBotaniaIntegration)integration);
        } else {
            Mia.LOGGER.warn("Incorrect Botania integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        BotaniaAPI.registerModWiki((String)ModIds.MIA.modId, (IWikiProvider)new PartialSimpleWikiProvider());
        if (BotaniaConfiguration.botaniaAdditionsEnabled) {
            for (String ore : BotaniaConfiguration.orechidVacuamOreDict) {
                int pos = ore.lastIndexOf(":");
                if (pos > 0 && pos < ore.length() - 1) {
                    String weightString = ore.substring(pos + 1);
                    try {
                        int weight = Integer.parseInt(weightString);
                        if (weight <= 0) continue;
                        MiaBotaniaAPI.addOreWeightEnd(ore.substring(0, pos), weight);
                    }
                    catch (NumberFormatException e) {
                        Mia.LOGGER.warn("Incorrect Orechid Vacuam entry: " + ore);
                    }
                    continue;
                }
                Mia.LOGGER.warn("Incorrect Orechid Vacuam entry: " + ore);
            }
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!this.modIntegrations.isEmpty() && !MiaConfig.disableAllRecipes) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Botania addRecipes", (int)this.modIntegrations.size());
            for (IBotaniaIntegration integration : this.modIntegrations.values()) {
                progressBar.step(integration.getModId().modId);
                integration.addRecipes();
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
        if (BotaniaConfiguration.botaniaAdditionsEnabled) {
            MiaPetalRecipes.init();
            MiaLexiconData.init();
        }
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        if (BotaniaConfiguration.botaniaAdditionsEnabled) {
            BotaniaAPI.registerSubTile((String)"orechidVacuam", SubTileOrechidVacuam.class);
            MiaBlocks.blockBotaniaSpecialFlower = new BlockBotaniaSpecialFlower();
            MiaBlocks.blocks.add(MiaBlocks.blockBotaniaSpecialFlower);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenders(ModelRegistryEvent event) {
        if (BotaniaConfiguration.botaniaAdditionsEnabled) {
            BotaniaAPIClient.registerSubtileModel(SubTileOrechidVacuam.class, (ModelResourceLocation)new ModelResourceLocation(ModIds.BOTANIA.modId + ":orechidVacuam"));
        }
    }
}

