/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.charm;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.thermalexpansion.IThermalExpansionIntegration;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.TinkerRegistry;
import svenhjol.charm.Charm;
import svenhjol.charm.automation.feature.GunpowderBlock;
import svenhjol.charm.automation.feature.RedstoneSand;
import svenhjol.charm.crafting.feature.Barrel;
import svenhjol.charm.crafting.feature.BookshelfChest;
import svenhjol.charm.crafting.feature.Crate;
import svenhjol.charm.crafting.feature.EnderPearlBlock;
import svenhjol.charm.crafting.feature.Lantern;
import svenhjol.charm.crafting.feature.RottenFleshBlock;
import svenhjol.charm.crafting.feature.SmoothGlowstone;
import svenhjol.charm.enchanting.feature.CurseBreak;
import svenhjol.charm.enchanting.feature.Homing;
import svenhjol.charm.enchanting.feature.Magnetic;
import svenhjol.charm.enchanting.feature.Salvage;
import svenhjol.charm.world.feature.ChargedEmeralds;
import svenhjol.charm.world.feature.Moonstone;
import svenhjol.meson.MesonBlock;

class ThermalExpansionCharmIntegration
implements IThermalExpansionIntegration {
    ThermalExpansionCharmIntegration() {
    }

    @Override
    public void addRecipes() {
        ItemStack target;
        if (Charm.hasFeature(Lantern.class)) {
            if (Lantern.ironLantern != null) {
                SmelterManager.addRecycleRecipe((int)2000, (ItemStack)new ItemStack((Block)Lantern.ironLantern), (ItemStack)new ItemStack(Items.field_191525_da), (int)8);
            }
            if (Lantern.goldLantern != null) {
                SmelterManager.addRecycleRecipe((int)2000, (ItemStack)new ItemStack((Block)Lantern.goldLantern), (ItemStack)new ItemStack(Items.field_151074_bl), (int)8);
            }
        }
        if (Charm.hasFeature(SmoothGlowstone.class)) {
            PulverizerManager.addRecipe((int)4000, (ItemStack)new ItemStack((Block)SmoothGlowstone.block), (ItemStack)new ItemStack(Items.field_151114_aO, 4));
            CrucibleManager.addRecipe((int)80000, (ItemStack)new ItemStack((Block)SmoothGlowstone.block), (FluidStack)new FluidStack(TFFluids.fluidGlowstone, 1000));
            if (ModIds.TINKERS_CONSTRUCT.isLoaded) {
                ThermalExpansionCharmIntegration.addTinkerSmelting(new ItemStack((Block)SmoothGlowstone.block), TFFluids.fluidGlowstone, 1000);
            }
        }
        if (Charm.hasFeature(EnderPearlBlock.class)) {
            CrucibleManager.addRecipe((int)180000, (ItemStack)new ItemStack((Block)EnderPearlBlock.block), (FluidStack)new FluidStack(TFFluids.fluidEnder, 2250));
            if (ModIds.TINKERS_CONSTRUCT.isLoaded) {
                ThermalExpansionCharmIntegration.addTinkerSmelting(new ItemStack((Block)EnderPearlBlock.block), TFFluids.fluidEnder, 2250);
            }
        }
        if (Charm.hasFeature(Barrel.class)) {
            for (MesonBlock.WoodVariant variant : MesonBlock.WoodVariant.values()) {
                SawmillManager.addRecycleRecipe((int)2000, (ItemStack)new ItemStack((Block)Barrel.block, 1, variant.ordinal()), (ItemStack)new ItemStack(Blocks.field_150344_f, 1, variant.ordinal()), (int)3);
            }
        }
        if (Charm.hasFeature(Crate.class)) {
            SawmillManager.addRecipe((int)2000, (ItemStack)new ItemStack((Block)Crate.crate), (ItemStack)new ItemStack(Items.field_151042_j, 4, Short.MAX_VALUE), (ItemStack)ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)8));
        }
        if (Charm.hasFeature(BookshelfChest.class)) {
            PulverizerManager.addRecipe((int)4000, (ItemStack)new ItemStack((Block)BookshelfChest.bookshelfChest), (ItemStack)ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)32), (ItemStack)new ItemStack(Items.field_151122_aG), (int)150);
        }
        if (Charm.hasFeature(CurseBreak.class)) {
            target = ItemStack.field_190927_a;
            if (Charm.hasFeature(ChargedEmeralds.class)) {
                target = new ItemStack((Item)ChargedEmeralds.emerald);
            } else if (Charm.hasFeature(GunpowderBlock.class)) {
                target = new ItemStack((Block)GunpowderBlock.block, 4);
            } else if (Charm.hasFeature(Moonstone.class)) {
                target = new ItemStack((Item)Moonstone.moonstone, 8, 2);
            }
            if (!target.func_190926_b()) {
                EnchanterManager.addDefaultEnchantmentRecipe((ItemStack)target, (String)"charm:curse_break", (int)2);
            }
        }
        if (Charm.hasFeature(Homing.class)) {
            target = ItemStack.field_190927_a;
            if (Charm.hasFeature(EnderPearlBlock.class)) {
                target = new ItemStack((Block)EnderPearlBlock.block, 1);
            } else if (Charm.hasFeature(RedstoneSand.class)) {
                target = new ItemStack((Block)RedstoneSand.block, 4);
            } else if (Charm.hasFeature(Moonstone.class)) {
                target = new ItemStack((Item)Moonstone.moonstone, 8, 11);
            }
            if (!target.func_190926_b()) {
                EnchanterManager.addDefaultEnchantmentRecipe((ItemStack)target, (String)"charm:homing", (int)2);
            }
        }
        if (Charm.hasFeature(Magnetic.class)) {
            target = ItemStack.field_190927_a;
            if (Charm.hasFeature(Lantern.class)) {
                if (Lantern.ironLantern != null) {
                    target = new ItemStack((Block)Lantern.ironLantern, 8);
                } else if (Lantern.goldLantern != null) {
                    target = new ItemStack((Block)Lantern.goldLantern, 8);
                }
            }
            if (target.func_190926_b() && Charm.hasFeature(Moonstone.class)) {
                target = new ItemStack((Item)Moonstone.moonstone, 8, 8);
            }
            if (!target.func_190926_b()) {
                EnchanterManager.addDefaultEnchantmentRecipe((ItemStack)target, (String)"charm:magnetic", (int)2);
            }
        }
        if (Charm.hasFeature(Salvage.class)) {
            target = ItemStack.field_190927_a;
            if (Charm.hasFeature(SmoothGlowstone.class)) {
                target = new ItemStack((Block)SmoothGlowstone.block, 4);
            } else if (Charm.hasFeature(RottenFleshBlock.class)) {
                target = new ItemStack((Block)RottenFleshBlock.block, 8);
            } else if (Charm.hasFeature(Moonstone.class)) {
                target = new ItemStack((Item)Moonstone.moonstone, 8, 4);
            }
            if (!target.func_190926_b()) {
                EnchanterManager.addDefaultEnchantmentRecipe((ItemStack)target, (String)"charm:salvage", (int)2);
            }
        }
    }

    private static void addTinkerSmelting(ItemStack input, Fluid output, int outputCount) {
        TinkerRegistry.registerMelting((ItemStack)input, (Fluid)output, (int)outputCount);
    }

    @Override
    @NotNull
    public ModIds getModId() {
        return ModIds.CHARM;
    }
}

