/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.dungeontactics;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.DungeonTacticsConfiguration;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.dispenserbehavior.DispenserLootBag;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.base.LootTableIntegrator;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.ChiselDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.FutureMcDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.HatcheryDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.IDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.IndustrialForegoingDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.JeiDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.JerDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.QuarkDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.TConstructDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.ThermalExpansionDungeonTacticsIntegration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTFireworkHelper;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.DTLoots;
import pegbeard.dungeontactics.items.DTLootBagGeneric;

public class DungeonTactics
implements IBaseMod {
    private final List<IDungeonTacticsIntegration> modIntegrations = new LinkedList<IDungeonTacticsIntegration>();

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        boolean recent = ModIds.DUNGEON_TACTICS.isSpecifiedVersion("[DT-0.16.7,]");
        if (DungeonTacticsConfiguration.enableTConstructIntegration && ModIds.TINKERS_CONSTRUCT.isLoaded) {
            modIntegration.accept(ModIds.TINKERS_CONSTRUCT, new TConstructDungeonTacticsIntegration());
        }
        if (recent && DungeonTacticsConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionDungeonTacticsIntegration());
        }
        if (ModIds.JEI.isLoaded) {
            modIntegration.accept(ModIds.JEI, new JeiDungeonTacticsIntegration());
        }
        if (DungeonTacticsConfiguration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerDungeonTacticsIntegration());
        }
        if (DungeonTacticsConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcDungeonTacticsIntegration());
        }
        if (DungeonTacticsConfiguration.enableQuarkIntegration && ModIds.QUARK.isLoaded) {
            modIntegration.accept(ModIds.QUARK, new QuarkDungeonTacticsIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryDungeonTacticsIntegration(DungeonTacticsConfiguration.enableHatcheryIntegration));
        }
        if (DungeonTacticsConfiguration.enableChiselIntegration && ModIds.CHISEL.isLoaded) {
            modIntegration.accept(ModIds.CHISEL, new ChiselDungeonTacticsIntegration());
        }
        if (DungeonTacticsConfiguration.enableIFIntegration && ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            modIntegration.accept(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoingDungeonTacticsIntegration());
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (integration instanceof IDungeonTacticsIntegration) {
            this.modIntegrations.add((IDungeonTacticsIntegration)integration);
            return;
        }
        Mia.LOGGER.warn("Incorrect DT integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
    }

    @Override
    @Nullable
    public LootTableIntegrator.LootTableListener registerLootListener() {
        if (!DungeonTacticsConfiguration.registerCustomBagLoot || this.modIntegrations.isEmpty()) {
            return null;
        }
        LootBagLootTableHandler lootBag = new LootBagLootTableHandler();
        boolean anyListener = false;
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"DungeonTactics registerLootBagListener", (int)this.modIntegrations.size());
        for (IDungeonTacticsIntegration integration : this.modIntegrations) {
            progressBar.step(integration.getModId().modId);
            ILootBagListener listener = integration.registerLootBagListener();
            if (listener == null) continue;
            anyListener = true;
            lootBag.addIntegration(listener);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        if (anyListener) {
            return lootBag::insertBagLoot;
        }
        return null;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!DungeonTacticsConfiguration.dungeonTacticsAdditionsEnabled) {
            return;
        }
        if (!MiaConfig.disableOreDict) {
            OreDictionary.registerOre((String)"blockGlass", (Block)DTBlocks.DUNGEON_GLASS);
            OreDictionary.registerOre((String)"listAllberry", (Item)DTItems.CHERRYBOMB);
            OreDictionary.registerOre((String)"listAllfruit", (Item)DTItems.CHERRYBOMB);
            OreDictionary.registerOre((String)"listAllberry", (Item)DTItems.INCINDIBERRY);
            OreDictionary.registerOre((String)"listAllfruit", (Item)DTItems.INCINDIBERRY);
            OreDictionary.registerOre((String)"listAllberry", (Item)DTItems.GLOWCURRENT);
            OreDictionary.registerOre((String)"listAllfruit", (Item)DTItems.GLOWCURRENT);
            OreDictionary.registerOre((String)"foodToast", (Item)DTItems.TOAST);
            OreDictionary.registerOre((String)"foodToastslice", (Item)DTItems.TOASTSLICE);
            OreDictionary.registerOre((String)"foodJamtoast", (Item)DTItems.JAMSLICE);
            OreDictionary.registerOre((String)"foodBreadslice", (Item)DTItems.BREADSLICE);
            OreDictionary.registerOre((String)"flourEqualswheat", (Item)DTItems.FLOUR);
            OreDictionary.registerOre((String)"oreNetherGold", (Block)DTBlocks.NETHER_GOLD);
            OreDictionary.registerOre((String)"oreEndDiamond", (Block)DTBlocks.END_DIAMOND);
            OreDictionary.registerOre((String)"oreEndLapis", (Block)DTBlocks.END_LAPIS);
            OreDictionary.registerOre((String)"obsidian", (Block)DTBlocks.OBSIDIAN_BRICK);
        }
    }

    @Override
    public void registerDispenserBehaviors() {
        if (ModIds.DUNGEON_TACTICS.isSpecifiedVersion("[DT-0.16.9,]")) {
            DungeonTactics.registerDispenser();
        }
    }

    private static void registerDispenser() {
        DispenserLootBag.getInstance().addListener((source, stack) -> {
            int rand;
            ResourceLocation drop;
            if (!(stack.func_77973_b() instanceof DTLootBagGeneric)) {
                return false;
            }
            Item item = stack.func_77973_b();
            IBehaviorDispenseItem defaultDispenserBehavior = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a(null);
            if (item == DTItems.BAG_FOOD) {
                drop = DTLoots.FOOD_LOOT;
            } else if (item == DTItems.BAG_ARBOUR) {
                drop = DTLoots.ARBOUR_LOOT;
            } else if (item == DTItems.BAG_ORE) {
                drop = DTLoots.ORE_LOOT;
            } else if (item == DTItems.BAG_TOOL) {
                drop = DTLoots.TOOL_LOOT;
            } else if (item == DTItems.BAG_BOOK) {
                drop = DTLoots.BOOK_LOOT;
            } else if (item == DTItems.BAG_QUIVER) {
                drop = DTLoots.QUIVER_LOOT;
            } else if (item == DTItems.BAG_MAGIC) {
                drop = DTLoots.MAGIC_LOOT;
            } else if (item == DTItems.BAG_POTION) {
                drop = DTLoots.POTION_LOOT;
            } else if (item == DTItems.BAG_RECORD) {
                drop = DTLoots.RECORD_LOOT;
            } else if (item == DTItems.BAG_MYSTERY) {
                drop = DTLoots.MYSTERY_LOOT;
            } else if (item == DTItems.BAG_STARTER) {
                drop = DTLoots.STARTER_LOOT;
            } else if (item == DTItems.BAG_SAMHAIN) {
                rand = source.func_82618_k().field_73012_v.nextInt(6);
                if (rand == 0) {
                    ((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)DTItems.BOMB_FRAG)).func_82482_a(source, new ItemStack(DTItems.BOMB_FRAG));
                    stack.func_190918_g(1);
                    return true;
                }
                if (rand > 2) {
                    ItemStack firework = DTFireworkHelper.samhainRocket();
                    stack.func_190918_g(1);
                    ((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)firework.func_77973_b())).func_82482_a(source, firework.func_77946_l());
                    defaultDispenserBehavior.func_82482_a(source, firework);
                    return true;
                }
                drop = DTLoots.SAMHAIN_LOOT;
            } else {
                if (item != DTItems.BAG_SOLSTICE) {
                    return false;
                }
                rand = source.func_82618_k().field_73012_v.nextInt(6);
                if (rand == 0) {
                    defaultDispenserBehavior.func_82482_a(source, new ItemStack(Items.field_151044_h));
                    stack.func_190918_g(1);
                    return true;
                }
                if (rand > 2) {
                    ItemStack firework = DTFireworkHelper.solsticeRocket();
                    stack.func_190918_g(1);
                    ((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)firework.func_77973_b())).func_82482_a(source, firework);
                    defaultDispenserBehavior.func_82482_a(source, firework);
                    return true;
                }
                drop = DTLoots.SOLSTICE_LOOT;
            }
            assert (source.func_82618_k() instanceof WorldServer);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)source.func_82618_k());
            List lootDrops = source.func_82618_k().func_184146_ak().func_186521_a(drop).func_186462_a(source.func_82618_k().field_73012_v, builder.func_186471_a());
            Iterator iterator = lootDrops.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    stack.func_190918_g(1);
                    return true;
                }
                ItemStack lootDrop = (ItemStack)iterator.next();
                defaultDispenserBehavior.func_82482_a(source, lootDrop);
            }
        }, DTItems.BAG_ARBOUR, DTItems.BAG_ORE, DTItems.BAG_TOOL, DTItems.BAG_BOOK, DTItems.BAG_QUIVER, DTItems.BAG_MAGIC, DTItems.BAG_POTION, DTItems.BAG_RECORD, DTItems.BAG_SAMHAIN, DTItems.BAG_SOLSTICE, DTItems.BAG_MYSTERY, DTItems.BAG_STARTER);
    }

    private static class LootBagLootTableHandler {
        private HashSet<ILootBagListener> integrations = new HashSet();

        public void addIntegration(ILootBagListener integration) {
            this.integrations.add(integration);
        }

        public void insertBagLoot(LootTableLoadEvent event) {
            LootPool main = event.getTable().getPool("main");
            IDungeonTacticsIntegration.BagTypes bagTypes = null;
            if (event.getName().equals((Object)DTLoots.ARBOUR_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.ARBOUR;
            } else if (event.getName().equals((Object)DTLoots.BOOK_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.BOOK;
            } else if (event.getName().equals((Object)DTLoots.FOOD_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.FOOD;
            } else if (event.getName().equals((Object)DTLoots.MAGIC_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.MAGIC;
            } else if (event.getName().equals((Object)DTLoots.ORE_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.ORE;
            } else if (event.getName().equals((Object)DTLoots.POTION_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.POTION;
            } else if (event.getName().equals((Object)DTLoots.QUIVER_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.QUIVER;
            } else if (event.getName().equals((Object)DTLoots.RECORD_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.RECORD;
            } else if (event.getName().equals((Object)DTLoots.SAMHAIN_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.SAMHAIN;
            } else if (event.getName().equals((Object)DTLoots.SOLSTICE_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.SOLSTICE;
            } else if (event.getName().equals((Object)DTLoots.TOOL_LOOT)) {
                bagTypes = IDungeonTacticsIntegration.BagTypes.TOOL;
            }
            if (bagTypes != null) {
                for (ILootBagListener integration : this.integrations) {
                    integration.insertBagLoot(bagTypes, main);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface ILootBagListener {
        public void insertBagLoot(IDungeonTacticsIntegration.BagTypes var1, LootPool var2);
    }
}

