/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.dungeontactics;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IMobRegistry;
import jeresources.api.IPlantRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import pegbeard.dungeontactics.entities.DTEntityTowerGuardian;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.DTLoots;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class JerDungeonTacticsIntegration
implements IJerIntegration {
    JerDungeonTacticsIntegration() {
    }

    @Override
    public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
        builder.add(DTLoots.TOWERGUARDIAN_LOOT, DTEntityTowerGuardian.class);
    }

    @Override
    public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        if (entity instanceof DTEntityTowerGuardian) {
            mobRegistry.register(entity, LightLevel.any, resource);
        }
    }

    @Override
    public void overrideExistingMobDrops(MobEntry mobEntry) {
        if (mobEntry.getEntity() instanceof EntityWither || mobEntry.getEntity() instanceof EntityDragon || mobEntry.getEntity() instanceof EntityGuardian) {
            if (DTConfigHandler.hearts != 0) {
                mobEntry.addDrops(new LootDrop[]{new LootDrop(DTItems.HEART_JAR, 0, 2, new Conditional[0])});
                mobEntry.addDrops(new LootDrop[]{new LootDrop(DTItems.HEART_GOLDEN, 0, 1, new Conditional[0])});
            }
            if (mobEntry.getEntity() instanceof EntityWither) {
                float chance = (float)DTConfigHandler.boneCharms / 100.0f;
                float charmChance = chance * 2.0f / 10.0f;
                mobEntry.addDrop(new LootDrop(DTItems.PHYLACTERY, chance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_BARREN, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_BLEAK, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_DARKENED, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_EMACIATED, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_FAMINE, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_HEAVY, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_SAPPING, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_SEARING, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_TOXIC, charmChance, new LootFunction[0]));
                mobEntry.addDrop(new LootDrop(DTItems.CHARM_UNINTELLIGIBLE, charmChance, new LootFunction[0]));
            }
        }
    }

    @Override
    public void addDungeonLoot(IDungeonRegistry dungeonRegistry, World world) {
        String dungeon = "chests/dt_dungeon";
        String tower = "chests/dt_tower";
        String miniBunker = "chests/dt_mini_bunker";
        String pirateShip = "chests/dt_pirate_ship";
        String gypsyWagon = "chests/dt_gypsy_wagon";
        String wizardTower = "chests/dt_wizard_tower";
        dungeonRegistry.registerCategory("chests/dt_dungeon", "mia.jer.dungeon.dt_dungeon");
        dungeonRegistry.registerCategory("chests/dt_tower", "mia.jer.dungeon.dt_tower");
        dungeonRegistry.registerCategory("chests/dt_mini_bunker", "mia.jer.dungeon.dt_mini_bunker");
        dungeonRegistry.registerCategory("chests/dt_pirate_ship", "mia.jer.dungeon.dt_pirate_ship");
        dungeonRegistry.registerCategory("chests/dt_gypsy_wagon", "mia.jer.dungeon.dt_gypsy_wagon");
        dungeonRegistry.registerCategory("chests/dt_wizard_tower", "mia.jer.dungeon.dt_wizard_tower");
        dungeonRegistry.registerChest("chests/dt_dungeon", LootTableList.field_186425_g);
        dungeonRegistry.registerChest("chests/dt_dungeon", LootTableList.field_186422_d);
        dungeonRegistry.registerChest("chests/dt_tower", LootTableList.field_186425_g);
        dungeonRegistry.registerChest("chests/dt_tower", LootTableList.field_186422_d);
        dungeonRegistry.registerChest("chests/dt_tower", LootTableList.field_186420_b);
        dungeonRegistry.registerChest("chests/dt_tower", LootTableList.field_186423_e);
        dungeonRegistry.registerChest("chests/dt_mini_bunker", LootTableList.field_186428_j);
        dungeonRegistry.registerChest("chests/dt_pirate_ship", LootTableList.field_186423_e);
        dungeonRegistry.registerChest("chests/dt_pirate_ship", LootTableList.field_186428_j);
        dungeonRegistry.registerChest("chests/dt_pirate_ship", LootTableList.field_186422_d);
        dungeonRegistry.registerChest("chests/dt_gypsy_wagon", DTLoots.WAGGON_LOOT);
        dungeonRegistry.registerChest("chests/dt_wizard_tower", LootTableList.field_186426_h);
        dungeonRegistry.registerChest("chests/dt_wizard_tower", DTLoots.TOWER_INGREDIANTS);
        dungeonRegistry.registerChest("chests/dt_wizard_tower", DTLoots.TOWER_MAGIC);
        dungeonRegistry.registerChest("chests/dt_wizard_tower", LootTableList.field_186426_h);
    }

    @Override
    public void addPlantDrops(IPlantRegistry plantRegistry, @Nullable Collection<PlantEntry> registers) {
        plantRegistry.registerWithSoil(new ItemStack(DTBlocks.CHERRYBOMB_BUSH), Blocks.field_150349_c.func_176223_P(), new PlantDrop[]{new PlantDrop(new ItemStack(DTItems.CHERRYBOMB), 1, 3)});
        plantRegistry.registerWithSoil(new ItemStack(DTBlocks.INCINDIBERRY_BUSH), Blocks.field_150349_c.func_176223_P(), new PlantDrop[]{new PlantDrop(new ItemStack(DTItems.INCINDIBERRY), 1, 3)});
        plantRegistry.registerWithSoil(new ItemStack(DTBlocks.GLOWCURRENT_BUSH), Blocks.field_150349_c.func_176223_P(), new PlantDrop[]{new PlantDrop(new ItemStack(DTItems.GLOWCURRENT), 1, 3)});
    }

    @Override
    public ModIds getModId() {
        return ModIds.DUNGEON_TACTICS;
    }
}

