/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.futuremc;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomPlantEntry;
import com.github.sokyranthedragon.mia.utilities.LootTableUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IMobRegistry;
import jeresources.api.IPlantRegistry;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableManager;
import thedarkcolour.futuremc.config.FConfig;
import thedarkcolour.futuremc.entity.bee.EntityBee;
import thedarkcolour.futuremc.entity.fish.cod.EntityCod;
import thedarkcolour.futuremc.entity.fish.pufferfish.EntityPufferfish;
import thedarkcolour.futuremc.entity.fish.salmon.EntitySalmon;
import thedarkcolour.futuremc.entity.fish.tropical.EntityTropicalFish;
import thedarkcolour.futuremc.entity.panda.EntityPanda;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.registry.FItems;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
class JerFutureMcIntegration
implements IJerIntegration {
    JerFutureMcIntegration() {
    }

    @Override
    public void addPlantDrops(IPlantRegistry plantRegistry, @Nullable Collection<PlantEntry> registers) {
        if (registers != null) {
            CustomPlantEntry sweetBerry = new CustomPlantEntry(new ItemStack((Item)FItems.INSTANCE.getSWEET_BERRIES()), FBlocks.INSTANCE.getSWEET_BERRY_BUSH().func_176223_P(), new PlantDrop(new ItemStack((Item)FItems.INSTANCE.getSWEET_BERRIES()), 1, 3));
            sweetBerry.setSoil(Blocks.field_150349_c.func_176223_P());
            registers.add(sweetBerry);
        } else {
            plantRegistry.registerWithSoil(new ItemStack((Item)FItems.INSTANCE.getSWEET_BERRIES()), Blocks.field_150349_c.func_176223_P(), new PlantDrop[]{new PlantDrop(new ItemStack((Item)FItems.INSTANCE.getSWEET_BERRIES()), 3, 3)});
        }
    }

    @Override
    public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
        if (FConfig.INSTANCE.getVillageAndPillage().panda && FConfig.INSTANCE.getVillageAndPillage().bamboo.enabled) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityPanda.class);
        }
        if (FConfig.INSTANCE.getBuzzyBees().bee.enabled) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityBee.class);
        }
        if (FConfig.INSTANCE.getUpdateAquatic().fish.cod.enabled) {
            builder.add(EntityCod.Companion.getLOOT_TABLE(), EntityCod.class);
        }
        if (FConfig.INSTANCE.getUpdateAquatic().fish.pufferfish.enabled) {
            builder.add(EntityPufferfish.Companion.getLOOT_TABLE(), EntityPufferfish.class);
        }
        if (FConfig.INSTANCE.getUpdateAquatic().fish.salmon.enabled) {
            builder.add(EntitySalmon.Companion.getLOOT_TABLE(), EntitySalmon.class);
        }
        if (FConfig.INSTANCE.getUpdateAquatic().fish.tropicalFish.enabled) {
            builder.add(EntityTropicalFish.Companion.getLOOT_TABLE(), EntityTropicalFish.class);
        }
    }

    @Override
    public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        LightLevel lightLevel = LightLevel.any;
        String[] validBiomes = null;
        int minExp = 1;
        int maxExp = 3;
        if (entity instanceof EntityPanda) {
            validBiomes = (String[])Stream.of(Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_185446_X).map(Biome::func_185359_l).toArray(String[]::new);
        } else {
            if (entity instanceof EntityBee) {
                validBiomes = FConfig.INSTANCE.getBuzzyBees().validBiomesForBeeNest;
            } else if (entity instanceof EntityCod) {
                validBiomes = FConfig.INSTANCE.getUpdateAquatic().fish.cod.validBiomes;
            } else if (entity instanceof EntityPufferfish) {
                validBiomes = FConfig.INSTANCE.getUpdateAquatic().fish.pufferfish.validBiomes;
            } else if (entity instanceof EntitySalmon) {
                validBiomes = FConfig.INSTANCE.getUpdateAquatic().fish.salmon.validBiomes;
            } else if (entity instanceof EntityTropicalFish) {
                validBiomes = FConfig.INSTANCE.getUpdateAquatic().fish.tropicalFish.validBiomes;
            }
            if (validBiomes != null) {
                validBiomes = (String[])Arrays.stream(validBiomes).map(s -> {
                    String[] split = s.split(":", 3);
                    return split[0] + ":" + split[1];
                }).toArray(String[]::new);
            }
        }
        if (validBiomes == null) {
            mobRegistry.register(entity, lightLevel, minExp, maxExp, resource);
        } else {
            mobRegistry.register(entity, lightLevel, minExp, maxExp, validBiomes, resource);
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.FUTURE_MC;
    }
}

