/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.harvestcraft;

import com.github.sokyranthedragon.mia.integrations.harvestcraft.HarvestcraftRecipes;
import com.github.sokyranthedragon.mia.utilities.ItemStackUtils;
import com.pam.harvestcraft.tileentities.MarketData;
import com.pam.harvestcraft.tileentities.ShippingBinData;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenDoc;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mia.harvestcraft")
@ZenRegister
@ModOnly(value="harvestcraft")
public class CraftTweakerHarvestcraftIntegration {
    private static Set<ItemStack> marketRemove = new HashSet<ItemStack>();
    private static Set<ItemStack> shippingBinRemove = new HashSet<ItemStack>();
    private static Set<ItemStack> pressingRemove = new HashSet<ItemStack>();
    private static Set<ItemStack> grindingRemove = new HashSet<ItemStack>();
    private static Set<ItemStack> waterFilteringRemove = new HashSet<ItemStack>();

    public static void applyRemovals() {
        Optional<ItemStack> result;
        if (HarvestcraftRecipes.marketRecipes != null) {
            for (ItemStack item : marketRemove) {
                HarvestcraftRecipes.marketRecipes.removeIf(recipe -> ItemStackUtils.areItemStackEqualIgnoreCount(item, recipe.getItem()));
            }
        }
        if (HarvestcraftRecipes.shippingRecipes != null) {
            for (ItemStack item : shippingBinRemove) {
                HarvestcraftRecipes.shippingRecipes.removeIf(recipe -> ItemStackUtils.areItemStackEqualIgnoreCount(item, recipe.getCurrency()));
            }
        }
        if (HarvestcraftRecipes.pressingRecipes != null) {
            for (ItemStack item : pressingRemove) {
                result = HarvestcraftRecipes.pressingRecipes.keySet().stream().filter(entry -> CraftTweakerHarvestcraftIntegration.isSameItem(item, entry)).findAny();
                if (result.isPresent()) {
                    HarvestcraftRecipes.pressingRecipes.remove(result.get());
                    continue;
                }
                CraftTweakerAPI.logInfo((String)("Cannot remove non-existent recipe, input: " + item.toString()));
            }
        }
        if (HarvestcraftRecipes.grindingRecipes != null) {
            for (ItemStack item : grindingRemove) {
                result = HarvestcraftRecipes.grindingRecipes.keySet().stream().filter(entry -> CraftTweakerHarvestcraftIntegration.isSameItem(item, entry)).findAny();
                if (result.isPresent()) {
                    HarvestcraftRecipes.grindingRecipes.remove(result.get());
                    continue;
                }
                CraftTweakerAPI.logInfo((String)("Cannot remove non-existent recipe, input: " + item.toString()));
            }
        }
        if (HarvestcraftRecipes.waterFilterRecipes != null) {
            for (ItemStack item : waterFilteringRemove) {
                result = HarvestcraftRecipes.waterFilterRecipes.keySet().stream().filter(entry -> CraftTweakerHarvestcraftIntegration.isSameItem(item, entry)).findAny();
                if (result.isPresent()) {
                    HarvestcraftRecipes.waterFilterRecipes.remove(result.get());
                    continue;
                }
                CraftTweakerAPI.logInfo((String)("Cannot remove non-existent recipe, input: " + item.toString()));
            }
        }
        marketRemove = null;
        shippingBinRemove = null;
        pressingRemove = null;
        grindingRemove = null;
        waterFilteringRemove = null;
    }

    @ZenMethod
    @ZenDoc(value="Check whether or not new market recipes can be added using 'addMarketRecipe'.\r\nThis should be checked before adding any recipes to prevent (potential) error spam.")
    public static boolean canAccessMarketRecipes() {
        return HarvestcraftRecipes.marketRecipes != null;
    }

    @ZenMethod
    @ZenDoc(value="Adds a new entry to the market.\r\nThe correct cost is between 1 and max stack size, changed automatically to closest valid value if it's set outside this range.\r\nIf input item is not set then emeralds will be used by default.")
    public static void addMarketRecipe(IItemStack output, int cost, @stanhebben.zenscript.annotations.Optional IItemStack input) {
        ItemStack inputStack;
        if (HarvestcraftRecipes.marketRecipes == null) {
            CraftTweakerAPI.logError((String)"Market recipes couldn't be accessed during initialization, it's not possible to add any new ones. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (output == null || output.isEmpty()) {
            CraftTweakerAPI.logError((String)"Output does not exist!");
            return;
        }
        ItemStack outputStack = CraftTweakerMC.getItemStack((IItemStack)output);
        if (cost <= 0) {
            cost = 1;
        }
        if (cost > (inputStack = input == null || input.isEmpty() ? new ItemStack(Items.field_151166_bC) : CraftTweakerMC.getItemStack((IItemStack)input)).func_77976_d()) {
            cost = inputStack.func_77976_d();
        }
        if (!HarvestcraftRecipes.doesMarketRecipeExist(outputStack, inputStack)) {
            HarvestcraftRecipes.marketRecipes.add(new MarketData(outputStack, inputStack, cost));
        } else {
            CraftTweakerAPI.logWarning((String)"Market recipe already exists!");
            CraftTweakerAPI.logWarning((String)("Input: " + inputStack.toString()));
            CraftTweakerAPI.logWarning((String)("Output: " + outputStack.toString()));
        }
    }

    @ZenMethod
    @ZenDoc(value="Removes an entry from the market.")
    public static void removeMarketRecipe(IItemStack output) {
        if (HarvestcraftRecipes.marketRecipes == null) {
            CraftTweakerAPI.logError((String)"Market recipes couldn't be accessed during initialization, it's not possible to remove any of them. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (output == null || output.isEmpty()) {
            CraftTweakerAPI.logError((String)"Output does not exist!");
            return;
        }
        marketRemove.add(CraftTweakerMC.getItemStack((IItemStack)output));
    }

    @ZenMethod
    @ZenDoc(value="Check whether or not new market recipes can be added using 'addShippingBinRecipe'.\r\nThis should be checked before adding any recipes to prevent (potential) error spam.")
    public static boolean canAccessShippingBinRecipes() {
        return HarvestcraftRecipes.shippingRecipes != null;
    }

    @ZenMethod
    @ZenDoc(value="Adds a new entry to the shipping bin.\r\nThe correct cost is between 1 and max stack size, changed automatically to closest valid value if it's set outside this range.\r\nIf output item is not set then emeralds will be used by default.")
    public static void addShippingBinRecipe(IItemStack input, int cost, @stanhebben.zenscript.annotations.Optional IItemStack output) {
        if (HarvestcraftRecipes.shippingRecipes == null) {
            CraftTweakerAPI.logError((String)"Shipping bin recipes couldn't be accessed during initialization, it's not possible to add any new ones. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (input == null || input.isEmpty()) {
            CraftTweakerAPI.logError((String)"Input does not exist!");
            return;
        }
        ItemStack inputStack = CraftTweakerMC.getItemStack((IItemStack)input);
        if (cost <= 0) {
            cost = 1;
        }
        ItemStack outputStack = output == null || output.isEmpty() ? new ItemStack(Items.field_151166_bC) : CraftTweakerMC.getItemStack((IItemStack)output);
        if (cost > inputStack.func_77976_d()) {
            cost = inputStack.func_77976_d();
        }
        if (!HarvestcraftRecipes.doesShippingRecipeExist(inputStack, outputStack)) {
            HarvestcraftRecipes.shippingRecipes.add(new ShippingBinData(outputStack, inputStack, cost));
        } else {
            CraftTweakerAPI.logWarning((String)"Shipping bin recipe already exists!");
            CraftTweakerAPI.logWarning((String)("Input: " + inputStack.toString()));
            CraftTweakerAPI.logWarning((String)("Output: " + outputStack.toString()));
            CraftTweakerAPI.logWarning((String)("Cost: " + cost));
        }
    }

    @ZenMethod
    @ZenDoc(value="Removes an entry from the shipping bin.")
    public static void removeShippingBinRecipe(IItemStack input) {
        if (HarvestcraftRecipes.shippingRecipes == null) {
            CraftTweakerAPI.logError((String)"Shipping bin recipes couldn't be accessed during initialization, it's not possible to remove any of them. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (input == null || input.isEmpty()) {
            CraftTweakerAPI.logError((String)"Input does not exist!");
            return;
        }
        shippingBinRemove.add(CraftTweakerMC.getItemStack((IItemStack)input));
    }

    @ZenMethod
    @ZenDoc(value="Check whether or not new market recipes can be added using 'addShippingBinRecipe' or removed using 'removePressingRecipe'.\r\nThis should be checked before adding any recipes to prevent (potential) error spam.")
    public static boolean canAccessPressingRecipes() {
        return HarvestcraftRecipes.pressingRecipes != null;
    }

    @ZenMethod
    @ZenDoc(value="Adds a new entry to the presser.\r\nInput stack accepts wildcard metadata value (32767).")
    public static void addPressingRecipe(IItemStack input, IItemStack firstOutput, @stanhebben.zenscript.annotations.Optional IItemStack secondOutput) {
        ItemStack stackInput;
        if (HarvestcraftRecipes.pressingRecipes == null) {
            CraftTweakerAPI.logError((String)"Presser recipes couldn't be accessed during initialization, it's not possible to remove any of them. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (input == null || input.isEmpty()) {
            CraftTweakerAPI.logError((String)"Input does not exist!");
            return;
        }
        if (firstOutput == null || firstOutput.isEmpty()) {
            if (secondOutput != null && !secondOutput.isEmpty()) {
                firstOutput = secondOutput;
                secondOutput = null;
            } else {
                CraftTweakerAPI.logError((String)"Output does not exist!");
                return;
            }
        }
        if (HarvestcraftRecipes.doesPressingRecipeExist(stackInput = CraftTweakerMC.getItemStack((IItemStack)input))) {
            CraftTweakerAPI.logError((String)("Recipe using provided input already exists! Item: " + stackInput.toString()));
            return;
        }
        ItemStack stackOutputFirst = CraftTweakerMC.getItemStack((IItemStack)firstOutput);
        ItemStack stackOutputSecond = secondOutput == null || secondOutput.isEmpty() ? ItemStack.field_190927_a : CraftTweakerMC.getItemStack((IItemStack)secondOutput);
        HarvestcraftRecipes.pressingRecipes.put(stackInput, new ItemStack[]{stackOutputFirst, stackOutputSecond});
    }

    @ZenMethod
    @ZenDoc(value="Removes an entry from the presser.")
    public static void removePressingRecipe(IItemStack input) {
        if (HarvestcraftRecipes.pressingRecipes == null) {
            CraftTweakerAPI.logError((String)"Presser recipes couldn't be accessed during initialization, it's not possible to remove any of them. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (input == null || input.isEmpty()) {
            CraftTweakerAPI.logError((String)"Input does not exist!");
            return;
        }
        pressingRemove.add(CraftTweakerMC.getItemStack((IItemStack)input));
    }

    @ZenMethod
    @ZenDoc(value="Check whether or not new market recipes can be added using 'addGrindingRecipe' or removed using 'removeGrindingRecipe'.\r\nThis should be checked before adding any recipes to prevent (potential) error spam.")
    public static boolean canAccessGrindingRecipes() {
        return HarvestcraftRecipes.grindingRecipes != null;
    }

    @ZenMethod
    @ZenDoc(value="Adds a new entry to the presser.\r\nInput stack accepts wildcard metadata value (32767).")
    public static void addGrindingRecipe(IItemStack input, IItemStack firstOutput, @stanhebben.zenscript.annotations.Optional IItemStack secondOutput) {
        ItemStack stackInput;
        if (HarvestcraftRecipes.grindingRecipes == null) {
            CraftTweakerAPI.logError((String)"Grinding recipes couldn't be accessed during initialization, it's not possible to remove any of them. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (input == null || input.isEmpty()) {
            CraftTweakerAPI.logError((String)"Input does not exist!");
            return;
        }
        if (firstOutput == null || firstOutput.isEmpty()) {
            if (secondOutput != null && !secondOutput.isEmpty()) {
                firstOutput = secondOutput;
                secondOutput = null;
            } else {
                CraftTweakerAPI.logError((String)"Output does not exist!");
                return;
            }
        }
        if (HarvestcraftRecipes.doesGrindingRecipeExist(stackInput = CraftTweakerMC.getItemStack((IItemStack)input))) {
            CraftTweakerAPI.logError((String)("Recipe using provided input already exists! Item: " + stackInput.toString()));
            return;
        }
        ItemStack stackOutputFirst = CraftTweakerMC.getItemStack((IItemStack)firstOutput);
        ItemStack stackOutputSecond = secondOutput == null || secondOutput.isEmpty() ? ItemStack.field_190927_a : CraftTweakerMC.getItemStack((IItemStack)secondOutput);
        HarvestcraftRecipes.grindingRecipes.put(stackInput, new ItemStack[]{stackOutputFirst, stackOutputSecond});
    }

    @ZenMethod
    @ZenDoc(value="Removes an entry from the grinder.")
    public static void removeGrindingRecipe(IItemStack input) {
        if (HarvestcraftRecipes.grindingRecipes == null) {
            CraftTweakerAPI.logError((String)"Presser recipes couldn't be accessed during initialization, it's not possible to remove any of them. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (input == null || input.isEmpty()) {
            CraftTweakerAPI.logError((String)"Input does not exist!");
            return;
        }
        grindingRemove.add(CraftTweakerMC.getItemStack((IItemStack)input));
    }

    @ZenMethod
    @ZenDoc(value="Check whether or not new market recipes can be added using 'addWaterFilteringRecipe' or removed using 'removeWaterFilteringRecipe'.\r\nThis should be checked before adding any recipes to prevent (potential) error spam.")
    public static boolean canAccessWaterFilteringRecipes() {
        return HarvestcraftRecipes.waterFilterRecipes != null;
    }

    @ZenMethod
    @ZenDoc(value="Adds a new entry to the presser.\r\nInput stack accepts wildcard metadata value (32767).")
    public static void addWaterFilteringRecipe(IItemStack input, IItemStack firstOutput, @stanhebben.zenscript.annotations.Optional IItemStack secondOutput) {
        ItemStack stackInput;
        if (HarvestcraftRecipes.waterFilterRecipes == null) {
            CraftTweakerAPI.logError((String)"Grinding recipes couldn't be accessed during initialization, it's not possible to remove any of them. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (input == null || input.isEmpty()) {
            CraftTweakerAPI.logError((String)"Input does not exist!");
            return;
        }
        if (firstOutput == null || firstOutput.isEmpty()) {
            if (secondOutput != null && !secondOutput.isEmpty()) {
                firstOutput = secondOutput;
                secondOutput = null;
            } else {
                CraftTweakerAPI.logError((String)"Output does not exist!");
                return;
            }
        }
        if (HarvestcraftRecipes.doesFilteringRecipeExist(stackInput = CraftTweakerMC.getItemStack((IItemStack)input))) {
            CraftTweakerAPI.logError((String)("Recipe using provided input already exists! Item: " + stackInput.toString()));
            return;
        }
        ItemStack stackOutputFirst = CraftTweakerMC.getItemStack((IItemStack)firstOutput);
        ItemStack stackOutputSecond = secondOutput == null || secondOutput.isEmpty() ? ItemStack.field_190927_a : CraftTweakerMC.getItemStack((IItemStack)secondOutput);
        HarvestcraftRecipes.waterFilterRecipes.put(stackInput, new ItemStack[]{stackOutputFirst, stackOutputSecond});
    }

    @ZenMethod
    @ZenDoc(value="Removes an entry from the grinder.")
    public static void removeWaterFilteringRecipe(IItemStack input) {
        if (HarvestcraftRecipes.waterFilterRecipes == null) {
            CraftTweakerAPI.logError((String)"Presser recipes couldn't be accessed during initialization, it's not possible to remove any of them. This shouldn't happen unless there was a major change in Harvestcraft, or MIA does have some bugs.");
            return;
        }
        if (input == null || input.isEmpty()) {
            CraftTweakerAPI.logError((String)"Input does not exist!");
            return;
        }
        waterFilteringRemove.add(CraftTweakerMC.getItemStack((IItemStack)input));
    }

    private static boolean isSameItem(ItemStack stack, ItemStack stack2) {
        return stack2.func_77973_b() == stack.func_77973_b() && (stack.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == stack.func_77952_i());
    }
}

