/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.harvestcraft;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.HarvestcraftConfiguration;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.dispenserbehavior.DispenserLootBag;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.harvestcraft.IHarvestcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.harvestcraft.JeiHarvestcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.harvestcraft.JerHarvestcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.harvestcraft.ThermalExpansionHarvestcraftIntegration;
import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import com.pam.harvestcraft.item.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;

public class Harvestcraft
implements IBaseMod {
    private List<IHarvestcraftIntegration> modIntegrations = new ArrayList<IHarvestcraftIntegration>();

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (HarvestcraftConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionHarvestcraftIntegration());
        }
        if (ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerHarvestcraftIntegration());
        }
        if (ModIds.JEI.isLoaded) {
            modIntegration.accept(ModIds.JEI, new JeiHarvestcraftIntegration());
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!HarvestcraftConfiguration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof IHarvestcraftIntegration) {
            this.modIntegrations.add((IHarvestcraftIntegration)integration);
        } else {
            Mia.LOGGER.warn("Incorrect Harvestcraft integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (HarvestcraftConfiguration.harvestcraftAdditionsEnabled && !MiaConfig.disableOreDict) {
            if (HarvestCraft.config.enableTofuAsMeatInRecipes) {
                OreDictionary.registerOre((String)"egg", (Item)ItemRegistry.rawtofeegItem);
            }
            OreDictionary.registerOre((String)"honeycomb", (Item)ItemRegistry.honeycombItem);
            OreDictionary.registerOre((String)"treeSapling", (Block)FruitRegistry.getSapling((String)"spiderweb"));
            OreDictionary.registerOre((String)"treeSapling", (Block)FruitRegistry.getSapling((String)"avocado"));
            OreDictionary.registerOre((String)"treeSapling", (Block)FruitRegistry.getSapling((String)"walnut"));
        }
        if (!this.modIntegrations.isEmpty() && !MiaConfig.disableAllRecipes) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Harvestcraft addRecipes", (int)this.modIntegrations.size());
            for (IHarvestcraftIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                integration.addRecipes();
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Override
    public void registerDispenserBehaviors() {
        DispenserLootBag.getInstance().addListener((source, stack) -> {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block instanceof BlockBaseGarden) {
                stack.func_190918_g(1);
                IBehaviorDispenseItem defaultDispenserBehavior = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a(null);
                NonNullList drops = NonNullList.func_191196_a();
                block.getDrops(drops, (IBlockAccess)source.func_82618_k(), source.func_180699_d(), source.func_189992_e(), 0);
                for (ItemStack lootItem : drops) {
                    if (lootItem.func_190926_b()) continue;
                    defaultDispenserBehavior.func_82482_a(source, lootItem);
                }
                return true;
            }
            return false;
        }, (Block[])BlockRegistry.gardens.values().toArray(new BlockBaseGarden[0]));
    }
}

