/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.harvestcraft;

import com.github.sokyranthedragon.mia.config.HarvestcraftConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomPlantEntry;
import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import com.pam.harvestcraft.item.ItemRegistry;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IPlantRegistry;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
class JerHarvestcraftIntegration
implements IJerIntegration {
    JerHarvestcraftIntegration() {
    }

    @Override
    public void overrideExistingMobDrops(MobEntry mobEntry) {
        if (HarvestcraftConfiguration.squidDropsCalamari && mobEntry.getEntity() instanceof EntitySquid) {
            LootDrop squidDrop = new LootDrop(new ItemStack(ItemRegistry.calamarirawItem));
            squidDrop.smeltedItem = new ItemStack(ItemRegistry.calamaricookedItem);
            mobEntry.addDrops(new LootDrop[]{squidDrop});
        }
    }

    @Override
    public void addPlantDrops(IPlantRegistry plantRegistry, @Nullable Collection<PlantEntry> registers) {
        if (!HarvestcraftConfiguration.enableJerIntegration) {
            return;
        }
        for (BlockPamCrop crop : CropRegistry.getCrops().values()) {
            Item food;
            Item seeds = crop.func_149866_i();
            PlantDrop[] entries = seeds == (food = crop.func_149865_P()) ? new PlantDrop[]{new PlantDrop(new ItemStack(seeds), 1, 4)} : new PlantDrop[]{new PlantDrop(new ItemStack(seeds), 1, 1), new PlantDrop(new ItemStack(food), 0, 2)};
            if (seeds instanceof IPlantable) {
                plantRegistry.register((Item)((IPlantable)seeds), entries);
                continue;
            }
            plantRegistry.register(new ItemStack(seeds), entries);
        }
        if (registers != null) {
            CustomPlantEntry entry;
            for (BlockPamFruit fruit : FruitRegistry.fruits) {
                entry = new CustomPlantEntry(new ItemStack((Block)fruit.getSapling()), fruit.func_176223_P(), new PlantDrop(new ItemStack(fruit.getFruitItem()), 1, 1));
                entry.setSoil(Blocks.field_150350_a.func_176223_P());
                registers.add(entry);
            }
            for (BlockPamFruitLog log : FruitRegistry.logs.values()) {
                entry = new CustomPlantEntry(new ItemStack((Block)log.getSapling()), log.func_176223_P(), new PlantDrop(new ItemStack(log.getFruitItem()), 1, 1));
                entry.setSoil(log.func_176223_P());
                registers.add(entry);
            }
        } else {
            PlantDrop entry;
            Item sapling;
            for (BlockPamFruit fruit : FruitRegistry.fruits) {
                sapling = Item.func_150898_a((Block)fruit.getSapling());
                entry = new PlantDrop(new ItemStack(fruit.getFruitItem()), 1, 1);
                if (sapling instanceof IPlantable) {
                    plantRegistry.registerWithSoil((Item)((IPlantable)sapling), Blocks.field_150346_d.func_176223_P(), new PlantDrop[]{entry});
                    continue;
                }
                plantRegistry.registerWithSoil(new ItemStack((Block)fruit.getSapling()), Blocks.field_150346_d.func_176223_P(), new PlantDrop[]{entry});
            }
            for (BlockPamFruitLog log : FruitRegistry.logs.values()) {
                sapling = Item.func_150898_a((Block)log.getSapling());
                entry = new PlantDrop(new ItemStack(log.getFruitItem()), 1, 1);
                if (sapling instanceof IPlantable) {
                    plantRegistry.registerWithSoil((Item)((IPlantable)sapling), Blocks.field_150346_d.func_176223_P(), new PlantDrop[]{entry});
                    continue;
                }
                plantRegistry.registerWithSoil(new ItemStack(sapling), Blocks.field_150346_d.func_176223_P(), new PlantDrop[]{entry});
            }
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.HARVESTCRAFT;
    }
}

