/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.iceandfire;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.sokyranthedragon.mia.block.BlockPixieDustExtractor;
import com.github.sokyranthedragon.mia.config.IceAndFireConfiguration;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.ChiselIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.DungeonTacticsIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.ExtraUtilsIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.FutureMcIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.HatcheryIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.IndustrialForegoingIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.JerIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.TConstructIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.ThermalExpansionIceAndFireIntegration;
import com.github.sokyranthedragon.mia.integrations.iceandfire.client.RenderHippocampusJer;
import com.github.sokyranthedragon.mia.tile.TilePixieDustExtractor;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class IceAndFire
implements IBaseMod {
    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (IceAndFireConfiguration.enableXu2Integration && ModIds.EXTRA_UTILITIES.isLoaded) {
            modIntegration.accept(ModIds.EXTRA_UTILITIES, new ExtraUtilsIceAndFireIntegration());
        }
        if (IceAndFireConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionIceAndFireIntegration());
        }
        if (IceAndFireConfiguration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerIceAndFireIntegration());
        }
        if (IceAndFireConfiguration.enableTConstructIntegration && ModIds.TINKERS_CONSTRUCT.isLoaded) {
            modIntegration.accept(ModIds.TINKERS_CONSTRUCT, new TConstructIceAndFireIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryIceAndFireIntegration(IceAndFireConfiguration.enableHatcheryIntegration));
        }
        if (IceAndFireConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsIceAndFireIntegration());
        }
        if (IceAndFireConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcIceAndFireIntegration());
        }
        if (IceAndFireConfiguration.enableIFIntegration && ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            modIntegration.accept(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoingIceAndFireIntegration());
        }
        if (IceAndFireConfiguration.enableChiselIntegration && ModIds.CHISEL.isLoaded) {
            modIntegration.accept(ModIds.CHISEL, new ChiselIceAndFireIntegration());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!IceAndFireConfiguration.iceandfireAdditionsEnabled) {
            return;
        }
        if (!MiaConfig.disableAllRecipes) {
            FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_sword), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_axe), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_pickaxe), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_hoe), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_shovel), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_helmet), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_chestplate), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_leggings), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
            furnaceRecipes.func_151394_a(new ItemStack(IafItemRegistry.silver_boots), new ItemStack(IafItemRegistry.silverNugget), 0.1f);
        }
        if (!MiaConfig.disableOreDict) {
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(IafBlockRegistry.dreadwood_log));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)IafBlockRegistry.dreadwood_planks));
            OreDictionary.registerOre((String)"stoneDreastone", (ItemStack)new ItemStack((Block)IafBlockRegistry.dread_stone));
            OreDictionary.registerOre((String)"stoneDreastonePolished", (ItemStack)new ItemStack((Block)IafBlockRegistry.dread_stone_tile));
            OreDictionary.registerOre((String)"brickDreadstone", (ItemStack)new ItemStack((Block)IafBlockRegistry.dread_stone_bricks));
            OreDictionary.registerOre((String)"blockMossy", (ItemStack)new ItemStack((Block)IafBlockRegistry.dread_stone_bricks_mossy));
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (IceAndFireConfiguration.enableJerIntegration && ModIds.JER.isLoaded && event.getSide() == Side.CLIENT) {
            this.registerRenderingOverride();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerRenderingOverride() {
        RenderingRegistry.registerEntityRenderingHandler(EntityHippocampus.class, (Render)new RenderHippocampusJer(Minecraft.func_71410_x().func_175598_ae()));
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        if (!IceAndFireConfiguration.iceandfireAdditionsEnabled) {
            return;
        }
        MiaBlocks.pixieDustExtractor = MiaBlocks.registerBlock(new BlockPixieDustExtractor());
        GameRegistry.registerTileEntity(TilePixieDustExtractor.class, (ResourceLocation)new ResourceLocation("mia", "pixie_dust_extractor"));
    }

    @Override
    @Optional.Method(modid="thaumcraft")
    public void registerAspects(AspectRegistryEvent event) {
        if (!IceAndFireConfiguration.iceandfireAdditionsEnabled) {
            return;
        }
        Aspect MYTHICAL = Aspect.getAspect((String)"mythus");
        event.register.registerObjectTag(new ItemStack(IafBlockRegistry.pixieHouse, 1, 0), new AspectList().add(Aspect.EARTH, 2).add(Aspect.CRAFT, 5).add(Aspect.PLANT, 2).add(MYTHICAL, 2).add(Aspect.MAGIC, 2).add(Aspect.METAL, 60).add(Aspect.LIGHT, 3).add(Aspect.SENSES, 1).add(Aspect.AIR, 1).add(Aspect.CRYSTAL, 1));
    }
}

