/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.iceandfire;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDreadBeast;
import com.github.alexthe666.iceandfire.entity.EntityDreadGhoul;
import com.github.alexthe666.iceandfire.entity.EntityDreadHorse;
import com.github.alexthe666.iceandfire.entity.EntityDreadKnight;
import com.github.alexthe666.iceandfire.entity.EntityDreadLich;
import com.github.alexthe666.iceandfire.entity.EntityDreadMob;
import com.github.alexthe666.iceandfire.entity.EntityDreadQueen;
import com.github.alexthe666.iceandfire.entity.EntityDreadScuttler;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexRoyal;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSoldier;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.EntityTroll;
import com.github.alexthe666.iceandfire.entity.IafVillagerRegistry;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexDecoration;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.iceandfire.client.EntityCustomSnowVillager;
import com.github.sokyranthedragon.mia.integrations.jer.ExtraConditional;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JerHelpers;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import com.github.sokyranthedragon.mia.integrations.jer.ResourceLocationWrapper;
import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomVillagerEntry;
import com.github.sokyranthedragon.mia.utilities.LootTableUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IMobRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.render.IMobRenderHook;
import jeresources.entry.MobEntry;
import jeresources.entry.VillagerEntry;
import jeresources.registry.VillagerRegistry;
import jeresources.util.LootTableHelper;
import jeresources.util.MobTableBuilder;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class JerIceAndFireIntegration
implements IJerIntegration {
    private static final IMobRenderHook<?> RENDER_HOOK_DRAGON = (renderInfo, entityLivingBase) -> {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        return renderInfo;
    };
    private static final IMobRenderHook<?> RENDER_HOOK_SEA_SERPENT = (renderInfo, entityLivingBase) -> {
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        return renderInfo;
    };
    private static final IMobRenderHook<?> RENDER_HOOK_TROLL = (renderInfo, entityLivingBase) -> {
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        return renderInfo;
    };
    private static final IMobRenderHook<?> RENDER_HOOK_CYCLOPS = (renderInfo, entityLivingBase) -> {
        GlStateManager.func_179109_b((float)0.0f, (float)-2.0f, (float)0.0f);
        return renderInfo;
    };

    JerIceAndFireIntegration() {
    }

    @Override
    public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
        int i;
        builder.add(EntityAmphithere.LOOT, EntityAmphithere.class);
        builder.add(EntityCockatrice.LOOT, EntityCockatrice.class);
        builder.add(EntityCyclops.LOOT, EntityCyclops.class);
        builder.add(EntityDeathWorm.TAN_LOOT, EntityDeathWorm.class, new DeathWormSetter(0));
        builder.add(EntityDeathWorm.WHITE_LOOT, EntityDeathWorm.class, new DeathWormSetter(1));
        builder.add(EntityDeathWorm.RED_LOOT, EntityDeathWorm.class, new DeathWormSetter(2));
        builder.add(EntityGorgon.LOOT, EntityGorgon.class);
        builder.addWithIgnore(EntityFireDragon.SKELETON_LOOT, EntityFireDragon.class, new DragonSetter(-1));
        builder.addWithIgnore(EntityIceDragon.SKELETON_LOOT, EntityIceDragon.class, new DragonSetter(-1));
        for (i = 0; i <= 3; ++i) {
            builder.addWithIgnore(new ResourceLocationWrapper(EntityFireDragon.FEMALE_LOOT, i), EntityFireDragon.class, new DragonSetter(i));
            builder.addWithIgnore(new ResourceLocationWrapper(EntityIceDragon.FEMALE_LOOT, i), EntityIceDragon.class, new DragonSetter(i));
        }
        builder.add(EntityHippocampus.LOOT, EntityHippocampus.class);
        builder.add(EntityHippogryph.LOOT, EntityHippogryph.class);
        builder.add(EntityMyrmexQueen.DESERT_LOOT, EntityMyrmexQueen.class, new MyrmexSetter(false));
        builder.add(EntityMyrmexQueen.JUNGLE_LOOT, EntityMyrmexQueen.class, new MyrmexSetter(true));
        builder.add(EntityMyrmexRoyal.DESERT_LOOT, EntityMyrmexRoyal.class, new MyrmexSetter(false));
        builder.add(EntityMyrmexRoyal.JUNGLE_LOOT, EntityMyrmexRoyal.class, new MyrmexSetter(true));
        builder.add(EntityMyrmexSentinel.DESERT_LOOT, EntityMyrmexSentinel.class, new MyrmexSetter(false));
        builder.add(EntityMyrmexSentinel.JUNGLE_LOOT, EntityMyrmexSentinel.class, new MyrmexSetter(true));
        builder.add(EntityMyrmexSoldier.DESERT_LOOT, EntityMyrmexSoldier.class, new MyrmexSetter(false));
        builder.add(EntityMyrmexSoldier.JUNGLE_LOOT, EntityMyrmexSoldier.class, new MyrmexSetter(true));
        builder.add(EntityMyrmexWorker.DESERT_LOOT, EntityMyrmexWorker.class, new MyrmexSetter(false));
        builder.add(EntityMyrmexWorker.JUNGLE_LOOT, EntityMyrmexWorker.class, new MyrmexSetter(true));
        builder.add(EntityPixie.LOOT, EntityPixie.class);
        for (i = 0; i <= 6; ++i) {
            builder.add(new ResourceLocationWrapper(EntitySeaSerpent.LOOT, i), EntitySeaSerpent.class, new SeaSerpentSetter(i));
        }
        builder.add(EntitySiren.LOOT, EntitySiren.class);
        builder.add(EntityStymphalianBird.LOOT, EntityStymphalianBird.class);
        builder.add(EntityTroll.FOREST_LOOT, EntityTroll.class, new TrollSetter(EnumTroll.FOREST));
        builder.add(EntityTroll.FROST_LOOT, EntityTroll.class, new TrollSetter(EnumTroll.FROST));
        builder.add(EntityTroll.MOUNTAIN_LOOT, EntityTroll.class, new TrollSetter(EnumTroll.MOUNTAIN));
        builder.add(EntityHydra.LOOT, EntityHydra.class);
        builder.add(EntityDreadBeast.LOOT, EntityDreadBeast.class);
        builder.add(EntityDreadGhoul.LOOT, EntityDreadGhoul.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityDreadHorse.class);
        builder.add(EntityDreadKnight.LOOT, EntityDreadKnight.class);
        builder.add(EntityDreadLich.LOOT, EntityDreadLich.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityDreadQueen.class);
        builder.add(EntityDreadScuttler.LOOT, EntityDreadScuttler.class);
        builder.add(EntityDreadThrall.LOOT, EntityDreadThrall.class);
    }

    @Override
    public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        LightLevel lightLevel = LightLevel.any;
        HashSet<Biome> validBiomes = new HashSet<Biome>();
        ArrayList<LootDrop> loot = null;
        if (manager != null) {
            loot = entity instanceof EntityDragonBase || entity instanceof EntitySeaSerpent ? LootTableUtils.toDrops(manager.func_186521_a(resource), entity) : LootTableHelper.toDrops((LootTable)manager.func_186521_a(resource));
        }
        int experienceMin = 0;
        int experienceMax = 0;
        if (entity instanceof EntityAmphithere) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            experienceMin = 15;
            experienceMax = 24;
        } else if (entity instanceof EntityCockatrice) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPARSE));
            experienceMin = 10;
            experienceMax = 14;
        } else if (entity instanceof EntityDeathWorm) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) continue;
                validBiomes.add(biome);
            }
            experienceMin = 2;
            experienceMax = 44;
        } else if (entity instanceof EntityHippogryph) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
            experienceMin = 7;
            experienceMax = 16;
        } else if (entity instanceof EntityHippocampus || entity instanceof EntitySeaSerpent) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
            experienceMin = 1;
            experienceMax = 3;
        } else if (entity instanceof EntityMyrmexBase) {
            EntityMyrmexBase myrmex = (EntityMyrmexBase)entity;
            if (myrmex.isJungle()) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            } else {
                for (Biome biome : Biome.field_185377_q) {
                    if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) continue;
                    validBiomes.add(biome);
                }
            }
            experienceMin = myrmex.getCasteImportance() * 7;
            experienceMax = experienceMin + 2;
        } else if (entity instanceof EntityPixie) {
            for (Biome biome : Biome.field_185377_q) {
                if ((!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) continue;
                validBiomes.add(biome);
            }
            experienceMax = 3;
            experienceMin = 3;
        } else if (entity instanceof EntitySiren) {
            for (Biome biome : Biome.field_185377_q) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) continue;
                validBiomes.add(biome);
            }
            experienceMin = 10;
            experienceMax = 19;
        } else if (entity instanceof EntityStymphalianBird) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            experienceMin = 10;
            experienceMax = 14;
        } else if (entity instanceof EntityGorgon || entity instanceof EntityCyclops) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
            experienceMin = 20;
            experienceMax = 34;
        } else if (entity instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)entity;
            boolean isFire = dragon instanceof EntityFireDragon;
            for (Biome biome : Biome.field_185377_q) {
                if (dragon.isModelDead()) {
                    if (isFire) {
                        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) continue;
                        validBiomes.add(biome);
                        continue;
                    }
                    if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) continue;
                    validBiomes.add(biome);
                    continue;
                }
                if (isFire) {
                    if (biome.func_76746_c() || !((double)biome.func_185353_n() > -0.5) || biome == Biomes.field_76774_n || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) continue;
                    validBiomes.add(biome);
                    continue;
                }
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) continue;
                validBiomes.add(biome);
            }
            if (dragon.isModelDead()) {
                if (loot != null && IceAndFire.CONFIG.dragonDropSkull) {
                    loot.add(new LootDrop(new ItemStack(IafItemRegistry.dragon_skull, 1, isFire ? 0 : 1)));
                }
            } else {
                experienceMin = 15;
                experienceMax = 190;
                if (loot != null) {
                    List<LootDrop> maleDrops = LootTableUtils.toDrops(manager.func_186521_a(isFire ? EntityFireDragon.MALE_LOOT : EntityIceDragon.MALE_LOOT), entity);
                    ArrayList<LootDrop> finalDrops = new ArrayList<LootDrop>();
                    for (LootDrop femaleDrop : loot) {
                        List matches = maleDrops.stream().filter(entry -> femaleDrop.compareTo(entry) == 0).collect(Collectors.toList());
                        if (matches.isEmpty()) {
                            femaleDrop.addConditional(ExtraConditional.femaleOnly);
                        } else {
                            maleDrops.removeAll(matches);
                        }
                        finalDrops.add(femaleDrop);
                    }
                    for (LootDrop maleDrop : maleDrops) {
                        maleDrop.addConditional(ExtraConditional.maleOnly);
                        finalDrops.add(maleDrop);
                    }
                    loot = finalDrops;
                    if (IceAndFire.CONFIG.dragonDropHeart) {
                        loot.add(new LootDrop(new ItemStack(isFire ? IafItemRegistry.fire_dragon_heart : IafItemRegistry.ice_dragon_heart)));
                    }
                    if (IceAndFire.CONFIG.dragonDropBlood) {
                        loot.add(new LootDrop(new ItemStack(isFire ? IafItemRegistry.fire_dragon_blood : IafItemRegistry.ice_dragon_blood)));
                    }
                }
            }
        } else if (entity instanceof EntityTroll) {
            EnumTroll troll = ((EntityTroll)entity).getType();
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)troll.spawnBiome));
            experienceMin = 15;
            experienceMax = 24;
            if (loot != null) {
                if (troll == EnumTroll.FOREST) {
                    loot.add(new LootDrop(EnumTroll.Weapon.COLUMN_FOREST.item, 0, 1, 0.25f, new Conditional[0]));
                    loot.add(new LootDrop(EnumTroll.Weapon.TRUNK.item, 0, 1, 0.25f, new Conditional[0]));
                    loot.add(new LootDrop(EnumTroll.Weapon.AXE.item, 0, 1, 0.25f, new Conditional[0]));
                    loot.add(new LootDrop(EnumTroll.Weapon.HAMMER.item, 0, 1, 0.25f, new Conditional[0]));
                } else if (troll == EnumTroll.FROST) {
                    loot.add(new LootDrop(EnumTroll.Weapon.COLUMN_FROST.item, 0, 1, 0.25f, new Conditional[0]));
                    loot.add(new LootDrop(EnumTroll.Weapon.TRUNK_FROST.item, 0, 1, 0.25f, new Conditional[0]));
                    loot.add(new LootDrop(EnumTroll.Weapon.AXE.item, 0, 1, 0.25f, new Conditional[0]));
                    loot.add(new LootDrop(EnumTroll.Weapon.HAMMER.item, 0, 1, 0.25f, new Conditional[0]));
                } else {
                    loot.add(new LootDrop(EnumTroll.Weapon.TRUNK.item, 0, 1, 0.33f, new Conditional[0]));
                    loot.add(new LootDrop(EnumTroll.Weapon.AXE.item, 0, 1, 0.33f, new Conditional[0]));
                    loot.add(new LootDrop(EnumTroll.Weapon.HAMMER.item, 0, 1, 0.33f, new Conditional[0]));
                }
            }
        } else if (entity instanceof EntityHydra) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            experienceMin = 5;
            experienceMax = 5;
        } else if (entity instanceof EntityDreadMob) {
            if (loot != null) {
                if (entity instanceof EntityDreadKnight) {
                    loot.add(new LootDrop(IafItemRegistry.dread_knight_sword, 0, 1, new Conditional[0]));
                    loot.add(new LootDrop(EntityDreadKnight.SHIELD));
                } else if (entity instanceof EntityDreadLich) {
                    validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    loot.add(new LootDrop(IafItemRegistry.lich_staff, 0, 1, new Conditional[0]));
                } else if (entity instanceof EntityDreadQueen) {
                    loot.add(new LootDrop(IafItemRegistry.dread_queen_sword, 0, 1, new Conditional[0]));
                    loot.add(new LootDrop(IafItemRegistry.dread_queen_staff, 0, 1, new Conditional[0]));
                }
            } else if (entity instanceof EntityDreadKnight) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
            }
            experienceMin = 5;
            experienceMax = 5;
        }
        if (loot == null) {
            if (validBiomes.isEmpty()) {
                mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, resource);
            } else {
                mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, (String[])validBiomes.stream().map(Biome::func_185359_l).toArray(String[]::new), resource);
            }
        } else {
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            if (validBiomes.isEmpty()) {
                mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, drops);
            } else {
                mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, (String[])validBiomes.stream().map(Biome::func_185359_l).toArray(String[]::new), drops);
            }
        }
    }

    @Override
    public void overrideExistingMobDrops(MobEntry mobEntry) {
        if (mobEntry.getEntity() instanceof EntityWitherSkeleton) {
            mobEntry.addDrop(new LootDrop(IafItemRegistry.witherbone, 0, 2, new Conditional[0]));
        }
    }

    @Override
    public void addMobRenderHooks(IMobRegistry mobRegistry) {
        mobRegistry.registerRenderHook(EntityFireDragon.class, RENDER_HOOK_DRAGON);
        mobRegistry.registerRenderHook(EntityIceDragon.class, RENDER_HOOK_DRAGON);
        mobRegistry.registerRenderHook(EntityAmphithere.class, RENDER_HOOK_DRAGON);
        mobRegistry.registerRenderHook(EntitySeaSerpent.class, RENDER_HOOK_SEA_SERPENT);
        mobRegistry.registerRenderHook(EntityTroll.class, RENDER_HOOK_TROLL);
        mobRegistry.registerRenderHook(EntityCyclops.class, RENDER_HOOK_CYCLOPS);
    }

    @Override
    public void addDungeonLoot(IDungeonRegistry dungeonRegistry, World world) {
        String myrmexLoot = "chest/myrmex_loot";
        String myrmexDesertFood = "chest/myrmex_desert_food";
        String myrmexJungleFood = "chest/myrmex_jungle_food";
        String myrmexTrash = "chest/myrmex_trash";
        String cyclopsCave = "chests/cyclops_cave";
        String hydraCave = "chests/hydra_cave";
        dungeonRegistry.registerCategory("chest/myrmex_loot", "mia.jer.dungeon.myrmex_loot");
        dungeonRegistry.registerCategory("chest/myrmex_desert_food", "mia.jer.dungeon.myrmex_desert_food");
        dungeonRegistry.registerCategory("chest/myrmex_jungle_food", "mia.jer.dungeon.myrmex_jungle_food");
        dungeonRegistry.registerCategory("chest/myrmex_trash", "mia.jer.dungeon.myrmex_trash");
        dungeonRegistry.registerCategory("chests/cyclops_cave", "mia.jer.dungeon.cyclops_cave");
        dungeonRegistry.registerCategory("chests/hydra_cave", "mia.jer.dungeon.hydra_cave");
        JerHelpers.addDungeonLootCategory(world, dungeonRegistry, "fire_dragon", WorldGenFireDragonCave.FIREDRAGON_CHEST, WorldGenFireDragonCave.FIREDRAGON_MALE_CHEST);
        JerHelpers.addDungeonLootCategory(world, dungeonRegistry, "ice_dragon", WorldGenIceDragonCave.ICEDRAGON_CHEST, WorldGenIceDragonCave.ICEDRAGON_MALE_CHEST);
        dungeonRegistry.registerChest("chest/myrmex_loot", WorldGenMyrmexDecoration.MYRMEX_GOLD_CHEST);
        dungeonRegistry.registerChest("chest/myrmex_desert_food", WorldGenMyrmexDecoration.DESERT_MYRMEX_FOOD_CHEST);
        dungeonRegistry.registerChest("chest/myrmex_jungle_food", WorldGenMyrmexDecoration.JUNGLE_MYRMEX_FOOD_CHEST);
        dungeonRegistry.registerChest("chest/myrmex_trash", WorldGenMyrmexDecoration.MYRMEX_TRASH_CHEST);
        dungeonRegistry.registerChest("chests/cyclops_cave", WorldGenCyclopsCave.CYCLOPS_CHEST);
        dungeonRegistry.registerChest("chests/hydra_cave", WorldGenHydraCave.HYDRA_CHEST);
    }

    @Override
    public void addVillagerTrades(VillagerRegistry villagerRegistry, boolean acceptsCustomEntries) {
        if (acceptsCustomEntries) {
            try {
                List trades;
                VillagerRegistry.VillagerCareer career;
                Field tradesField = VillagerRegistry.VillagerCareer.class.getDeclaredField("trades");
                tradesField.setAccessible(true);
                IafVillagerRegistry iafRegistry = IafVillagerRegistry.INSTANCE;
                for (Map.Entry entry : iafRegistry.professions.entrySet()) {
                    VillagerRegistry.VillagerCareer career2 = ((VillagerRegistry.VillagerProfession)entry.getValue()).getCareer(0);
                    List trades2 = (List)tradesField.get(career2);
                    villagerRegistry.addVillagerEntry((VillagerEntry)new SnowVillagerEntry(career2.getName(), (Integer)entry.getKey(), trades2));
                }
                for (Tuple desertMyrmex : new Tuple[]{new Tuple((Object)iafRegistry.desertMyrmexWorker, EntityMyrmexWorker.class), new Tuple((Object)iafRegistry.desertMyrmexSoldier, EntityMyrmexSoldier.class), new Tuple((Object)iafRegistry.desertMyrmexSentinel, EntityMyrmexSentinel.class), new Tuple((Object)iafRegistry.desertMyrmexRoyal, EntityMyrmexRoyal.class), new Tuple((Object)iafRegistry.desertMyrmexQueen, EntityMyrmexQueen.class)}) {
                    career = ((VillagerRegistry.VillagerProfession)desertMyrmex.func_76341_a()).getCareer(0);
                    trades = (List)tradesField.get(career);
                    villagerRegistry.addVillagerEntry((VillagerEntry)new MyrmexVillagerEntry(career.getName().substring("desert_".length()), trades, (Class)desertMyrmex.func_76340_b(), false));
                }
                for (Tuple desertMyrmex : new Tuple[]{new Tuple((Object)iafRegistry.jungleMyrmexWorker, EntityMyrmexWorker.class), new Tuple((Object)iafRegistry.jungleMyrmexSoldier, EntityMyrmexSoldier.class), new Tuple((Object)iafRegistry.jungleMyrmexSentinel, EntityMyrmexSentinel.class), new Tuple((Object)iafRegistry.jungleMyrmexRoyal, EntityMyrmexRoyal.class), new Tuple((Object)iafRegistry.jungleMyrmexQueen, EntityMyrmexQueen.class)}) {
                    career = ((VillagerRegistry.VillagerProfession)desertMyrmex.func_76341_a()).getCareer(0);
                    trades = (List)tradesField.get(career);
                    villagerRegistry.addVillagerEntry((VillagerEntry)new MyrmexVillagerEntry(career.getName().substring("jungle_".length()), trades, (Class)desertMyrmex.func_76340_b(), true));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                Mia.LOGGER.error("Could not add villager trades for Ice and Fire", (Throwable)e);
            }
        }
    }

    @Override
    public ModIds getModId() {
        return ModIds.ICE_AND_FIRE;
    }

    private static class MyrmexVillagerEntry
    extends CustomVillagerEntry {
        private final Constructor<? extends EntityMyrmexBase> myrmexConstructor;
        private final boolean jungleVariant;

        public MyrmexVillagerEntry(String name, List<List<EntityVillager.ITradeList>> tradesLists, Class<? extends EntityMyrmexBase> entityMyrmex, boolean jungleVariant) throws NoSuchMethodException {
            super(name, tradesLists);
            this.jungleVariant = jungleVariant;
            this.myrmexConstructor = entityMyrmex.getConstructor(World.class);
        }

        @Override
        public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            EntityMyrmexBase myrmex = this.myrmexConstructor.newInstance(minecraft.field_71441_e);
            myrmex.setJungleVariant(this.jungleVariant);
            return myrmex;
        }

        public String getDisplayName() {
            return "entity." + this.getName() + ".name";
        }

        @Override
        public float getRenderScale() {
            return 20.0f;
        }
    }

    private static class SnowVillagerEntry
    extends CustomVillagerEntry {
        public SnowVillagerEntry(String name, int profession, List<List<EntityVillager.ITradeList>> tradesLists) {
            super(name, profession, 0, tradesLists);
        }

        @Override
        public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) {
            try {
                return new EntityCustomSnowVillager((World)minecraft.field_71441_e, this.getProfession());
            }
            catch (RuntimeException var11) {
                return new EntityCustomSnowVillager((World)minecraft.field_71441_e);
            }
        }
    }

    private static class TrollSetter
    implements MobTableBuilder.EntityPropertySetter<EntityTroll> {
        private final EnumTroll variant;

        TrollSetter(EnumTroll variant) {
            this.variant = variant;
        }

        public void setProperties(EntityTroll entity) {
            entity.setType(this.variant);
        }
    }

    private static class MyrmexSetter<T extends EntityLivingBase>
    implements MobTableBuilder.EntityPropertySetter<T> {
        private final boolean jungle;

        MyrmexSetter(boolean jungle) {
            this.jungle = jungle;
        }

        public void setProperties(EntityLivingBase entity) {
            if (entity instanceof EntityMyrmexBase) {
                ((EntityMyrmexBase)entity).setJungleVariant(this.jungle);
            }
        }
    }

    private static class SeaSerpentSetter
    implements MobTableBuilder.EntityPropertySetter<EntitySeaSerpent> {
        private final int variant;

        SeaSerpentSetter(int variant) {
            this.variant = variant;
        }

        public void setProperties(EntitySeaSerpent entity) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("Scale", 1.0f);
            entity.func_70037_a(tag);
            entity.setVariant(this.variant);
        }
    }

    private static class DragonSetter<T extends EntityLivingBase>
    implements MobTableBuilder.EntityPropertySetter<T> {
        private final int variant;

        DragonSetter(int variant) {
            this.variant = variant;
        }

        public void setProperties(EntityLivingBase entity) {
            if (entity instanceof EntityDragonBase) {
                if (this.variant >= 0) {
                    ((EntityDragonBase)entity).setVariant(this.variant);
                } else {
                    ((EntityDragonBase)entity).setModelDead(true);
                }
            }
        }
    }

    private static class DeathWormSetter
    implements MobTableBuilder.EntityPropertySetter<EntityDeathWorm> {
        private final int variant;

        DeathWormSetter(int variant) {
            this.variant = variant;
        }

        public void setProperties(EntityDeathWorm entityDeathWorm) {
            entityDeathWorm.setVariant(this.variant);
        }
    }
}

