/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jei;

import com.github.sokyranthedragon.mia.config.JeiConfiguration;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.core.MiaItems;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jei.IJeiIntegration;
import com.github.sokyranthedragon.mia.integrations.jei.Jei;
import java.util.HashSet;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class MiaJeiPlugin
implements IModPlugin {
    private static IJeiRuntime jeiRuntime;
    static Jei jeiIntegration;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        if (MiaItems.musicPlayer != null) {
            subtypeRegistry.registerSubtypeInterpreter((Item)MiaItems.musicPlayer, new ISubtypeRegistry.ISubtypeInterpreter(){

                @Nonnull
                public String apply(@Nonnull ItemStack itemStack) {
                    return "mia:music_player:0";
                }
            });
        }
    }

    public void register(IModRegistry registry) {
        HashSet<String> registeredCategories = new HashSet<String>();
        for (IJeiIntegration integration : MiaJeiPlugin.jeiIntegration.modIntegrations) {
            integration.register(registry, registeredCategories);
        }
        if (ModIds.HATCHERY.isLoaded && MiaBlocks.eggSorter != null) {
            registry.addIngredientInfo((Object)new ItemStack(MiaBlocks.eggSorter), VanillaTypes.ITEM, new String[]{"mia.jei.info.egg_sorter"});
        }
        if (ModIds.ICE_AND_FIRE.isLoaded && MiaBlocks.pixieDustExtractor != null) {
            registry.addIngredientInfo((Object)new ItemStack(MiaBlocks.pixieDustExtractor), VanillaTypes.ITEM, new String[]{"mia.jei.info.pixie_dust_extractor"});
        }
        if (ModIds.THAUMCRAFT.isLoaded && MiaBlocks.voidCreator != null) {
            registry.addIngredientInfo((Object)new ItemStack(MiaBlocks.voidCreator), VanillaTypes.ITEM, new String[]{"mia.jei.info.void_creator"});
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        MiaJeiPlugin.jeiRuntime = jeiRuntime;
        if (!JeiConfiguration.enableLootBagCategory) {
            MiaJeiPlugin.hideCategories("mia.loot_bag");
        }
        if (!JeiConfiguration.enableAlchemicalCauldronCategory) {
            MiaJeiPlugin.hideCategories("mia.alchemical_cauldron");
        }
        if (!JeiConfiguration.enableOrechidVacuamCategory) {
            MiaJeiPlugin.hideCategories("mia.orechid_vacuam");
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        HashSet<String> registeredCategories = new HashSet<String>();
        for (IJeiIntegration integration : MiaJeiPlugin.jeiIntegration.modIntegrations) {
            integration.registerCategories(registry, registeredCategories);
        }
    }

    public static void hideCategories(String ... categories) {
        if (categories != null) {
            for (String category : categories) {
                jeiRuntime.getRecipeRegistry().hideRecipeCategory(category);
            }
        }
    }

    public static void unhideCategories(String ... categories) {
        if (categories != null) {
            for (String category : categories) {
                jeiRuntime.getRecipeRegistry().unhideRecipeCategory(category);
            }
        }
    }

    static {
        jeiIntegration = null;
    }

    public static class Categories {
        public static final String DUNGEON_TACTICS_CAULDRON = "mia.alchemical_cauldron";
        public static final String LOOT_BAG = "mia.loot_bag";
        public static final String ORECHID_VACUAM = "mia.orechid_vacuam";

        private Categories() {
        }
    }
}

