/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CauldronEntry {
    protected final ItemStack rightClickItem;
    protected final PossibleFluids fluid;
    protected final List<ItemStack> input;

    public CauldronEntry(ItemStack rightClickItem, ItemStack ... input) {
        this(rightClickItem, PossibleFluids.Water, input);
    }

    public CauldronEntry(ItemStack rightClickItem, PossibleFluids fluid, ItemStack ... input) {
        this.rightClickItem = rightClickItem;
        this.fluid = fluid;
        this.input = Arrays.asList(input);
    }

    public ItemStack getRightClickItem() {
        return this.rightClickItem;
    }

    public abstract ItemStack getOutput();

    public ItemStack getByproduct() {
        return ItemStack.field_190927_a;
    }

    public List<ItemStack> getInputs() {
        return this.input;
    }

    public PossibleFluids getPossibleFluids() {
        return this.fluid;
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.fluid == PossibleFluids.Water) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (this.fluid == PossibleFluids.Lava) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    public abstract boolean isRecipeValid();

    public static enum PossibleFluids {
        Water,
        Lava,
        NoWater,
        Any;

    }

    public static class CauldronFluidEntry
    extends CauldronEntry {
        protected final FluidStack output;

        public CauldronFluidEntry(ItemStack rightClickItem, PossibleFluids fluid, FluidStack output, ItemStack ... input) {
            super(rightClickItem, fluid, input);
            this.output = output;
        }

        @Override
        public ItemStack getOutput() {
            return ItemStack.field_190927_a;
        }

        public FluidStack getTrueOutput() {
            return this.output;
        }

        @Override
        public boolean isRecipeValid() {
            return this.output != null;
        }
    }

    public static class CauldronObsidianEntry
    extends CauldronEntry {
        public CauldronObsidianEntry(boolean lavaInCauldron) {
            super(FluidUtil.getFilledBucket((FluidStack)new FluidStack(lavaInCauldron ? FluidRegistry.WATER : FluidRegistry.LAVA, 1000)), lavaInCauldron ? PossibleFluids.Lava : PossibleFluids.Water, new ItemStack[0]);
        }

        @Override
        public ItemStack getOutput() {
            return new ItemStack(Blocks.field_150343_Z);
        }

        @Override
        public boolean isRecipeValid() {
            return true;
        }
    }

    public static class SimpleCauldronCookingEntry
    extends CauldronCookingEntry {
        protected final int maxOutput;

        public SimpleCauldronCookingEntry(ItemStack rightClickItem, ItemStack output, ItemStack byproduct, int max, ItemStack ... input) {
            super(rightClickItem, PossibleFluids.Water, output, byproduct, input);
            this.maxOutput = Math.max(output.func_190916_E(), max);
        }

        public SimpleCauldronCookingEntry(ItemStack rightClickItem, ItemStack output, int max, ItemStack ... input) {
            this(rightClickItem, output, ItemStack.field_190927_a, max, input);
        }

        public SimpleCauldronCookingEntry(ItemStack rightClickItem, ItemStack output, ItemStack byproduct, ItemStack ... input) {
            this(rightClickItem, output, byproduct, 1, input);
        }

        public SimpleCauldronCookingEntry(ItemStack rightClickItem, ItemStack output, ItemStack ... input) {
            this(rightClickItem, output, 1, input);
        }

        public int getMaxOutput() {
            return this.maxOutput;
        }
    }

    public static class CauldronCookingEntry
    extends CauldronEntry {
        protected final ItemStack output;
        protected final ItemStack byproduct;

        public CauldronCookingEntry(ItemStack rightClickItem, PossibleFluids fluid, ItemStack output, ItemStack byproduct, ItemStack ... input) {
            super(rightClickItem, fluid, input);
            this.output = output;
            this.byproduct = byproduct;
        }

        @Override
        public ItemStack getOutput() {
            return this.output;
        }

        @Override
        public ItemStack getByproduct() {
            return this.byproduct;
        }

        @Override
        public boolean isRecipeValid() {
            return !this.output.func_190926_b();
        }
    }

    public static class CauldronImbuingEntry
    extends CauldronEntry {
        protected Enchantment enchantment;

        public CauldronImbuingEntry(ItemStack rightClickItem, Enchantment enchantment, ItemStack ... input) {
            super(rightClickItem, input);
            this.enchantment = enchantment;
        }

        @Override
        public ItemStack getOutput() {
            ItemStack stack = this.rightClickItem.func_77946_l();
            stack.func_77966_a(this.enchantment, 1);
            return stack;
        }

        @Override
        public boolean isRecipeValid() {
            return this.enchantment != null;
        }
    }
}

