/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag;

import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagEntry;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class LootBagWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    private static final DecimalFormat round = new DecimalFormat("#.##");
    private final LootBagEntry entry;

    public LootBagWrapper(LootBagEntry entry) {
        this.entry = entry;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(this.entry.getInput()));
        ingredients.setOutputLists(VanillaTypes.ITEM, this.entry.getOutputs().stream().map(LootBagEntry.BagOutputEntry::getItems).collect(Collectors.toList()));
    }

    public LootBagEntry getEntry() {
        return this.entry;
    }

    @ParametersAreNonnullByDefault
    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        float chance;
        if (slotIndex > 0 && slotIndex <= this.entry.getOutputs().size() && (chance = this.entry.getOutputs().get(slotIndex - 1).getChance()) > 0.0f) {
            tooltip.add(I18n.func_135052_a((String)"mia.generic.chance", (Object[])new Object[]{round.format(chance)}));
        }
    }
}

