/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jer;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.JerConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.CustomLinkedHashSet;
import com.github.sokyranthedragon.mia.integrations.jer.CustomLinkedList;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JeiJerIntegration;
import com.github.sokyranthedragon.mia.utilities.LootTableUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IMobRegistry;
import jeresources.api.IPlantRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.compatibility.JERAPI;
import jeresources.entry.MobEntry;
import jeresources.entry.VillagerEntry;
import jeresources.registry.MobRegistry;
import jeresources.registry.VillagerRegistry;
import jeresources.util.FakeClientWorld;
import jeresources.util.LootTableHelper;
import jeresources.util.MobTableBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class JustEnoughResources
implements IBaseMod {
    private final Map<ModIds, IJerIntegration> modIntegrations = new HashMap<ModIds, IJerIntegration>();
    private final Set<Class<? extends EntityLivingBase>> ignoreMobOverrides = new HashSet<Class<? extends EntityLivingBase>>();
    private JeiJerIntegration jeiIntegration;
    private boolean insertedEarly;

    public JustEnoughResources() {
        Field field;
        try {
            field = MobRegistry.getInstance().getClass().getDeclaredField("registry");
            field.setAccessible(true);
            CustomLinkedHashSet mobOverrideSet = new CustomLinkedHashSet();
            mobOverrideSet.jer = this;
            field.set(MobRegistry.getInstance(), mobOverrideSet);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access MobRegistry.registry, mob loot overrides won't work.");
        }
        try {
            field = VillagerRegistry.getInstance().getClass().getDeclaredField("villagers");
            field.setAccessible(true);
            CustomLinkedList villagerOverrideList = new CustomLinkedList();
            villagerOverrideList.jer = this;
            field.set(VillagerRegistry.getInstance(), villagerOverrideList);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access VillagerRegistry.villagers, villager trade overrides won't work.");
        }
    }

    public static ResourceLocation loadResource(String path) {
        return new ResourceLocation("mia", path);
    }

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (ModIds.JEI.isLoaded) {
            this.jeiIntegration = new JeiJerIntegration();
            modIntegration.accept(ModIds.JEI, this.jeiIntegration);
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!JerConfiguration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof IJerIntegration) {
            this.modIntegrations.put(integration.getModId(), (IJerIntegration)integration);
        } else {
            Mia.LOGGER.warn("Incorrect JER integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.insertedEarly = this.jeiIntegration.initializePlugins(this);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.insertedEarly) {
            try {
                this.initJerIntegration();
            }
            catch (Exception e) {
                Mia.LOGGER.error("Encountered an issue registering JER entries! (Post-init registration)");
                Mia.LOGGER.error((Object)e);
            }
        }
    }

    void initJerIntegration() {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"JustEnoughResources entry registration", (int)(this.modIntegrations.size() + 1));
        progressBar.step("setting up");
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            world = new FakeClientWorld();
        }
        MobTableBuilder vanillaMobTableBuilder = new MobTableBuilder((World)world);
        IMobRegistry mobRegistry = JERAPI.getInstance().getMobRegistry();
        IPlantRegistry plantRegistry = JERAPI.getInstance().getPlantRegistry();
        Collection registers = null;
        if (this.jeiIntegration.registeredPlants) {
            try {
                Field registersField = plantRegistry.getClass().getDeclaredField("registers");
                registersField.setAccessible(true);
                registers = (Collection)registersField.get(plantRegistry);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                Mia.LOGGER.error("Could not access IPlantRegistry.registers, some plants might not have growing display in JER.");
            }
        }
        if (Items.field_185163_cU instanceof IPlantable) {
            plantRegistry.register((Item)((IPlantable)Items.field_185163_cU), new PlantDrop[]{new PlantDrop(new ItemStack(Items.field_185164_cV), 1, 1), new PlantDrop(new ItemStack(Items.field_185163_cU), 0, 3)});
        }
        if (Items.field_151075_bm instanceof IPlantable) {
            plantRegistry.registerWithSoil((Item)((IPlantable)Items.field_151075_bm), Blocks.field_150425_aM.func_176223_P(), new PlantDrop[]{new PlantDrop(new ItemStack(Items.field_151075_bm), 2, 4)});
        }
        vanillaMobTableBuilder.add((ResourceLocation)LootTableUtils.loadUniqueEmptyLootTable(), EntityWither.class);
        Optional wither = vanillaMobTableBuilder.getMobTables().entrySet().stream().findAny();
        wither.ifPresent(entry -> mobRegistry.register((EntityLivingBase)entry.getValue(), LightLevel.any, 50, new LootDrop[]{new LootDrop(new ItemStack(Items.field_151156_bN), 1, 1, 1.0f, 0, new Conditional[0])}));
        LootTableManager manager = null;
        try {
            manager = LootTableHelper.getManager((World)world);
        }
        catch (Exception e) {
            Mia.LOGGER.error("Encountered an issue registering JER loot table helper! A lot of mob drops might be broken!");
            e.printStackTrace();
        }
        IDungeonRegistry dungeonRegistry = JERAPI.getInstance().getDungeonRegistry();
        HashMap<Object, ModIds> allMobs = new HashMap<Object, ModIds>();
        CustomMobTableBuilder mobTableBuilder = new CustomMobTableBuilder((World)world, allMobs, this.ignoreMobOverrides);
        for (IJerIntegration mod : this.modIntegrations.values()) {
            progressBar.step(mod.getModId().modId);
            mobTableBuilder.currentId = mod.getModId();
            mod.addMobs(mobTableBuilder);
            mod.addMobRenderHooks(mobRegistry);
            mod.addPlantDrops(plantRegistry, registers);
            mod.addDungeonLoot(dungeonRegistry, (World)world);
            mod.addVillagerTrades(VillagerRegistry.getInstance(), this.jeiIntegration.registeredVillagers);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        Set entries = mobTableBuilder.getMobTables().entrySet();
        if (!entries.isEmpty()) {
            progressBar = ProgressManager.push((String)"JustEnoughResources mob configuration", (int)entries.size());
            for (Map.Entry entry2 : entries) {
                ResourceLocation resource = (ResourceLocation)entry2.getKey();
                progressBar.step(resource.toString());
                EntityLivingBase entity = (EntityLivingBase)entry2.getValue();
                this.modIntegrations.get(allMobs.get(entity.getClass())).configureMob(resource, entity, manager, mobRegistry);
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Override
    public void loadCompleted(FMLLoadCompleteEvent event) {
    }

    void overrideMobDrop(MobEntry entry) {
        if (this.ignoreMobOverrides.contains(entry.getEntity().getClass())) {
            return;
        }
        for (IJerIntegration mod : this.modIntegrations.values()) {
            mod.overrideExistingMobDrops(entry);
        }
    }

    void overrideVillagerTrades(VillagerEntry entry) {
        for (IJerIntegration mod : this.modIntegrations.values()) {
            mod.overrideExistingVillagerTrades(entry);
        }
    }

    public static class CustomMobTableBuilder
    extends MobTableBuilder {
        ModIds currentId = null;
        private Map<Object, ModIds> allMobs;
        private Set<Class<? extends EntityLivingBase>> ignoreMobOverrides;

        public CustomMobTableBuilder(World world, Map<Object, ModIds> allMobs, Set<Class<? extends EntityLivingBase>> ignoreMobOverrides) {
            super(world);
            this.allMobs = allMobs;
            this.ignoreMobOverrides = ignoreMobOverrides;
        }

        public <T extends EntityLivingBase> void add(ResourceLocation resourceLocation, Class<T> entityClass) {
            assert (this.currentId != null);
            this.allMobs.put(entityClass, this.currentId);
            super.add(resourceLocation, entityClass);
        }

        public <T extends EntityLivingBase> void add(ResourceLocation resourceLocation, Class<T> entityClass, @Nullable MobTableBuilder.EntityPropertySetter<T> entityPropertySetter) {
            assert (this.currentId != null);
            this.allMobs.put(entityClass, this.currentId);
            super.add(resourceLocation, entityClass, entityPropertySetter);
        }

        public <T extends EntityLivingBase> void addWithIgnore(ResourceLocation resourceLocation, Class<T> entityClass) {
            this.ignoreMobOverrides.add(entityClass);
            this.add(resourceLocation, entityClass);
        }

        public <T extends EntityLivingBase> void addWithIgnore(ResourceLocation resourceLocation, Class<T> entityClass, @Nullable MobTableBuilder.EntityPropertySetter<T> entityPropertySetter) {
            this.ignoreMobOverrides.add(entityClass);
            this.add(resourceLocation, entityClass, entityPropertySetter);
        }

        public <T extends EntityLivingBase> void addNoConfigure(ResourceLocation resourceLocation, Class<T> entityClass) {
            super.add(resourceLocation, entityClass);
        }

        public <T extends EntityLivingBase> void addNoConfigure(ResourceLocation resourceLocation, Class<T> entityClass, @Nullable MobTableBuilder.EntityPropertySetter<T> entityPropertySetter) {
            super.add(resourceLocation, entityClass, entityPropertySetter);
        }
    }
}

