/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jer.custom;

import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomVillagerEntry;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import jeresources.entry.VillagerEntry;
import jeresources.jei.villager.VillagerWrapper;
import jeresources.reference.Resources;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CustomVillagerWrapper
extends VillagerWrapper {
    public final VillagerEntry entry;
    public IFocus<ItemStack> focus;

    public CustomVillagerWrapper(VillagerEntry entry) {
        super(entry);
        this.entry = entry;
    }

    public void setFocus(IFocus<ItemStack> focus) {
        super.setFocus(focus);
        this.focus = focus;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int i;
        EntityLivingBase entity;
        if (!(this.entry instanceof CustomVillagerEntry)) {
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
            return;
        }
        CustomVillagerEntry entry = (CustomVillagerEntry)this.entry;
        try {
            entity = entry.getEntity(minecraft);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ignored) {
            return;
        }
        RenderHelper.scissor((Minecraft)minecraft, (int)7, (int)43, (int)59, (int)79);
        RenderHelper.renderEntity((int)37, (int)118, (float)entry.getRenderScale(), (float)(38 - mouseX), (float)(80 - mouseY), (EntityLivingBase)entity);
        RenderHelper.stopScissor();
        int y = 22 * (6 - this.getPossibleLevels(this.focus).size()) / 2;
        for (i = 0; i < this.getPossibleLevels(this.focus).size(); ++i) {
            RenderHelper.drawTexture((int)130, (int)(y + i * 22), (int)0, (int)120, (int)20, (int)20, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
        }
        i = 0;
        Iterator iterator = this.getPossibleLevels(this.focus).iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            Font.normal.print((Object)("lv. " + (level + 1)), 72, y + i++ * 22 + 6);
        }
        Font.normal.print((Object)TranslationHelper.translateToLocal((String)this.entry.getDisplayName()), 10, 25);
    }
}

