/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.mocreatures;

import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.MoCreaturesConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.ExtraConditional;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import com.github.sokyranthedragon.mia.utilities.LootTableUtils;
import com.pam.harvestcraft.item.ItemRegistry;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.ambient.MoCEntityAnt;
import drzhark.mocreatures.entity.ambient.MoCEntityBee;
import drzhark.mocreatures.entity.ambient.MoCEntityButterfly;
import drzhark.mocreatures.entity.ambient.MoCEntityCrab;
import drzhark.mocreatures.entity.ambient.MoCEntityDragonfly;
import drzhark.mocreatures.entity.ambient.MoCEntityFly;
import drzhark.mocreatures.entity.ambient.MoCEntityMaggot;
import drzhark.mocreatures.entity.ambient.MoCEntityRoach;
import drzhark.mocreatures.entity.ambient.MoCEntitySnail;
import drzhark.mocreatures.entity.aquatic.MoCEntityAnchovy;
import drzhark.mocreatures.entity.aquatic.MoCEntityAngelFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityAngler;
import drzhark.mocreatures.entity.aquatic.MoCEntityBass;
import drzhark.mocreatures.entity.aquatic.MoCEntityClownFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityCod;
import drzhark.mocreatures.entity.aquatic.MoCEntityDolphin;
import drzhark.mocreatures.entity.aquatic.MoCEntityGoldFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityHippoTang;
import drzhark.mocreatures.entity.aquatic.MoCEntityJellyFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityManderin;
import drzhark.mocreatures.entity.aquatic.MoCEntityMantaRay;
import drzhark.mocreatures.entity.aquatic.MoCEntityPiranha;
import drzhark.mocreatures.entity.aquatic.MoCEntitySalmon;
import drzhark.mocreatures.entity.aquatic.MoCEntityShark;
import drzhark.mocreatures.entity.monster.MoCEntityCaveOgre;
import drzhark.mocreatures.entity.monster.MoCEntityFireOgre;
import drzhark.mocreatures.entity.monster.MoCEntityFlameWraith;
import drzhark.mocreatures.entity.monster.MoCEntityGreenOgre;
import drzhark.mocreatures.entity.monster.MoCEntityHellRat;
import drzhark.mocreatures.entity.monster.MoCEntityHorseMob;
import drzhark.mocreatures.entity.monster.MoCEntityManticore;
import drzhark.mocreatures.entity.monster.MoCEntityOgre;
import drzhark.mocreatures.entity.monster.MoCEntityRat;
import drzhark.mocreatures.entity.monster.MoCEntityScorpion;
import drzhark.mocreatures.entity.monster.MoCEntitySilverSkeleton;
import drzhark.mocreatures.entity.monster.MoCEntityWWolf;
import drzhark.mocreatures.entity.monster.MoCEntityWerewolf;
import drzhark.mocreatures.entity.monster.MoCEntityWraith;
import drzhark.mocreatures.entity.passive.MoCEntityBear;
import drzhark.mocreatures.entity.passive.MoCEntityBigCat;
import drzhark.mocreatures.entity.passive.MoCEntityBird;
import drzhark.mocreatures.entity.passive.MoCEntityBlackBear;
import drzhark.mocreatures.entity.passive.MoCEntityBoar;
import drzhark.mocreatures.entity.passive.MoCEntityCrocodile;
import drzhark.mocreatures.entity.passive.MoCEntityDeer;
import drzhark.mocreatures.entity.passive.MoCEntityDuck;
import drzhark.mocreatures.entity.passive.MoCEntityEnt;
import drzhark.mocreatures.entity.passive.MoCEntityFox;
import drzhark.mocreatures.entity.passive.MoCEntityGoat;
import drzhark.mocreatures.entity.passive.MoCEntityGrizzlyBear;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.entity.passive.MoCEntityKomodo;
import drzhark.mocreatures.entity.passive.MoCEntityLeopard;
import drzhark.mocreatures.entity.passive.MoCEntityLion;
import drzhark.mocreatures.entity.passive.MoCEntityMole;
import drzhark.mocreatures.entity.passive.MoCEntityMouse;
import drzhark.mocreatures.entity.passive.MoCEntityOstrich;
import drzhark.mocreatures.entity.passive.MoCEntityPandaBear;
import drzhark.mocreatures.entity.passive.MoCEntityPanther;
import drzhark.mocreatures.entity.passive.MoCEntityPetScorpion;
import drzhark.mocreatures.entity.passive.MoCEntityPolarBear;
import drzhark.mocreatures.entity.passive.MoCEntityRaccoon;
import drzhark.mocreatures.entity.passive.MoCEntitySnake;
import drzhark.mocreatures.entity.passive.MoCEntityTiger;
import drzhark.mocreatures.entity.passive.MoCEntityTurkey;
import drzhark.mocreatures.entity.passive.MoCEntityTurtle;
import drzhark.mocreatures.entity.passive.MoCEntityWyvern;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.item.MoCItemFood;
import drzhark.mocreatures.item.MoCItemWeapon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IMobRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.ExtendedConditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.render.IMobRenderHook;
import jeresources.util.MobTableBuilder;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.BiomeDictionary;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class JerMoCreaturesIntegration
implements IJerIntegration {
    private static IMobRenderHook<?> RENDER_HOOK_GENERIC_HIGHER = (renderInfo, entityLivingBase) -> {
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        return renderInfo;
    };
    private static final IMobRenderHook<?> RENDER_HOOK_GENERIC_LOWER = (renderInfo, entityLivingBase) -> {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
        return renderInfo;
    };

    JerMoCreaturesIntegration() {
    }

    @Override
    public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
        int i;
        for (i = 21; i <= 26; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityHorse.class, new GenericVariantSetter(i));
        }
        for (i = 38; i <= 40; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityHorse.class, new GenericVariantSetter(i));
        }
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityHorse.class, new GenericVariantSetter(32));
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityHorse.class, new GenericVariantSetter(36));
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityBird.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityBoar.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityCrocodile.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityDeer.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityDuck.class);
        for (i = 0; i <= 2; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityEnt.class, new GenericVariantSetter(i));
        }
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityFox.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityGoat.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityKomodo.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityMole.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityMouse.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityRaccoon.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityTurkey.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityTurtle.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityBlackBear.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityGrizzlyBear.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityPandaBear.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityPolarBear.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityLeopard.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityLion.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityPanther.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityTiger.class);
        for (i = 4; i <= 8; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityOstrich.class, new GenericVariantSetter(i));
        }
        for (i = 1; i <= 5; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityPetScorpion.class, new GenericVariantSetter(i));
        }
        for (i = 1; i <= 5; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntitySnake.class, new GenericVariantSetter(i));
        }
        for (i = 1; i <= 5; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityWyvern.class, new GenericVariantSetter(i));
        }
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityCaveOgre.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityFireOgre.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityGreenOgre.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityWraith.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityFlameWraith.class);
        for (i = 1; i <= 4; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityManticore.class, new GenericVariantSetter(i));
        }
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityRat.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityHellRat.class);
        for (i = 1; i <= 4; ++i) {
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityScorpion.class, new GenericVariantSetter(i));
        }
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntitySilverSkeleton.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityWerewolf.class, new WerewolfSetter(true));
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityWerewolf.class, new WerewolfSetter(false));
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityWWolf.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityCrab.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntitySnail.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityMaggot.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityDolphin.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityJellyFish.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityShark.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityBass.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityCod.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntitySalmon.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityAnchovy.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityAngelFish.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityAngler.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityClownFish.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityGoldFish.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityHippoTang.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityManderin.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), MoCEntityPiranha.class);
    }

    @Override
    public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        HashSet validBiomes = new HashSet();
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        LightLevel lightLevel = LightLevel.any;
        int experienceMin = 5;
        int experienceMax = 5;
        if (entity instanceof EntityAnimal || entity instanceof MoCEntityAquatic) {
            experienceMin = 1;
            experienceMax = 3;
        }
        if (entity instanceof MoCEntityHorse) {
            Item normal;
            boolean alwaysRare = MoCreatures.proxy.rareItemDropChance >= 100;
            boolean neverRare = MoCreatures.proxy.rareItemDropChance <= 0;
            float chance = (float)MoCreatures.proxy.rareItemDropChance / 100.0f;
            MoCItem rare = null;
            switch (((MoCEntityHorse)entity).getType()) {
                case 21: 
                case 22: {
                    normal = Items.field_151073_bk;
                    break;
                }
                case 23: 
                case 24: 
                case 25: {
                    rare = MoCItems.heartundead;
                    normal = Items.field_151078_bh;
                    break;
                }
                case 26: {
                    normal = Items.field_151103_aS;
                    break;
                }
                case 32: {
                    rare = MoCItems.heartdarkness;
                    normal = Items.field_151116_aA;
                    break;
                }
                case 38: {
                    rare = MoCItems.heartfire;
                    normal = Items.field_151116_aA;
                    break;
                }
                case 39: 
                case 40: {
                    normal = Items.field_151008_G;
                    break;
                }
                case 36: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    rare = MoCItems.unicornhorn;
                    normal = Items.field_151116_aA;
                    break;
                }
                default: {
                    normal = Items.field_151116_aA;
                }
            }
            if (!(rare == null || neverRare && normal != null)) {
                if (normal == null) {
                    chance = 1.0f;
                }
                drops.add(new LootDrop((Item)rare, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
            }
            if (!(normal == null || alwaysRare && rare != null)) {
                if (rare == null) {
                    chance = 0.0f;
                }
                drops.add(new LootDrop(normal, 0, 2, 1.0f - chance, new Conditional[]{Conditional.affectedByLooting}));
            }
        } else if (entity instanceof MoCEntityBear) {
            drops.add(new LootDrop((Item)MoCItems.animalHide, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityBigCat) {
            drops.add(new LootDrop((Item)MoCItems.bigcatclaw, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityOstrich) {
            boolean alwaysRare = MoCreatures.proxy.rareItemDropChance >= 100;
            boolean neverRare = MoCreatures.proxy.rareItemDropChance <= 0;
            float chance = (float)MoCreatures.proxy.rareItemDropChance / 100.0f;
            MoCItemFood meatItem = MoCItems.ostrichraw;
            MoCItem rareItem = null;
            switch (((MoCEntityOstrich)entity).getType()) {
                case 5: {
                    rareItem = MoCItems.heartfire;
                    break;
                }
                case 6: {
                    rareItem = MoCItems.heartdarkness;
                    break;
                }
                case 7: {
                    rareItem = MoCItems.heartundead;
                    meatItem = Items.field_151078_bh;
                    break;
                }
                case 8: {
                    rareItem = MoCItems.unicornhorn;
                    break;
                }
                default: {
                    chance = 0.0f;
                }
            }
            if (!neverRare && rareItem != null) {
                drops.add(new LootDrop((Item)rareItem, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
            }
            if (!alwaysRare || rareItem == null) {
                LootDrop drop = new LootDrop((Item)MoCItems.ostrichraw, 0, 2, 1.0f - chance, new Conditional[]{Conditional.affectedByLooting});
                drops.add(drop);
                if (MiaConfig.addCookedDrops && meatItem == MoCItems.ostrichraw) {
                    drop.smeltedItem = new ItemStack((Item)MoCItems.ostrichcooked);
                }
            }
        } else if (entity instanceof MoCEntitySnake) {
            drops.add(new LootDrop((Item)MoCItems.mocegg, ((MoCEntitySnake)entity).getType() + 20, 0, 2, 1.0f, new Conditional[]{ExtraConditional.isAdult}));
        } else if (entity instanceof MoCEntityBird) {
            drops.add(new LootDrop(Items.field_151008_G, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityDuck) {
            drops.add(new LootDrop(Items.field_151008_G, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
            if (ModIds.HARVESTCRAFT.isLoaded) {
                LootDrop meat = new LootDrop(new ItemStack(ItemRegistry.duckrawItem), 0, 2, new Conditional[]{Conditional.affectedByLooting});
                drops.add(meat);
                if (MiaConfig.addCookedDrops) {
                    meat.smeltedItem = new ItemStack(ItemRegistry.duckcookedItem);
                }
            }
        } else if (entity instanceof MoCEntityBoar) {
            LootDrop meat = new LootDrop(Items.field_151147_al, 0, 2, 0.5f, new Conditional[]{Conditional.affectedByLooting});
            drops.add(meat);
            drops.add(new LootDrop((Item)MoCItems.animalHide, 0, 2, 0.5f, new Conditional[]{Conditional.affectedByLooting}));
            if (MiaConfig.addCookedDrops) {
                meat.smeltedItem = new ItemStack(Items.field_151157_am);
            }
        } else if (entity instanceof MoCEntityCrocodile) {
            drops.add(new LootDrop((Item)MoCItems.hideCroc, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityEnt) {
            int type = ((MoCEntityEnt)entity).getType();
            drops.add(new LootDrop(new ItemStack(Blocks.field_150364_r, 1, type), 11, 15, 0.33333334f, new Conditional[0]));
            drops.add(new LootDrop(Items.field_151055_y, 11, 15, 0.33333334f, new Conditional[0]));
            drops.add(new LootDrop(new ItemStack(Blocks.field_150345_g, 1, type), 11, 15, 0.33333334f, new Conditional[0]));
        } else if (entity instanceof MoCEntityGoat) {
            drops.add(new LootDrop(Items.field_151116_aA, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityKomodo) {
            drops.add(new LootDrop((Item)MoCItems.hideCroc, 1, 1, 0.8f, new Conditional[0]));
            drops.add(new LootDrop((Item)MoCItems.mocegg, 33, 1, 2, 0.2f, new Conditional[]{ExtraConditional.isAdult}));
        } else if (entity instanceof MoCEntityMouse) {
            drops.add(new LootDrop(Items.field_151014_N, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityTurkey) {
            LootDrop meat = new LootDrop((Item)MoCItems.rawTurkey, 0, 2, 0.5f, new Conditional[]{Conditional.affectedByLooting});
            drops.add(meat);
            drops.add(new LootDrop(Items.field_151008_G, 0, 2, 0.5f, new Conditional[]{Conditional.affectedByLooting}));
            if (MiaConfig.addCookedDrops) {
                meat.smeltedItem = new ItemStack((Item)MoCItems.cookedTurkey);
            }
        } else if (entity instanceof MoCEntityTurtle) {
            LootDrop meat = new LootDrop((Item)MoCItems.turtleraw, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting});
            drops.add(meat);
            drops.add(new LootDrop((Item)MoCItems.bo, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting, new ExtendedConditional(ExtraConditional.named, "'Donatello', 'donatello'")}));
            drops.add(new LootDrop((Item)MoCItems.katana, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting, new ExtendedConditional(ExtraConditional.named, "'Leonardo', 'leonardo'")}));
            drops.add(new LootDrop((Item)MoCItems.sai, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting, new ExtendedConditional(ExtraConditional.named, "'Rafael', 'rafael', 'Raphael', 'raphael'")}));
            drops.add(new LootDrop((Item)MoCItems.nunchaku, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting, new ExtendedConditional(ExtraConditional.named, "'Michelangelo', 'michelangelo', 'Michaelangelo', 'michaelangelo'")}));
            if (ModIds.HARVESTCRAFT.isLoaded) {
                meat.smeltedItem = new ItemStack(ItemRegistry.turtlecookedItem);
            }
        } else if (entity instanceof MoCEntityWyvern) {
            int type = ((MoCEntityWyvern)entity).getType();
            float chance = type == 5 ? (float)MoCreatures.proxy.motherWyvernEggDropChance : (float)MoCreatures.proxy.rareItemDropChance;
            drops.add(new LootDrop((Item)MoCItems.mocegg, type + 49, 1, 1, chance, new Conditional[0]));
        } else if (entity instanceof MoCEntityFox || entity instanceof MoCEntityMole || entity instanceof MoCEntityRaccoon || entity instanceof MoCEntityWWolf) {
            drops.add(new LootDrop((Item)MoCItems.fur, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityDeer) {
            drops.add(new LootDrop((Item)MoCItems.fur, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
            if (ModIds.HARVESTCRAFT.isLoaded) {
                LootDrop meat = new LootDrop(new ItemStack(ItemRegistry.venisonrawItem), 0, 2, new Conditional[]{Conditional.affectedByLooting});
                drops.add(meat);
                if (MiaConfig.addCookedDrops) {
                    meat.smeltedItem = new ItemStack(ItemRegistry.venisoncookedItem);
                }
            }
        } else if (entity instanceof MoCEntityScorpion || entity instanceof MoCEntityPetScorpion) {
            MoCItem chitin;
            MoCItemWeapon sting;
            boolean alwaysRare = MoCreatures.proxy.rareItemDropChance >= 100;
            boolean neverRare = MoCreatures.proxy.rareItemDropChance <= 0;
            float chance = (float)MoCreatures.proxy.rareItemDropChance / 100.0f;
            switch (((IMoCEntity)entity).getType()) {
                case 1: {
                    sting = MoCItems.scorpStingDirt;
                    chitin = MoCItems.chitin;
                    break;
                }
                case 2: {
                    sting = MoCItems.scorpStingCave;
                    chitin = MoCItems.chitinCave;
                    break;
                }
                case 3: {
                    sting = MoCItems.scorpStingNether;
                    chitin = MoCItems.chitinNether;
                    break;
                }
                case 4: {
                    sting = MoCItems.scorpStingFrost;
                    chitin = MoCItems.chitinFrost;
                    break;
                }
                case 5: {
                    sting = Items.field_151078_bh;
                    chitin = null;
                    break;
                }
                default: {
                    sting = null;
                    chitin = null;
                }
            }
            drops.add(new LootDrop(Items.field_151007_F, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting, ExtraConditional.isNotAdult}));
            if (!neverRare && sting != null) {
                if (chitin == null) {
                    chance = 1.0f;
                }
                drops.add(new LootDrop((Item)sting, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
            }
            if (!alwaysRare && chitin != null) {
                if (sting == null) {
                    chance = 0.0f;
                }
                drops.add(new LootDrop((Item)chitin, 0, 2, 1.0f - chance, new Conditional[]{Conditional.affectedByLooting}));
            }
        } else if (entity instanceof MoCEntityManticore) {
            int type = ((MoCEntityManticore)entity).getType();
            boolean alwaysRare = MoCreatures.proxy.rareItemDropChance >= 100;
            boolean neverRare = MoCreatures.proxy.rareItemDropChance <= 0;
            float chanceEgg = (float)MoCreatures.proxy.rareItemDropChance / 100.0f;
            if (!neverRare) {
                drops.add(new LootDrop((Item)MoCItems.mocegg, type + 61, 1, 1, chanceEgg, new Conditional[0]));
            }
            if (!alwaysRare) {
                MoCItem chitin;
                MoCItemWeapon sting;
                float chanceAfterEgg = 1.0f - chanceEgg;
                float chanceSting = chanceAfterEgg * chanceEgg;
                switch (type) {
                    case 1: {
                        sting = MoCItems.scorpStingNether;
                        chitin = MoCItems.chitinNether;
                        break;
                    }
                    case 2: {
                        sting = MoCItems.scorpStingCave;
                        chitin = MoCItems.chitinCave;
                        break;
                    }
                    case 3: {
                        sting = MoCItems.scorpStingFrost;
                        chitin = MoCItems.chitinFrost;
                        break;
                    }
                    case 4: {
                        sting = MoCItems.scorpStingDirt;
                        chitin = MoCItems.chitin;
                        break;
                    }
                    default: {
                        sting = null;
                        chitin = MoCItems.chitin;
                    }
                }
                if (!neverRare && sting != null) {
                    drops.add(new LootDrop((Item)sting, 0, 2, chanceSting, new Conditional[]{Conditional.affectedByLooting}));
                }
                float chanceChitin = sting == null ? chanceAfterEgg : chanceAfterEgg - chanceSting;
                drops.add(new LootDrop((Item)chitin, 0, 2, chanceChitin, new Conditional[]{Conditional.affectedByLooting}));
            }
        } else if (entity instanceof MoCEntityCaveOgre) {
            drops.add(new LootDrop(Items.field_151045_i, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityFireOgre) {
            if (MoCreatures.proxy.rareItemDropChance > 0) {
                drops.add(new LootDrop((Item)MoCItems.heartfire, 0, 2, (float)MoCreatures.proxy.rareItemDropChance / 100.0f, new Conditional[]{Conditional.affectedByLooting}));
            }
        } else if (entity instanceof MoCEntityGreenOgre) {
            drops.add(new LootDrop(new ItemStack(Blocks.field_150343_Z), 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityHellRat) {
            if (MoCreatures.proxy.rareItemDropChance < 100) {
                drops.add(new LootDrop(Items.field_151137_ax, 0, 2, 1.0f - (float)MoCreatures.proxy.rareItemDropChance / 100.0f, new Conditional[]{Conditional.affectedByLooting}));
            }
        } else if (entity instanceof MoCEntityRat) {
            LootDrop meat = new LootDrop((Item)MoCItems.ratRaw, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting});
            drops.add(meat);
            if (MiaConfig.addCookedDrops) {
                meat.smeltedItem = new ItemStack((Item)MoCItems.ratCooked);
            }
        } else if (entity instanceof MoCEntitySilverSkeleton) {
            drops.add(new LootDrop(Items.field_151103_aS, 0, 2, 0.9f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop((Item)MoCItems.silversword, 0, 2, 0.1f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityWerewolf) {
            float chance = 0.083333336f;
            if (((MoCEntityWerewolf)entity).getIsHumanForm()) {
                drops.add(new LootDrop(Items.field_151038_n, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151053_p, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151041_m, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151017_I, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151039_o, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151055_y, 0, 2, 0.4166667f, new Conditional[]{Conditional.affectedByLooting}));
            } else {
                drops.add(new LootDrop(Items.field_151019_K, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151037_a, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151036_c, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151035_b, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151040_l, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151018_J, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151051_r, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151049_t, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151050_s, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151052_q, 0, 2, chance, new Conditional[]{Conditional.affectedByLooting}));
                drops.add(new LootDrop(Items.field_151153_ao, 0, 2, 0.8333333f, new Conditional[]{Conditional.affectedByLooting}));
            }
        } else if (entity instanceof MoCEntityFlameWraith) {
            drops.add(new LootDrop(Items.field_151137_ax, 0, 2, 1.0f, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityCrab) {
            LootDrop drop = new LootDrop((Item)MoCItems.crabraw, 0, 2, new Conditional[]{Conditional.affectedByLooting});
            drops.add(drop);
            if (MiaConfig.addCookedDrops) {
                drop.smeltedItem = new ItemStack((Item)MoCItems.crabcooked);
            }
        } else if (entity instanceof MoCEntitySnail || entity instanceof MoCEntityMaggot) {
            drops.add(new LootDrop(Items.field_151123_aH, 0, 2, new Conditional[]{Conditional.affectedByLooting}));
        } else if (entity instanceof MoCEntityJellyFish) {
            drops.add(new LootDrop(Items.field_151123_aH, 0, 2, new Conditional[]{Conditional.affectedByLooting}));
            if (ModIds.HARVESTCRAFT.isLoaded) {
                drops.add(new LootDrop(new ItemStack(ItemRegistry.jellyfishrawItem), 0, 2, new Conditional[]{Conditional.affectedByLooting}));
            }
        } else if (entity instanceof MoCEntityDolphin) {
            LootDrop drop = new LootDrop(Items.field_151115_aP, 0, 2, new Conditional[]{Conditional.affectedByLooting});
            drops.add(drop);
            if (MiaConfig.addCookedDrops) {
                drop.smeltedItem = new ItemStack(Items.field_179566_aV);
            }
        } else if (entity instanceof MoCEntityShark) {
            drops.add(new LootDrop((Item)MoCItems.sharkteeth, 1, 3, 0.9f, new Conditional[0]));
            drops.add(new LootDrop((Item)MoCItems.mocegg, 11, 0, 2, 0.1f, new Conditional[]{new ExtendedConditional(Conditional.pastWorldDifficulty, I18n.func_135052_a((String)"options.difficulty.peaceful", (Object[])new Object[0])), ExtraConditional.isAdult}));
        } else if (entity instanceof MoCEntityBass) {
            if (ModIds.HARVESTCRAFT.isLoaded) {
                this.addFishDrops(drops, 72, ItemRegistry.bassrawItem);
            } else {
                this.addFishDrops(drops, 72);
            }
        } else if (entity instanceof MoCEntityCod) {
            this.addFishDrops(drops, 71);
        } else if (entity instanceof MoCEntitySalmon) {
            this.addFishDrops(drops, 70, Items.field_151115_aP, Items.field_179566_aV, 1);
        } else if (entity instanceof MoCEntityAnchovy) {
            if (ModIds.HARVESTCRAFT.isLoaded) {
                this.addFishDrops(drops, 80, ItemRegistry.anchovyrawItem);
            } else {
                this.addFishDrops(drops, 80);
            }
        } else if (entity instanceof MoCEntityAngelFish) {
            this.addFishDrops(drops, 81);
        } else if (entity instanceof MoCEntityAngler) {
            this.addFishDrops(drops, 82);
        } else if (entity instanceof MoCEntityClownFish) {
            this.addFishDrops(drops, 83, Items.field_151115_aP, Items.field_179566_aV, 2);
        } else if (entity instanceof MoCEntityGoldFish) {
            this.addFishDrops(drops, 84);
        } else if (entity instanceof MoCEntityHippoTang) {
            this.addFishDrops(drops, 85);
        } else if (entity instanceof MoCEntityManderin) {
            this.addFishDrops(drops, 86);
        } else if (entity instanceof MoCEntityPiranha) {
            this.addFishDrops(drops, 90);
        }
        if (entity instanceof MoCEntityMob) {
            lightLevel = LightLevel.hostile;
        }
        if (entity instanceof MoCEntityMantaRay) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        } else if (entity instanceof MoCEntityAquatic) {
            boolean noSwamp = entity instanceof MoCEntityDolphin;
            boolean noBeachSwamp = entity instanceof MoCEntityJellyFish || entity instanceof MoCEntityShark;
            boolean noRiver = entity instanceof MoCEntityAngler || entity instanceof MoCEntityClownFish || entity instanceof MoCEntityHippoTang || entity instanceof MoCEntityManderin;
            boolean noOcean = entity instanceof MoCEntityGoldFish;
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WATER));
            if (!noBeachSwamp) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
            }
            if (!noSwamp && !noBeachSwamp) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
            }
            if (!noOcean) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
            }
            if (!noRiver) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
            }
        } else if (entity instanceof MoCEntityHellRat) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DEAD));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
        } else if (entity instanceof MoCEntityMob) {
            boolean fireOgre = entity instanceof MoCEntityFireOgre;
            boolean greenOgre = entity instanceof MoCEntityGreenOgre;
            boolean manticore = entity instanceof MoCEntityManticore;
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            if (!greenOgre && !fireOgre) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
            }
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
            if (!manticore) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
            }
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
            if (entity instanceof MoCEntityHorseMob || fireOgre || manticore) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DEAD));
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
            } else if (entity instanceof MoCEntityCaveOgre || entity instanceof MoCEntitySilverSkeleton || entity instanceof MoCEntityWraith || greenOgre) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DEAD));
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
            } else if (entity instanceof MoCEntityScorpion) {
                validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
            }
        } else if (entity instanceof MoCEntityCrab) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WATER));
        } else {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            if (!(entity instanceof MoCEntitySnail)) {
                if (entity instanceof MoCEntityMaggot || entity instanceof MoCEntityRoach) {
                    validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                } else {
                    validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
                    validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    if (!(entity instanceof MoCEntityBee) && !(entity instanceof MoCEntityButterfly)) {
                        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                        if (entity instanceof MoCEntityAnt || entity instanceof MoCEntityFly) {
                            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                        } else if (entity instanceof MoCEntityDragonfly) {
                            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
                        }
                    }
                }
            }
        }
        LootDrop[] dropsArray = drops.toArray(new LootDrop[0]);
        if (validBiomes.isEmpty()) {
            mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, dropsArray);
        } else {
            mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, (String[])validBiomes.stream().map(Biome::func_185359_l).toArray(String[]::new), dropsArray);
        }
    }

    @Override
    public void addMobRenderHooks(IMobRegistry mobRegistry) {
        mobRegistry.registerRenderHook(MoCEntityWerewolf.class, RENDER_HOOK_GENERIC_LOWER);
        mobRegistry.registerRenderHook(MoCEntityWraith.class, RENDER_HOOK_GENERIC_LOWER);
        mobRegistry.registerRenderHook(MoCEntityOgre.class, RENDER_HOOK_GENERIC_LOWER);
        mobRegistry.registerRenderHook(MoCEntitySilverSkeleton.class, RENDER_HOOK_GENERIC_LOWER);
        mobRegistry.registerRenderHook(MoCEntityCrocodile.class, RENDER_HOOK_GENERIC_HIGHER);
        mobRegistry.registerRenderHook(MoCEntityBird.class, RENDER_HOOK_GENERIC_HIGHER);
        mobRegistry.registerRenderHook(MoCEntityPetScorpion.class, RENDER_HOOK_GENERIC_HIGHER);
        mobRegistry.registerRenderHook(MoCEntityCrab.class, RENDER_HOOK_GENERIC_HIGHER);
        mobRegistry.registerRenderHook(MoCEntityKomodo.class, RENDER_HOOK_GENERIC_HIGHER);
    }

    @Override
    public ModIds getModId() {
        return ModIds.MO_CREATURES;
    }

    private void addFishDrops(List<LootDrop> drops, int eggMeta) {
        this.addFishDrops(drops, eggMeta, Items.field_190931_a);
    }

    private void addFishDrops(List<LootDrop> drops, int eggMeta, Item replacement) {
        this.addFishDrops(drops, eggMeta, replacement, Items.field_190931_a);
    }

    private void addFishDrops(List<LootDrop> drops, int eggMeta, Item replacement, Item cooked) {
        this.addFishDrops(drops, eggMeta, new ItemStack(replacement), new ItemStack(cooked));
    }

    private void addFishDrops(List<LootDrop> drops, int eggMeta, Item replacement, Item cooked, int meta) {
        this.addFishDrops(drops, eggMeta, new ItemStack(replacement, 1, meta), new ItemStack(cooked, 1, meta));
    }

    private void addFishDrops(List<LootDrop> drops, int eggMeta, ItemStack replacement, ItemStack cooked) {
        if (MoCreaturesConfiguration.replaceFishDrops && !replacement.func_190926_b()) {
            LootDrop drop = new LootDrop(replacement, 1, 1, 0.7f, new Conditional[0]);
            drops.add(drop);
            if (!cooked.func_190926_b()) {
                drop.smeltedItem = cooked;
            }
        } else {
            LootDrop drop = new LootDrop(Items.field_151115_aP, 1, 1, 0.7f, new Conditional[0]);
            drops.add(drop);
            if (MiaConfig.addCookedDrops) {
                drop.smeltedItem = new ItemStack(Items.field_179566_aV);
            }
        }
        drops.add(new LootDrop((Item)MoCItems.mocegg, eggMeta, 0, 1, 0.3f, new Conditional[0]));
    }

    private static class WerewolfSetter
    implements MobTableBuilder.EntityPropertySetter<MoCEntityWerewolf> {
        private final boolean human;

        WerewolfSetter(boolean human) {
            this.human = human;
        }

        public void setProperties(MoCEntityWerewolf entity) {
            entity.setHumanForm(this.human);
        }
    }

    private static class GenericVariantSetter<T extends EntityLivingBase>
    implements MobTableBuilder.EntityPropertySetter<T> {
        private final int variant;

        GenericVariantSetter(int variant) {
            this.variant = variant;
        }

        public void setProperties(EntityLivingBase entity) {
            if (entity instanceof IMoCEntity) {
                ((IMoCEntity)entity).setType(this.variant);
            }
        }
    }
}

