/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.mocreatures;

import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.MoCreaturesConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.mocreatures.DungeonTacticsMoCreaturesIntegration;
import com.github.sokyranthedragon.mia.integrations.mocreatures.FutureMcMoCreaturesIntegration;
import com.github.sokyranthedragon.mia.integrations.mocreatures.HatcheryMoCreaturesIntegration;
import com.github.sokyranthedragon.mia.integrations.mocreatures.IndustrialForegoingMoCreaturesIntegration;
import com.github.sokyranthedragon.mia.integrations.mocreatures.JerMoCreaturesIntegration;
import com.github.sokyranthedragon.mia.integrations.mocreatures.ThermalExpansionMoCreaturesIntegration;
import com.github.sokyranthedragon.mia.integrations.mocreatures.client.MoCRenderMediumFishJer;
import com.github.sokyranthedragon.mia.integrations.mocreatures.client.MoCRenderSnakeJer;
import com.github.sokyranthedragon.mia.integrations.mocreatures.client.MoCRenderTurtleJer;
import com.pam.harvestcraft.item.ItemRegistry;
import drzhark.mocreatures.entity.aquatic.MoCEntityBass;
import drzhark.mocreatures.entity.aquatic.MoCEntityCod;
import drzhark.mocreatures.entity.aquatic.MoCEntitySalmon;
import drzhark.mocreatures.entity.passive.MoCEntitySnake;
import drzhark.mocreatures.entity.passive.MoCEntityTurtle;
import drzhark.mocreatures.init.MoCBlocks;
import drzhark.mocreatures.init.MoCItems;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class MoCreatures
implements IBaseMod {
    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (MoCreaturesConfiguration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerMoCreaturesIntegration());
        }
        if (MoCreaturesConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionMoCreaturesIntegration());
        }
        if (MoCreaturesConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsMoCreaturesIntegration());
        }
        if (MoCreaturesConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcMoCreaturesIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryMoCreaturesIntegration(MoCreaturesConfiguration.enableHatcheryIntegration));
        }
        if (MoCreaturesConfiguration.enableIFIntegration && ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            modIntegration.accept(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoingMoCreaturesIntegration());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!MoCreaturesConfiguration.moCreaturesAdditionsEnabled) {
            return;
        }
        FurnaceRecipes smelting = FurnaceRecipes.func_77602_a();
        if (!MiaConfig.disableAllRecipes) {
            NonNullList nuggets;
            if (ModIds.HARVESTCRAFT.isLoaded) {
                smelting.func_151396_a((Item)MoCItems.turtleraw, new ItemStack(ItemRegistry.turtlecookedItem), 0.1f);
            }
            if ((nuggets = OreDictionary.getOres((String)"nuggetSilver")).size() > 0) {
                smelting.func_151396_a((Item)MoCItems.silversword, (ItemStack)nuggets.get(0), 0.1f);
            }
        }
        if (!MiaConfig.disableOreDict) {
            OreDictionary.registerOre((String)"foodTurtleraw", (Item)MoCItems.turtleraw);
            OreDictionary.registerOre((String)"foodTurtlesoup", (Item)MoCItems.turtlesoup);
            OreDictionary.registerOre((String)"foodTurkeyraw", (Item)MoCItems.rawTurkey);
            OreDictionary.registerOre((String)"listAllturkeyraw", (Item)MoCItems.rawTurkey);
            OreDictionary.registerOre((String)"listAllmeatraw", (Item)MoCItems.rawTurkey);
            OreDictionary.registerOre((String)"foodTurkeycooked", (Item)MoCItems.cookedTurkey);
            OreDictionary.registerOre((String)"listAllturkeycooked", (Item)MoCItems.cookedTurkey);
            OreDictionary.registerOre((String)"listAllmeatcooked", (Item)MoCItems.cookedTurkey);
            OreDictionary.registerOre((String)"foodCrabraw", (Item)MoCItems.crabraw);
            OreDictionary.registerOre((String)"foodCrabcooked", (Item)MoCItems.crabcooked);
            OreDictionary.registerOre((String)"foodRatraw", (Item)MoCItems.ratRaw);
            OreDictionary.registerOre((String)"listAllmeatraw", (Item)MoCItems.ratRaw);
            OreDictionary.registerOre((String)"foodRatcooked", (Item)MoCItems.ratCooked);
            OreDictionary.registerOre((String)"listAllmeatraw", (Item)MoCItems.ratCooked);
            OreDictionary.registerOre((String)"foodOstrichraw", (Item)MoCItems.ostrichraw);
            OreDictionary.registerOre((String)"listAllmeatraw", (Item)MoCItems.ostrichraw);
            OreDictionary.registerOre((String)"foodOstrichcooked", (Item)MoCItems.ostrichcooked);
            OreDictionary.registerOre((String)"listAllmeatraw", (Item)MoCItems.ostrichcooked);
            OreDictionary.registerOre((String)"foodRatburger", (Item)MoCItems.ratBurger);
            OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack((Item)MoCItems.mocegg, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"listAllegg", (ItemStack)new ItemStack((Item)MoCItems.mocegg, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"foodOmelet", (Item)MoCItems.omelet);
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)MoCBlocks.mocLog, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)MoCBlocks.mocPlank, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)MoCBlocks.mocLeaf, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"dirt", (ItemStack)new ItemStack((Block)MoCBlocks.mocDirt, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"record", (Item)MoCItems.recordshuffle);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (ModIds.JER.isLoaded && MoCreaturesConfiguration.enableJerIntegration && event.getSide() == Side.CLIENT) {
            this.registerRenderingOverride();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerRenderingOverride() {
        RenderingRegistry.registerEntityRenderingHandler(MoCEntityTurtle.class, (Render)new MoCRenderTurtleJer());
        RenderingRegistry.registerEntityRenderingHandler(MoCEntitySnake.class, (Render)new MoCRenderSnakeJer());
        RenderingRegistry.registerEntityRenderingHandler(MoCEntityBass.class, new MoCRenderMediumFishJer());
        RenderingRegistry.registerEntityRenderingHandler(MoCEntityCod.class, new MoCRenderMediumFishJer());
        RenderingRegistry.registerEntityRenderingHandler(MoCEntitySalmon.class, new MoCRenderMediumFishJer());
    }
}

