/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.natura;

import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.NaturaConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.natura.DungeonTacticsNaturaIntegration;
import com.github.sokyranthedragon.mia.integrations.natura.ExtraUtilsNaturaIntegration;
import com.github.sokyranthedragon.mia.integrations.natura.FutureMcNaturaIntegration;
import com.github.sokyranthedragon.mia.integrations.natura.HatcheryNaturaIntegration;
import com.github.sokyranthedragon.mia.integrations.natura.JerNaturaIntegration;
import com.github.sokyranthedragon.mia.integrations.natura.ThermalExpansionNaturaIntegration;
import com.progwml6.natura.decorative.NaturaDecorative;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.shared.NaturaCommons;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;

public class Natura
implements IBaseMod {
    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (NaturaConfiguration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerNaturaIntegration());
        }
        if (NaturaConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionNaturaIntegration());
        }
        if (NaturaConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsNaturaIntegration());
        }
        if (NaturaConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcNaturaIntegration());
        }
        if (NaturaConfiguration.enableHatcheryIntegration && ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryNaturaIntegration());
        }
        if (NaturaConfiguration.enableXu2Integration && ModIds.EXTRA_UTILITIES.isLoaded) {
            modIntegration.accept(ModIds.EXTRA_UTILITIES, new ExtraUtilsNaturaIntegration());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!NaturaConfiguration.naturaAdditionsEnabled) {
            return;
        }
        if (!MiaConfig.disableOreDict) {
            if (com.progwml6.natura.Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
                OreDictionary.registerOre((String)"foodAllfruit", (Item)NaturaOverworld.saguaroFruitItem);
                OreDictionary.registerOre((String)"cropCactusfruit", (Item)NaturaOverworld.saguaroFruitItem);
                OreDictionary.registerOre((String)"blockCactus", (Block)NaturaOverworld.saguaro);
                if (com.progwml6.natura.Natura.pulseManager.isPulseLoaded("NaturaCommons")) {
                    for (int meta = 2; meta <= 5; ++meta) {
                        OreDictionary.registerOre((String)"listAllberry", (ItemStack)new ItemStack((Item)NaturaCommons.edibles, 1, meta));
                    }
                }
                for (ItemStack itemStack : new ItemStack[]{NaturaOverworld.eucalyptus_door, NaturaOverworld.hopseed_door, NaturaOverworld.sakura_door, NaturaOverworld.redwood_door, NaturaOverworld.redwood_bark_door, NaturaOverworld.tiger_door, NaturaOverworld.maple_door, NaturaOverworld.silverbell_door}) {
                    OreDictionary.registerOre((String)"doorWood", (ItemStack)itemStack);
                }
            }
            if (com.progwml6.natura.Natura.pulseManager.isPulseLoaded("NaturaNether")) {
                if (com.progwml6.natura.Natura.pulseManager.isPulseLoaded("NaturaCommons")) {
                    for (int meta = 6; meta <= 9; ++meta) {
                        OreDictionary.registerOre((String)"listAllberry", (ItemStack)new ItemStack((Item)NaturaCommons.edibles, 1, meta));
                    }
                }
                for (int meta = 0; meta <= 2; ++meta) {
                    OreDictionary.registerOre((String)"mushroomAny", (ItemStack)new ItemStack((Block)NaturaNether.netherGlowshroom, 1, Short.MAX_VALUE));
                    OreDictionary.registerOre((String)"listAllmushroom", (ItemStack)new ItemStack((Block)NaturaNether.netherGlowshroom, 1, Short.MAX_VALUE));
                }
                for (Block block : new ItemStack[]{NaturaNether.ghostwood_door, NaturaNether.bloodwood_door, NaturaNether.darkwood_door, NaturaNether.fusewood_door}) {
                    OreDictionary.registerOre((String)"doorWood", (ItemStack)block);
                }
            }
            if (com.progwml6.natura.Natura.pulseManager.isPulseLoaded("NaturaDecorative")) {
                if (com.progwml6.natura.Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
                    OreDictionary.registerOre((String)"workbench", (ItemStack)new ItemStack((Block)NaturaDecorative.overworldWorkbenches, 1, Short.MAX_VALUE));
                }
                if (com.progwml6.natura.Natura.pulseManager.isPulseLoaded("NaturaNether")) {
                    OreDictionary.registerOre((String)"workbench", (ItemStack)new ItemStack((Block)NaturaDecorative.netherWorkbenches, 1, Short.MAX_VALUE));
                }
                for (Block block : NaturaDecorative.buttons) {
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"buttonWood", (Block)block);
                }
                for (Block block : NaturaDecorative.pressurePlates) {
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"pressurePlateWood", (Block)block);
                }
                for (Block block : NaturaDecorative.trapDoors) {
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"trapdoorWood", (Block)block);
                }
                for (Block block : NaturaDecorative.fences) {
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"fenceWood", (Block)block);
                }
                for (Block block : NaturaDecorative.fenceGates) {
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"fenceGateWood", (Block)block);
                }
            }
        }
    }
}

