/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.quark;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.futuremc.FutureMc;
import com.github.sokyranthedragon.mia.integrations.futuremc.IFutureMcIntegration;
import com.github.sokyranthedragon.mia.utilities.ItemStackUtils;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import vazkii.quark.building.block.BlockWorldStoneBricks;
import vazkii.quark.building.block.BlockWorldStonePavement;
import vazkii.quark.building.feature.DuskboundBlocks;
import vazkii.quark.building.feature.MagmaBricks;
import vazkii.quark.building.feature.MidoriBlocks;
import vazkii.quark.building.feature.MoreSandstone;
import vazkii.quark.building.feature.PolishedNetherrack;
import vazkii.quark.building.feature.PolishedStone;
import vazkii.quark.building.feature.SandyBricks;
import vazkii.quark.building.feature.SnowBricks;
import vazkii.quark.building.feature.SoulSandstone;
import vazkii.quark.building.feature.VanillaStairsAndSlabs;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.building.feature.WorldStoneBricks;
import vazkii.quark.building.feature.WorldStonePavement;
import vazkii.quark.world.block.BlockElderPrismarine;
import vazkii.quark.world.feature.Basalt;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.Crabs;
import vazkii.quark.world.feature.Frogs;
import vazkii.quark.world.feature.RevampStoneGen;
import vazkii.quark.world.feature.UndergroundBiomes;

class FutureMcQuarkIntegration
implements IFutureMcIntegration {
    FutureMcQuarkIntegration() {
    }

    @Override
    public void addRecipes() {
        ItemStack input;
        boolean soulSandstoneEnabled = QuarkUtils.isFeatureEnabled(SoulSandstone.class);
        if (soulSandstoneEnabled) {
            FutureMc.addStonecutterRecipes(new ItemStack((Block)SoulSandstone.soul_sandstone), new ItemStack((Block)SoulSandstone.soul_sandstone, 1, 1), new ItemStack((Block)SoulSandstone.soul_sandstone, 1, 2));
            if (SoulSandstone.enableStairs) {
                FutureMcQuarkIntegration.registerStairs(new ItemStack((Block)SoulSandstone.soul_sandstone), "soul_sandstone");
            }
            if (SoulSandstone.enableWalls) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)SoulSandstone.soul_sandstone), "soul_sandstone");
            }
        }
        if (QuarkUtils.isFeatureEnabled(MoreSandstone.class)) {
            FutureMc.addStonecutterRecipes(new ItemStack(Blocks.field_150322_A), new ItemStack((Block)MoreSandstone.sandstone_new, 1, 0), new ItemStack((Block)MoreSandstone.sandstone_new, 1, 1));
            FutureMc.addStonecutterRecipes(new ItemStack(Blocks.field_180395_cM), new ItemStack((Block)MoreSandstone.sandstone_new, 1, 2), new ItemStack((Block)MoreSandstone.sandstone_new, 1, 3));
            if (soulSandstoneEnabled) {
                FutureMc.addStonecutterRecipes(new ItemStack((Block)SoulSandstone.soul_sandstone), new ItemStack((Block)MoreSandstone.sandstone_new, 1, 4), new ItemStack((Block)MoreSandstone.sandstone_new, 1, 5));
            }
            if (MoreSandstone.enableStairsAndSlabs) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)MoreSandstone.sandstone_new, 1, 1), "sandstone_bricks");
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)MoreSandstone.sandstone_new, 1, 3), "red_sandstone_bricks");
                FutureMcQuarkIntegration.registerSlabs(new ItemStack((Block)MoreSandstone.sandstone_new, 1, 0), "sandstone_smooth");
                FutureMcQuarkIntegration.registerSlabs(new ItemStack((Block)MoreSandstone.sandstone_new, 1, 1), "sandstone_smooth");
                FutureMcQuarkIntegration.registerSlabs(new ItemStack((Block)MoreSandstone.sandstone_new, 1, 2), "red_sandstone_smooth");
                FutureMcQuarkIntegration.registerSlabs(new ItemStack((Block)MoreSandstone.sandstone_new, 1, 3), "red_sandstone_smooth");
                if (soulSandstoneEnabled) {
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)MoreSandstone.sandstone_new, 1, 5), "soul_sandstone_bricks");
                    FutureMcQuarkIntegration.registerSlabs(new ItemStack((Block)MoreSandstone.sandstone_new, 1, 4), "soul_sandstone_smooth");
                }
            }
        }
        if (QuarkUtils.isFeatureEnabled(VanillaWalls.class)) {
            if (VanillaWalls.stone) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150348_b), "stone");
            }
            if (VanillaWalls.granite) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150348_b, 1, 1), "stone_granite");
            }
            if (VanillaWalls.diorite) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150348_b, 1, 3), "stone_diorite");
            }
            if (VanillaWalls.andesite) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150348_b, 1, 5), "stone_andesite");
            }
            if (VanillaWalls.sandstone) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150322_A), "sandstone");
            }
            if (VanillaWalls.redSandstone) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_180395_cM), "red_sandstone");
            }
            if (VanillaWalls.stoneBricks) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150417_aV), "stonebrick");
            }
            if (VanillaWalls.bricks) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150336_V), "brick");
            }
            if (VanillaWalls.quartz) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150371_ca), "quartz");
            }
            if (VanillaWalls.prismarine) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_180397_cI), "prismarine_rough");
            }
            if (VanillaWalls.prismarineBricks) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_180397_cI, 1, 1), "prismarine_bricks");
            }
            if (VanillaWalls.darkPrismarine) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_180397_cI, 1, 2), "dark_prismarine");
            }
            if (VanillaWalls.purpurBlock) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_185767_cT), "purpur_block");
            }
            if (VanillaWalls.endBricks) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_185772_cY), "end_bricks");
            }
            if (VanillaWalls.mossBricks) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Blocks.field_150417_aV, 1, 1), "stonebrick_mossy");
            }
        }
        if (QuarkUtils.isFeatureEnabled(VanillaStairsAndSlabs.class)) {
            if (VanillaStairsAndSlabs.stone) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_150348_b), "stone");
            }
            if (VanillaStairsAndSlabs.granite) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_150348_b, 1, 1), "stone_granite");
            }
            if (VanillaStairsAndSlabs.diorite) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_150348_b, 1, 3), "stone_diorite");
            }
            if (VanillaStairsAndSlabs.andesite) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_150348_b, 1, 5), "stone_andesite");
            }
            if (VanillaStairsAndSlabs.prismarine) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_180397_cI), "prismarine");
            }
            if (VanillaStairsAndSlabs.prismarineBricks) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_180397_cI, 1, 1), "prismarine_bricks");
            }
            if (VanillaStairsAndSlabs.darkPrismarine) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_180397_cI, 1, 2), "prismarine_dark");
            }
            if (VanillaStairsAndSlabs.endBricks) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_185772_cY), "end_bricks");
            }
            if (VanillaStairsAndSlabs.mossStone) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_150417_aV, 1, 1), "cobblestone_mossy");
            }
            if (VanillaStairsAndSlabs.mossBricks) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Blocks.field_150417_aV, 1, 1), "stonebrick_mossy");
            }
        }
        if (QuarkUtils.isFeatureEnabled(Biotite.class)) {
            FutureMc.addBlastFurnaceRecipe(new ItemStack(Biotite.biotite_ore), new ItemStack(Biotite.biotite));
            FutureMc.addStonecutterRecipes(new ItemStack(Biotite.biotite_block), new ItemStack(Biotite.biotite_block, 1, 1), new ItemStack(Biotite.biotite_block, 1, 2));
            FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(Biotite.biotite_block), "biotite");
            if (Biotite.enableWalls) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(Biotite.biotite_block), "biotite");
            }
        }
        if (QuarkUtils.isFeatureEnabled(PolishedStone.class)) {
            FutureMc.addStonecutterRecipes(new ItemStack(Blocks.field_150348_b), new ItemStack(PolishedStone.polished_stone));
            FutureMc.addStonecutterRecipes(new ItemStack(PolishedStone.polished_stone), new ItemStack((Block)Blocks.field_150333_U, 2));
        }
        if (QuarkUtils.isFeatureEnabled(PolishedNetherrack.class)) {
            FutureMc.addStonecutterRecipes(new ItemStack((Block)PolishedNetherrack.polished_netherrack), new ItemStack((Block)PolishedNetherrack.polished_netherrack, 1, 1));
            if (PolishedNetherrack.enableStairsAndSlabs) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)PolishedNetherrack.polished_netherrack), "polished_netherrack_bricks");
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)PolishedNetherrack.polished_netherrack, 1, 1), "polished_netherrack_bricks");
            }
            if (PolishedNetherrack.enableWalls) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)PolishedNetherrack.polished_netherrack), "polished_netherrack_bricks");
                FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)PolishedNetherrack.polished_netherrack, 1, 1), "polished_netherrack_bricks");
            }
        }
        if (QuarkUtils.isFeatureEnabled(RevampStoneGen.class)) {
            if (RevampStoneGen.enableMarble) {
                FutureMc.addStonecutterRecipes(new ItemStack((Block)RevampStoneGen.marble), new ItemStack((Block)RevampStoneGen.marble, 1, 1));
                if (RevampStoneGen.enableStairsAndSlabs) {
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)RevampStoneGen.marble), "stone_marble");
                }
                if (RevampStoneGen.enableWalls) {
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)RevampStoneGen.marble), "marble");
                }
            }
            if (RevampStoneGen.enableLimestone) {
                FutureMc.addStonecutterRecipes(new ItemStack((Block)RevampStoneGen.limestone), new ItemStack((Block)RevampStoneGen.limestone, 1, 1));
                if (RevampStoneGen.enableStairsAndSlabs) {
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)RevampStoneGen.limestone), "stone_limestone");
                }
                if (RevampStoneGen.enableWalls) {
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)RevampStoneGen.limestone), "limestone");
                }
            }
            if (RevampStoneGen.enableJasper) {
                FutureMc.addStonecutterRecipes(new ItemStack((Block)RevampStoneGen.jasper), new ItemStack((Block)RevampStoneGen.jasper, 1, 1));
                if (RevampStoneGen.enableStairsAndSlabs) {
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)RevampStoneGen.jasper), "stone_jasper");
                }
                if (RevampStoneGen.enableWalls) {
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)RevampStoneGen.jasper), "jasper");
                }
            }
            if (RevampStoneGen.enableSlate) {
                FutureMc.addStonecutterRecipes(new ItemStack((Block)RevampStoneGen.slate), new ItemStack((Block)RevampStoneGen.slate, 1, 1));
                if (RevampStoneGen.enableStairsAndSlabs) {
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)RevampStoneGen.slate), "stone_slate");
                }
                if (RevampStoneGen.enableWalls) {
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)RevampStoneGen.slate), "slate");
                }
            }
        }
        if (QuarkUtils.isFeatureEnabled(UndergroundBiomes.class)) {
            if (UndergroundBiomes.firestoneEnabled) {
                FutureMc.addStonecutterRecipes(new ItemStack((Block)UndergroundBiomes.biome_cobblestone), new ItemStack((Block)UndergroundBiomes.biome_brick));
                if (UndergroundBiomes.enableStairsAndSlabs) {
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)UndergroundBiomes.biome_cobblestone), "fire_stone");
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)UndergroundBiomes.biome_cobblestone), "fire_stone_brick");
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)UndergroundBiomes.biome_brick), "fire_stone_brick");
                }
                if (UndergroundBiomes.enableWalls) {
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)UndergroundBiomes.biome_cobblestone), "fire_stone");
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)UndergroundBiomes.biome_cobblestone), "fire_stone_brick");
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)UndergroundBiomes.biome_brick), "fire_stone_brick");
                }
            }
            if (UndergroundBiomes.icystoneEnabled) {
                FutureMc.addStonecutterRecipes(new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 1), new ItemStack((Block)UndergroundBiomes.biome_brick, 1, 1));
                if (UndergroundBiomes.enableStairsAndSlabs) {
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 1), "icy_stone");
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 1), "icy_stone_brick");
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)UndergroundBiomes.biome_brick, 1, 1), "icy_stone_brick");
                }
                if (UndergroundBiomes.enableWalls) {
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 1), "icy_stone");
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 1), "icy_stone_brick");
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)UndergroundBiomes.biome_brick, 1, 1), "icy_stone_brick");
                }
            }
            if (UndergroundBiomes.cobbedstoneEnabled) {
                if (UndergroundBiomes.enableStairsAndSlabs) {
                    FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 2), "cobbed_stone");
                }
                if (UndergroundBiomes.enableWalls) {
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 2), "cobbed_stone");
                }
            }
            if (UndergroundBiomes.elderPrismarineEnabled) {
                for (BlockElderPrismarine.Variants variants : BlockElderPrismarine.Variants.values()) {
                    if (UndergroundBiomes.enableStairsAndSlabs) {
                        FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)UndergroundBiomes.elder_prismarine, 1, variants.ordinal()), variants.func_176610_l());
                    }
                    if (!UndergroundBiomes.enableWalls) continue;
                    FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)UndergroundBiomes.elder_prismarine, 1, variants.ordinal()), variants.func_176610_l());
                }
            }
        }
        if (QuarkUtils.isFeatureEnabled(Basalt.class)) {
            FutureMc.addStonecutterRecipes(new ItemStack((Block)Basalt.basalt), new ItemStack((Block)Basalt.basalt, 1, 1));
            if (Basalt.enableStairsAndSlabs) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack((Block)Basalt.basalt), "stone_basalt");
            }
            if (Basalt.enableWalls) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack((Block)Basalt.basalt), "basalt");
            }
        }
        if (QuarkUtils.isFeatureEnabled(SandyBricks.class)) {
            if (SandyBricks.enableStairsAndSlabs) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(SandyBricks.sandy_bricks), "sandy_bricks");
            }
            if (SandyBricks.enableWalls) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(SandyBricks.sandy_bricks), "sandy_bricks");
            }
        }
        if (QuarkUtils.isFeatureEnabled(SnowBricks.class)) {
            if (SnowBricks.enableStairsAndSlabs) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(SnowBricks.snow_bricks), "snow_bricks");
            }
            if (SnowBricks.enableWalls) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(SnowBricks.snow_bricks), "snow_bricks");
            }
        }
        if (QuarkUtils.isFeatureEnabled(MidoriBlocks.class)) {
            FutureMc.addStonecutterRecipes(new ItemStack(MidoriBlocks.midori_block), new ItemStack(MidoriBlocks.midori_pillar));
            if (MidoriBlocks.enableStairsAndSlabs) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(MidoriBlocks.midori_block), "midori_block");
            }
            if (MidoriBlocks.enableWalls) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(MidoriBlocks.midori_block), "midori_block");
            }
        }
        if (QuarkUtils.isFeatureEnabled(MagmaBricks.class) && MagmaBricks.enableStairsAndSlabs) {
            FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(MagmaBricks.magma_bricks), "magma_bricks");
        }
        if (QuarkUtils.isFeatureEnabled(DuskboundBlocks.class)) {
            if (DuskboundBlocks.enableStairsAndSlabs) {
                FutureMcQuarkIntegration.registerStairsAndSlabs(new ItemStack(DuskboundBlocks.duskbound_block), "duskbound_block");
            }
            if (DuskboundBlocks.enableWalls) {
                FutureMcQuarkIntegration.registerWalls(new ItemStack(DuskboundBlocks.duskbound_block), "duskbound_block");
            }
        }
        if (QuarkUtils.isFeatureEnabled(WorldStonePavement.class)) {
            for (BlockElderPrismarine.Variants variants : BlockWorldStonePavement.Variants.values()) {
                if (!variants.isEnabled()) continue;
                input = ItemStack.field_190927_a;
                switch (1.$SwitchMap$vazkii$quark$building$block$BlockWorldStonePavement$Variants[variants.ordinal()]) {
                    case 1: {
                        input = new ItemStack(Blocks.field_150348_b, 1, 1);
                        break;
                    }
                    case 2: {
                        input = new ItemStack(Blocks.field_150348_b, 1, 3);
                        break;
                    }
                    case 3: {
                        input = new ItemStack(Blocks.field_150348_b, 1, 5);
                        break;
                    }
                    case 4: {
                        input = new ItemStack((Block)Basalt.basalt);
                        break;
                    }
                    case 5: {
                        input = new ItemStack((Block)RevampStoneGen.marble);
                        break;
                    }
                    case 6: {
                        input = new ItemStack((Block)RevampStoneGen.limestone);
                        break;
                    }
                    case 7: {
                        input = new ItemStack((Block)RevampStoneGen.jasper);
                        break;
                    }
                    case 8: {
                        input = new ItemStack((Block)RevampStoneGen.slate);
                    }
                }
                if (input.func_190926_b()) continue;
                FutureMc.addStonecutterRecipes(input, new ItemStack(WorldStonePavement.world_stone_pavement, 1, variants.ordinal()));
            }
        }
        if (QuarkUtils.isFeatureEnabled(WorldStoneBricks.class)) {
            for (BlockElderPrismarine.Variants variants : BlockWorldStoneBricks.Variants.values()) {
                input = ItemStack.field_190927_a;
                ItemStack inputSecond = ItemStack.field_190927_a;
                if (!variants.isEnabled()) continue;
                switch (1.$SwitchMap$vazkii$quark$building$block$BlockWorldStoneBricks$Variants[variants.ordinal()]) {
                    case 1: {
                        input = new ItemStack(Blocks.field_150348_b, 1, 1);
                        inputSecond = new ItemStack(Blocks.field_150348_b, 1, 2);
                        break;
                    }
                    case 2: {
                        input = new ItemStack(Blocks.field_150348_b, 1, 3);
                        inputSecond = new ItemStack(Blocks.field_150348_b, 1, 4);
                        break;
                    }
                    case 3: {
                        input = new ItemStack(Blocks.field_150348_b, 1, 5);
                        inputSecond = new ItemStack(Blocks.field_150348_b, 1, 6);
                        break;
                    }
                    case 4: {
                        if (Basalt.basalt == null) break;
                        input = new ItemStack((Block)Basalt.basalt);
                        inputSecond = new ItemStack((Block)Basalt.basalt, 1, 1);
                        break;
                    }
                    case 5: {
                        if (!RevampStoneGen.enableMarble) break;
                        input = new ItemStack((Block)RevampStoneGen.marble);
                        inputSecond = new ItemStack((Block)RevampStoneGen.marble, 1, 1);
                        break;
                    }
                    case 6: {
                        if (!RevampStoneGen.enableLimestone) break;
                        input = new ItemStack((Block)RevampStoneGen.limestone);
                        inputSecond = new ItemStack((Block)RevampStoneGen.limestone, 1, 1);
                        break;
                    }
                    case 7: {
                        if (!RevampStoneGen.enableJasper) break;
                        input = new ItemStack((Block)RevampStoneGen.jasper);
                        inputSecond = new ItemStack((Block)RevampStoneGen.jasper, 1, 1);
                        break;
                    }
                    case 8: {
                        if (!RevampStoneGen.enableSlate) break;
                        input = new ItemStack((Block)RevampStoneGen.slate);
                        inputSecond = new ItemStack((Block)RevampStoneGen.slate, 1, 1);
                    }
                }
                ItemStack brick = new ItemStack((Block)WorldStoneBricks.world_stone_bricks, 1, variants.ordinal());
                if (!input.func_190926_b()) {
                    FutureMc.addStonecutterRecipes(input, brick);
                }
                if (!inputSecond.func_190926_b()) {
                    FutureMc.addStonecutterRecipes(inputSecond, brick);
                }
                FutureMc.addStonecutterRecipes(brick, new ItemStack((Block)WorldStoneBricks.world_stone_chiseled, 1, variants.ordinal()));
                if (WorldStoneBricks.enableStairsAndSlabs) {
                    if (!input.func_190926_b()) {
                        FutureMcQuarkIntegration.registerStairsAndSlabs(input, variants.func_176610_l());
                    }
                    if (!inputSecond.func_190926_b()) {
                        FutureMcQuarkIntegration.registerStairsAndSlabs(input, variants.func_176610_l());
                    }
                    FutureMcQuarkIntegration.registerStairsAndSlabs(brick, variants.func_176610_l());
                }
                if (!WorldStoneBricks.enableWalls) continue;
                if (!input.func_190926_b()) {
                    FutureMcQuarkIntegration.registerWalls(input, variants.func_176610_l());
                }
                if (!inputSecond.func_190926_b()) {
                    FutureMcQuarkIntegration.registerWalls(inputSecond, variants.func_176610_l());
                }
                FutureMcQuarkIntegration.registerWalls(brick, variants.func_176610_l());
            }
        }
        if (QuarkUtils.isFeatureEnabled(Crabs.class)) {
            FutureMc.addFoodRecipe(new ItemStack((Item)Crabs.crabLeg), new ItemStack((Item)Crabs.cookedCrabLeg));
        }
        if (QuarkUtils.isFeatureEnabled(Frogs.class)) {
            FutureMc.addFoodRecipe(new ItemStack((Item)Frogs.frogLeg), new ItemStack((Item)Frogs.cookedFrogLeg));
        }
    }

    private static void registerStairsAndSlabs(ItemStack input, String name) {
        FutureMcQuarkIntegration.registerSlabs(input, name);
        FutureMcQuarkIntegration.registerStairs(input, name);
    }

    private static void registerSlabs(ItemStack input, String name) {
        ItemStackUtils.getStack(ModIds.QUARK, name + "_slab", 2).ifPresent(slab -> FutureMc.addStonecutterRecipes(input, slab));
    }

    private static void registerStairs(ItemStack input, String name) {
        ItemStackUtils.getStack(ModIds.QUARK, name + "_stairs").ifPresent(stairs -> FutureMc.addStonecutterRecipes(input, stairs));
    }

    private static void registerWalls(ItemStack input, String name) {
        ItemStackUtils.getStack(ModIds.QUARK, name + "_wall").ifPresent(wall -> FutureMc.addStonecutterRecipes(input, wall));
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.FUTURE_MC;
    }
}

