/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.quark;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.ExtraConditional;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import com.github.sokyranthedragon.mia.integrations.jer.ResourceLocationWrapper;
import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomVillagerEntry;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IMobRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.entry.MobEntry;
import jeresources.entry.VillagerEntry;
import jeresources.registry.VillagerRegistry;
import jeresources.util.LootTableHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.quark.vanity.feature.WitchHat;
import vazkii.quark.world.entity.EntityArchaeologist;
import vazkii.quark.world.entity.EntityAshen;
import vazkii.quark.world.entity.EntityCrab;
import vazkii.quark.world.entity.EntityDweller;
import vazkii.quark.world.entity.EntityFoxhound;
import vazkii.quark.world.entity.EntityFrog;
import vazkii.quark.world.entity.EntityPirate;
import vazkii.quark.world.entity.EntityStoneling;
import vazkii.quark.world.entity.EntityWraith;
import vazkii.quark.world.feature.Archaeologist;
import vazkii.quark.world.feature.BuriedTreasure;
import vazkii.quark.world.feature.Crabs;
import vazkii.quark.world.feature.DepthMobs;
import vazkii.quark.world.feature.Foxhounds;
import vazkii.quark.world.feature.Frogs;
import vazkii.quark.world.feature.NetherObsidianSpikes;
import vazkii.quark.world.feature.PirateShips;
import vazkii.quark.world.feature.Stonelings;
import vazkii.quark.world.feature.VariedDungeons;
import vazkii.quark.world.feature.Wraiths;

@ParametersAreNonnullByDefault
class JerQuarkIntegration
implements IJerIntegration {
    JerQuarkIntegration() {
    }

    @Override
    public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
        if (QuarkUtils.isFeatureEnabled(DepthMobs.class)) {
            if (DepthMobs.enableAshen) {
                builder.add(new ResourceLocationWrapper(LootTableList.field_186385_aj, 0), EntityAshen.class);
            }
            if (DepthMobs.enableDweller) {
                builder.add(new ResourceLocationWrapper(LootTableList.field_186383_ah), EntityDweller.class);
            }
        }
        if (QuarkUtils.isFeatureEnabled(PirateShips.class) && !PirateShips.onlyHat) {
            builder.add(new ResourceLocationWrapper(LootTableList.field_186385_aj, 1), EntityPirate.class);
        }
        if (QuarkUtils.isFeatureEnabled(Crabs.class)) {
            builder.add(EntityCrab.CRAB_LOOT_TABLE, EntityCrab.class);
        }
        if (QuarkUtils.isFeatureEnabled(Foxhounds.class)) {
            builder.add(EntityFoxhound.FOXHOUND_LOOT_TABLE, EntityFoxhound.class);
        }
        if (QuarkUtils.isFeatureEnabled(Frogs.class)) {
            builder.add(EntityFrog.FROG_LOOT_TABLE, EntityFrog.class);
        }
        if (QuarkUtils.isFeatureEnabled(Stonelings.class)) {
            builder.add(EntityStoneling.LOOT_TABLE, EntityStoneling.class);
        }
        if (QuarkUtils.isFeatureEnabled(Wraiths.class)) {
            builder.add(EntityWraith.LOOT_TABLE, EntityWraith.class);
        }
    }

    @Override
    public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        LightLevel lightLevel = LightLevel.any;
        HashSet<Biome> validBiomes = new HashSet<Biome>();
        List loot = null;
        if (manager != null) {
            loot = LootTableHelper.toDrops((LootTable)manager.func_186521_a(resource));
        }
        int experienceMin = 1;
        int experienceMax = 3;
        if (entity instanceof EntityAshen) {
            Collections.addAll(validBiomes, DepthMobs.getBiomesWithMob(EntitySkeleton.class));
        } else if (entity instanceof EntityDweller) {
            Collections.addAll(validBiomes, DepthMobs.getBiomesWithMob(EntityZombie.class));
        } else if (entity instanceof EntityPirate) {
            validBiomes.add(Biomes.field_76771_b);
            validBiomes.add(Biomes.field_150575_M);
            if (loot != null) {
                loot.add(new LootDrop(PirateShips.pirate_hat, 0.085f, new LootFunction[0]));
            }
        } else if (entity instanceof EntityCrab) {
            validBiomes.add(Biomes.field_76787_r);
        } else if (entity instanceof EntityFoxhound || entity instanceof EntityWraith) {
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        } else if (entity instanceof EntityFrog) {
            validBiomes.add(Biomes.field_76780_h);
        } else if (entity instanceof EntityStoneling) {
            Collections.addAll(validBiomes, DepthMobs.getBiomesWithMob(EntityZombie.class));
            if (loot != null) {
                List carryDrops = LootTableHelper.toDrops((LootTable)manager.func_186521_a(EntityStoneling.CARRY_LOOT_TABLE));
                for (LootDrop drop : carryDrops) {
                    drop.addConditional(ExtraConditional.carryingItem);
                }
                loot.addAll(carryDrops);
            }
        }
        if (entity instanceof EntityMob) {
            experienceMax = 5;
            experienceMin = 5;
        }
        if (loot == null) {
            if (validBiomes.isEmpty()) {
                mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, resource);
            } else {
                mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, (String[])validBiomes.stream().map(Biome::func_185359_l).toArray(String[]::new), resource);
            }
        } else {
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            if (validBiomes.isEmpty()) {
                mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, drops);
            } else {
                mobRegistry.register(entity, lightLevel, experienceMin, experienceMax, (String[])validBiomes.stream().map(Biome::func_185359_l).toArray(String[]::new), drops);
            }
        }
    }

    @Override
    public void overrideExistingMobDrops(MobEntry mobEntry) {
        if (mobEntry.getEntity() instanceof EntityWitch && QuarkUtils.isFeatureEnabled(WitchHat.class) && WitchHat.dropRate > 0.0) {
            Conditional[] conditionals = WitchHat.verifyTruePlayer && WitchHat.lootingBoost > 0.0 ? new Conditional[]{Conditional.affectedByLooting, Conditional.playerKill} : (WitchHat.verifyTruePlayer ? new Conditional[]{Conditional.playerKill} : (WitchHat.lootingBoost > 0.0 ? new Conditional[]{Conditional.affectedByLooting} : new Conditional[]{}));
            mobEntry.addDrop(new LootDrop(new ItemStack(WitchHat.witch_hat), 0, 1, (float)WitchHat.dropRate, 0, conditionals));
        }
    }

    @Override
    public void addDungeonLoot(IDungeonRegistry dungeonRegistry, World world) {
        if (QuarkUtils.isFeatureEnabled(PirateShips.class) && !PirateShips.onlyHat) {
            String pirateShip = "chests/quark_pirate_ship";
            dungeonRegistry.registerCategory("chests/quark_pirate_ship", "mia.jer.dungeon.quark_pirate_ship");
            dungeonRegistry.registerChest("chests/quark_pirate_ship", PirateShips.PIRATE_CHEST_LOOT_TABLE);
        }
        if (QuarkUtils.isFeatureEnabled(BuriedTreasure.class)) {
            String buriedTreasure = "chests/quark_buried_treasure";
            dungeonRegistry.registerCategory("chests/quark_buried_treasure", "mia.jer.dungeon.quark_buried_treasure");
            dungeonRegistry.registerChest("chests/quark_buried_treasure", (ResourceLocation)new ResourceLocationWrapper(LootTableList.field_186422_d));
        }
        if (QuarkUtils.isFeatureEnabled(NetherObsidianSpikes.class) && NetherObsidianSpikes.bigSpikeSpawners && NetherObsidianSpikes.bigSpikeChance > 0.0) {
            String obsidianSpikes = "chests/quark_nether_obsidian_spikes";
            dungeonRegistry.registerCategory("chests/quark_nether_obsidian_spikes", "mia.jer.dungeon.quark_nether_spikes");
            dungeonRegistry.registerChest("chests/quark_nether_obsidian_spikes", (ResourceLocation)new ResourceLocationWrapper(LootTableList.field_186425_g));
        }
        if (QuarkUtils.isFeatureEnabled(VariedDungeons.class) && VariedDungeons.lootTable != null) {
            dungeonRegistry.registerChest("chests/quark_simple_dungeon", (ResourceLocation)new ResourceLocationWrapper(VariedDungeons.lootTable, -1));
        }
    }

    @Override
    public void addVillagerTrades(VillagerRegistry villagerRegistry, boolean acceptsCustomEntries) {
        if (acceptsCustomEntries && QuarkUtils.isFeatureEnabled(Archaeologist.class)) {
            ArrayList allTrades = new ArrayList();
            ArrayList<BasicTrade> trades = new ArrayList<BasicTrade>();
            allTrades.add(trades);
            trades.add(new BasicTrade(new ItemStack(Items.field_151166_bC, 2), new ItemStack(Items.field_151103_aS, 3)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151103_aS, 10), new ItemStack(Items.field_151166_bC, 1)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151016_H, 7), new ItemStack(Items.field_151166_bC, 1)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151044_h, 16), new ItemStack(Items.field_151166_bC, 1)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151166_bC, 12), new ItemStack(Items.field_151045_i, 1)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151166_bC, 8), new ItemStack(Items.field_151035_b, 1)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151166_bC, 6), new ItemStack(Items.field_151037_a, 1)));
            if (Archaeologist.enableHat && Archaeologist.sellHat) {
                trades.add(new BasicTrade(new ItemStack(Items.field_151166_bC, 9), new ItemStack(Archaeologist.archaeologist_hat, 1)));
            }
            villagerRegistry.addVillagerEntry((VillagerEntry)new CustomVillagerEntry("quark:archaeologist", allTrades){

                @Override
                public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) {
                    return new EntityArchaeologist((World)minecraft.field_71441_e);
                }

                public String getDisplayName() {
                    return "entity." + this.getName() + ".name";
                }
            });
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.QUARK;
    }

    private static class BasicTrade
    implements EntityVillager.ITradeList {
        private ItemStack input;
        private ItemStack output;

        public BasicTrade(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void func_190888_a(IMerchant iMerchant, MerchantRecipeList merchantRecipeList, Random random) {
            merchantRecipeList.add((Object)new MerchantRecipe(this.input, this.output));
        }
    }
}

