/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.thaumcraft;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jei.IJeiIntegration;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagCategory;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagEntry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagRegistry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.internal.WeightedRandomLoot;
import thaumcraft.api.items.ItemsTC;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
class JeiThaumcraftIntegration
implements IJeiIntegration {
    JeiThaumcraftIntegration() {
    }

    @Override
    public void register(IModRegistry registry, Collection<String> registeredCategories) {
        if (registeredCategories.add("mia.loot_bag")) {
            registry.handleRecipes(LootBagEntry.class, LootBagWrapper::new, "mia.loot_bag");
            registry.addRecipes(LootBagRegistry.getRecipesOrEmpty(), "mia.loot_bag");
        }
        for (int i = 0; i < 3; ++i) {
            registry.addRecipeCatalyst((Object)new ItemStack(ItemsTC.lootBag, 1, i), new String[]{"mia.loot_bag"});
        }
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.lootCrateCommon), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.lootCrateUncommon), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.lootCrateRare), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.lootUrnCommon), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.lootUrnUncommon), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.lootUrnRare), new String[]{"mia.loot_bag"});
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registry, Collection<String> registeredCategories) {
        if (registeredCategories.add("mia.loot_bag")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new LootBagCategory(registry.getJeiHelpers().getGuiHelper(), new ItemStack(ItemsTC.lootBag, 1, 2))});
        }
    }

    @Override
    public void registerRecipes() {
        LootBagRegistry lootBagRegistry = LootBagRegistry.getInstance();
        if (lootBagRegistry != null) {
            this.registerLootBag(lootBagRegistry, WeightedRandomLoot.lootBagCommon, new ItemStack(ItemsTC.lootBag, 1, 0), new ItemStack(BlocksTC.lootCrateCommon), new ItemStack(BlocksTC.lootUrnCommon));
            this.registerLootBag(lootBagRegistry, WeightedRandomLoot.lootBagUncommon, new ItemStack(ItemsTC.lootBag, 1, 1), new ItemStack(BlocksTC.lootCrateUncommon), new ItemStack(BlocksTC.lootUrnUncommon));
            this.registerLootBag(lootBagRegistry, WeightedRandomLoot.lootBagRare, new ItemStack(ItemsTC.lootBag, 1, 2), new ItemStack(BlocksTC.lootCrateRare), new ItemStack(BlocksTC.lootUrnRare));
        } else {
            Mia.LOGGER.error("Could not access Loot Bag recipe registry, this shouldn't have happened. Something is very wrong.");
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.THAUMCRAFT;
    }

    private void registerLootBag(LootBagRegistry registry, Collection<WeightedRandomLoot> possibleOutputs, ItemStack ... stacks) {
        float totalWeight = possibleOutputs.stream().mapToInt(entry -> entry.field_76292_a).sum();
        Set<LootBagEntry.BagOutputEntry> bagOutputs = possibleOutputs.stream().map(entry -> new LootBagEntry.BagOutputEntry(Collections.singletonList(entry.item), (float)entry.field_76292_a / totalWeight * 100.0f)).collect(Collectors.toSet());
        List<LootBagEntry> entries = LootBagEntry.getEntries(Arrays.asList(stacks), bagOutputs);
        for (LootBagEntry entry2 : entries) {
            registry.registerLootBagRecipe(entry2);
        }
    }
}

