/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.thaumcraft;

import com.github.sokyranthedragon.mia.block.BlockVoidCreator;
import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.config.ThaumcraftConfiguration;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.dispenserbehavior.DispenserLootBag;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.ChiselThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.DungeonTacticsThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.ExtraUtilsThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.FutureMcThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.HatcheryThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.IndustrialForegoingThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.JeiThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.JerThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.ThermalExpansionThaumcraftIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.foci.FocusEffectSizeChange;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.foci.FocusEffectSizeStabilization;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.foci.FocusEffectSizeSteal;
import com.github.sokyranthedragon.mia.tile.TileVoidCreator;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.world.BlockLoot;
import thaumcraft.common.items.curios.ItemLootBag;
import thaumcraft.common.lib.utils.Utils;

public class Thaumcraft
implements IBaseMod {
    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (ModIds.JEI.isLoaded) {
            modIntegration.accept(ModIds.JEI, new JeiThaumcraftIntegration());
        }
        if (ThaumcraftConfiguration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerThaumcraftIntegration());
        }
        if (ThaumcraftConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionThaumcraftIntegration());
        }
        if (ThaumcraftConfiguration.enableXu2Integration && ModIds.EXTRA_UTILITIES.isLoaded) {
            modIntegration.accept(ModIds.EXTRA_UTILITIES, new ExtraUtilsThaumcraftIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryThaumcraftIntegration(ThaumcraftConfiguration.enableHatcheryIntegration));
        }
        if (ThaumcraftConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsThaumcraftIntegration());
        }
        if (ThaumcraftConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcThaumcraftIntegration());
        }
        if (ThaumcraftConfiguration.enableChiselIntegration && ModIds.CHISEL.isLoaded) {
            modIntegration.accept(ModIds.CHISEL, new ChiselThaumcraftIntegration());
        }
        if (ThaumcraftConfiguration.enableIFIntegration && ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            modIntegration.accept(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoingThaumcraftIntegration());
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (!ThaumcraftConfiguration.thaumcraftAdditionsEnabled) {
            return;
        }
        ThaumcraftApi.registerResearchLocation((ResourceLocation)ModIds.MIA.loadSimple("research/basics.json"));
        if (SizeUtils.isSizeComponentEnabled && GenericAdditionsConfig.sizeModule.thaumcraftIntegration) {
            ThaumcraftApi.registerResearchLocation((ResourceLocation)ModIds.MIA.loadSimple("research/auromancy_size.json"));
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!ThaumcraftConfiguration.thaumcraftAdditionsEnabled) {
            return;
        }
        if (SizeUtils.isSizeComponentEnabled && GenericAdditionsConfig.sizeModule.thaumcraftIntegration) {
            FocusEngine.registerElement(FocusEffectSizeChange.class, (ResourceLocation)ModIds.MIA.loadSimple("textures/foci/size_change.png"), (int)0xFF9999);
            FocusEngine.registerElement(FocusEffectSizeSteal.class, (ResourceLocation)ModIds.MIA.loadSimple("textures/foci/size_steal.png"), (int)0xFF9999);
            FocusEngine.registerElement(FocusEffectSizeStabilization.class, (ResourceLocation)ModIds.MIA.loadSimple("textures/foci/size_neutral.png"), (int)0xFF9999);
        }
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        if (!ThaumcraftConfiguration.thaumcraftAdditionsEnabled) {
            return;
        }
        MiaBlocks.voidCreator = MiaBlocks.registerBlock(new BlockVoidCreator());
        GameRegistry.registerTileEntity(TileVoidCreator.class, (ResourceLocation)ModIds.MIA.loadSimple("void_creator"));
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        if (!ThaumcraftConfiguration.thaumcraftAdditionsEnabled) {
            return;
        }
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)ModIds.MIA.loadSimple("void_creator"), (InfusionRecipe)new InfusionRecipe("MIA.VOID_CREATOR", (Object)new ItemStack(MiaBlocks.voidCreator), 9, new AspectList().add(Aspect.ELDRITCH, 50).add(Aspect.CRAFT, 50).add(Aspect.ENTROPY, 50).add(Aspect.VOID, 100), (Object)new ItemStack(Items.field_151073_bk), new Object[]{new ItemStack(BlocksTC.stoneArcane), new ItemStack(BlocksTC.stoneArcane), new ItemStack(ItemsTC.mechanismComplex), "plateBrass", "plateBrass", new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151156_bN)}));
    }

    @Override
    public void registerDispenserBehaviors() {
        DispenserLootBag.getInstance().addListener((source, stack) -> {
            if (stack.func_77973_b() instanceof ItemLootBag) {
                stack.func_190918_g(1);
                IBehaviorDispenseItem defaultDispenserBehavior = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a(null);
                int count = 8 + source.func_82618_k().field_73012_v.nextInt(5);
                for (int i = 0; i < count; ++i) {
                    ItemStack lootItem = Utils.generateLoot((int)stack.func_77960_j(), (Random)source.func_82618_k().field_73012_v);
                    if (lootItem.func_190926_b()) continue;
                    defaultDispenserBehavior.func_82482_a(source, lootItem);
                }
                return true;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block instanceof BlockLoot) {
                stack.func_190918_g(1);
                IBehaviorDispenseItem defaultDispenserBehavior = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a(null);
                for (ItemStack lootItem : block.getDrops((IBlockAccess)source.func_82618_k(), source.func_180699_d(), source.func_189992_e(), 0)) {
                    if (lootItem.func_190926_b()) continue;
                    defaultDispenserBehavior.func_82482_a(source, lootItem);
                }
                return true;
            }
            return false;
        }, new ItemStack(ItemsTC.lootBag), new ItemStack(BlocksTC.lootCrateCommon), new ItemStack(BlocksTC.lootCrateUncommon), new ItemStack(BlocksTC.lootCrateRare), new ItemStack(BlocksTC.lootUrnCommon), new ItemStack(BlocksTC.lootUrnUncommon), new ItemStack(BlocksTC.lootUrnRare));
    }
}

