/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.theoneprobe;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeBrick;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeInput;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityEggInIce;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.theoneprobe.ITileProbeProgress;
import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.tileentities.TileEntityApiary;
import com.pam.harvestcraft.tileentities.TileEntityGrinder;
import com.pam.harvestcraft.tileentities.TileEntityGroundTrap;
import com.pam.harvestcraft.tileentities.TileEntityPresser;
import com.pam.harvestcraft.tileentities.TileEntityWaterFilter;
import com.pam.harvestcraft.tileentities.TileEntityWaterTrap;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import svenhjol.charm.crafting.block.BlockComposter;
import thaumcraft.common.blocks.devices.BlockVisBattery;
import thaumcraft.common.tiles.crafting.TileVoidSiphon;
import thaumcraft.common.tiles.devices.TileJarBrain;
import thaumcraft.common.tiles.devices.TileVisGenerator;
import thedarkcolour.futuremc.block.villagepillage.ComposterBlock;
import thedarkcolour.futuremc.tile.BeeHiveTile;
import thedarkcolour.futuremc.tile.TileComposter;

public class ProgressProvider
implements IProbeInfoProvider,
IProbeInfoEntityProvider {
    private static final Field moEggProgress;
    private static final Field iceFireDragonforgeInputCore;
    private static final Method harvestApiaryRunTime;
    private static final Method harvestGroundTrapRunTime;
    private static final Method harvestWaterTrapRunTime;
    private static final Method iceFireDragonforgeBrickCore;

    public String getID() {
        return "mia:progress";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof ITileProbeProgress) {
            ITileProbeProgress progressTile = (ITileProbeProgress)tile;
            this.addProgressData(probeInfo, progressTile.getProgress(), progressTile.getProgressMax(), progressTile.getProgressHexColor(), progressTile.getProgressTintHexColor(), progressTile.getProgressMessage());
            return;
        }
        if (ModIds.THAUMCRAFT.isLoaded) {
            if (blockState.func_177230_c() instanceof BlockVisBattery) {
                this.addProgressData(probeInfo, (Integer)blockState.func_177229_b((IProperty)BlockVisBattery.CHARGE), 10);
                return;
            }
            if (tile instanceof TileVoidSiphon) {
                TileVoidSiphon siphon = (TileVoidSiphon)tile;
                int n = siphon.progress;
                siphon.getClass();
                this.addProgressData(probeInfo, n, 2000, -13556425, -13885135);
                return;
            }
            if (tile instanceof TileVisGenerator) {
                TileVisGenerator generator = (TileVisGenerator)tile;
                this.addRfData(probeInfo, generator.getEnergyStored(), generator.getMaxEnergyStored());
                return;
            }
            if (tile instanceof TileJarBrain) {
                TileJarBrain brain = (TileJarBrain)tile;
                probeInfo.horizontal().progress(brain.xp, brain.xpMax, probeInfo.defaultProgressStyle().suffix("xp"));
                return;
            }
        }
        if (ModIds.ICE_AND_FIRE.isLoaded) {
            if (tile instanceof TileEntityJar) {
                TileEntityJar jar = (TileEntityJar)tile;
                if (jar.hasPixie) {
                    if (jar.hasProduced) {
                        this.addProgressData(probeInfo, 1, 1, -231982, -1939011);
                    } else {
                        this.addProgressData(probeInfo, jar.ticksExisted % 24000, 24000, -231982, -1939011);
                    }
                }
                return;
            }
            if (tile instanceof TileEntityEggInIce) {
                TileEntityEggInIce egg = (TileEntityEggInIce)tile;
                this.addProgressData(probeInfo, egg.age, IceAndFire.CONFIG.dragonEggTime);
                return;
            }
            if (tile instanceof TileEntityDragonforgeBrick) {
                if (iceFireDragonforgeBrickCore != null) {
                    try {
                        TileEntityDragonforgeBrick input = (TileEntityDragonforgeBrick)tile;
                        ICapabilityProvider capacity = (ICapabilityProvider)iceFireDragonforgeBrickCore.invoke((Object)input, new Object[0]);
                        if (capacity instanceof TileEntityDragonforge) {
                            TileEntityDragonforge forge = (TileEntityDragonforge)capacity;
                            this.addProgressData(probeInfo, forge.func_174887_a_(0), forge.getMaxCookTime(), forge.isFire ? -156872 : -14560258, forge.isFire ? -1864910 : -14828060);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            if (tile instanceof TileEntityDragonforgeInput) {
                if (iceFireDragonforgeInputCore != null) {
                    try {
                        TileEntityDragonforgeInput input = (TileEntityDragonforgeInput)tile;
                        TileEntityDragonforge forge = (TileEntityDragonforge)iceFireDragonforgeInputCore.get(input);
                        this.addProgressData(probeInfo, forge.func_174887_a_(0), forge.getMaxCookTime(), forge.isFire ? -156872 : -14560258, forge.isFire ? -1864910 : -14828060);
                    }
                    catch (IllegalAccessException e) {
                        Mia.LOGGER.error("Cannot access TileEntityDragonforgeInput core, even though it was found");
                    }
                }
                return;
            }
            if (tile instanceof TileEntityDragonforge) {
                TileEntityDragonforge forge = (TileEntityDragonforge)tile;
                this.addProgressData(probeInfo, forge.func_174887_a_(0), forge.getMaxCookTime(), forge.isFire ? -156872 : -14560258, forge.isFire ? -1864910 : -14828060);
                return;
            }
        }
        if (ModIds.HARVESTCRAFT.isLoaded) {
            if (tile instanceof TileEntityApiary) {
                if (harvestApiaryRunTime != null) {
                    TileEntityApiary apiary = (TileEntityApiary)tile;
                    try {
                        int maxProgress = (Integer)harvestApiaryRunTime.invoke((Object)apiary, new Object[0]);
                        this.addProgressData(probeInfo, apiary.produceTime, maxProgress, -3569918, -4949759);
                        probeInfo.text("Speed: " + (int)(3500.0f / (float)maxProgress * 100.0f) + "%");
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        Mia.LOGGER.error("Cannot access TileEntityApiary getRunTime(), even though it was found");
                        e.printStackTrace();
                    }
                }
                return;
            }
            if (tile instanceof TileEntityGroundTrap) {
                if (harvestGroundTrapRunTime != null) {
                    TileEntityGroundTrap trap = (TileEntityGroundTrap)tile;
                    int dirt = trap.countFlowers();
                    if (dirt < 5) {
                        probeInfo.text("Not enough grass and dirt in vicinity");
                        probeInfo.progress(dirt, 5);
                    } else {
                        try {
                            int maxProgress = (Integer)harvestGroundTrapRunTime.invoke((Object)trap, new Object[0]);
                            this.addProgressData(probeInfo, trap.produceTime, maxProgress);
                            probeInfo.text("Speed: " + (int)(3500.0f / (float)maxProgress * 100.0f) + "%");
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            Mia.LOGGER.error("Cannot access TileEntityGroundTrap getRunTime(), even though it was found");
                            e.printStackTrace();
                        }
                    }
                }
                return;
            }
            if (tile instanceof TileEntityWaterTrap) {
                TileEntityWaterTrap trap = (TileEntityWaterTrap)tile;
                int water = trap.countFlowers();
                if (water < 5) {
                    probeInfo.text("Not enough water in vicinity");
                    probeInfo.progress(water, 5);
                } else {
                    try {
                        int maxProgress = (Integer)harvestWaterTrapRunTime.invoke((Object)trap, new Object[0]);
                        this.addProgressData(probeInfo, trap.produceTime, maxProgress);
                        probeInfo.text("Speed: " + (int)(3500.0f / (float)maxProgress * 100.0f) + "%");
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        Mia.LOGGER.error("Cannot access TileEntityWaterTrap getRunTime(), even though it was found");
                        e.printStackTrace();
                    }
                }
                return;
            }
            if (tile instanceof TileEntityWaterFilter) {
                TileEntityWaterFilter filter = (TileEntityWaterFilter)tile;
                int water = filter.countFlowers();
                if (water < 5) {
                    probeInfo.text("Not enough water in vicinity");
                    probeInfo.progress(water, 5);
                } else {
                    this.addProgressData(probeInfo, filter.cookTime, HarvestCraft.config.waterfilterTime);
                }
                return;
            }
            if (tile instanceof TileEntityPresser) {
                this.addProgressData(probeInfo, ((TileEntityPresser)tile).cookTime, 125);
                return;
            }
            if (tile instanceof TileEntityGrinder) {
                this.addProgressData(probeInfo, ((TileEntityGrinder)tile).cookTime, 125);
                return;
            }
        }
        if (ModIds.CHARM.isLoaded && tile instanceof svenhjol.charm.crafting.tile.TileComposter) {
            svenhjol.charm.crafting.tile.TileComposter composter = (svenhjol.charm.crafting.tile.TileComposter)tile;
            int level = (Integer)composter.getBlockState().func_177229_b((IProperty)BlockComposter.LEVEL);
            this.addProgressData(probeInfo, level, 8, -5937110, -7054043);
            return;
        }
        if (ModIds.FUTURE_MC.isLoaded) {
            if (tile instanceof TileComposter) {
                IBlockState state = world.func_180495_p(tile.func_174877_v());
                int level = (Integer)state.func_177229_b((IProperty)ComposterBlock.Companion.getLEVEL());
                this.addProgressData(probeInfo, level, 8, -5937110, -7054043);
                return;
            }
            if (tile instanceof BeeHiveTile) {
                BeeHiveTile hive = (BeeHiveTile)tile;
                this.addProgressData(probeInfo, hive.getHoneyLevel(), 5, -3569918, -4949759, "Honey progress");
                probeInfo.text("Bees inside: " + hive.getBeeCount());
                return;
            }
        }
    }

    public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer entityPlayer, World world, Entity entity, IProbeHitEntityData iProbeHitEntityData) {
        if (ModIds.MO_CREATURES.isLoaded && entity instanceof MoCEntityEgg) {
            if (moEggProgress != null) {
                try {
                    this.addProgressData(probeInfo, moEggProgress.getInt(entity), 30);
                }
                catch (IllegalAccessException e) {
                    Mia.LOGGER.error("Cannot access MoCEntityEgg progress counter, even though it was found");
                    e.printStackTrace();
                }
            }
            return;
        }
        if (ModIds.ICE_AND_FIRE.isLoaded) {
            if (entity instanceof EntityDragonEgg) {
                EntityDragonEgg egg = (EntityDragonEgg)entity;
                this.addProgressData(probeInfo, egg.getDragonAge(), IceAndFire.CONFIG.dragonEggTime);
                return;
            }
            if (entity instanceof EntityMyrmexEgg) {
                EntityMyrmexEgg egg = (EntityMyrmexEgg)entity;
                StringBuilder name = new StringBuilder(19);
                if (egg.isJungle()) {
                    name.append("Jungle ");
                } else {
                    name.append("Desert ");
                }
                switch (egg.getMyrmexCaste()) {
                    case 1: {
                        name.append(I18n.func_135052_a((String)"myrmex.caste_soldier.name", (Object[])new Object[0]));
                        break;
                    }
                    case 2: {
                        name.append(I18n.func_135052_a((String)"myrmex.caste_royal.name", (Object[])new Object[0]));
                        break;
                    }
                    case 3: {
                        name.append(I18n.func_135052_a((String)"myrmex.caste_sentinel.name", (Object[])new Object[0]));
                        break;
                    }
                    case 4: {
                        name.append(I18n.func_135052_a((String)"myrmex.caste_queen.name", (Object[])new Object[0]));
                        break;
                    }
                    default: {
                        name.append(I18n.func_135052_a((String)"myrmex.caste_worker.name", (Object[])new Object[0]));
                    }
                }
                name.append(" Egg");
                probeInfo.text(name.toString());
                this.addProgressData(probeInfo, egg.getMyrmexAge(), IceAndFire.CONFIG.myrmexEggTicks);
                return;
            }
        }
    }

    private void addProgressData(IProbeInfo probeInfo, int currentProgress, int maxProgress) {
        this.addProgressData(probeInfo, currentProgress, maxProgress, null, null, "Progress");
    }

    private void addProgressData(IProbeInfo probeInfo, int currentProgress, int maxProgress, @Nullable Integer hexColor, @Nullable Integer altHexColor) {
        this.addProgressData(probeInfo, currentProgress, maxProgress, hexColor, altHexColor, null);
    }

    private void addProgressData(IProbeInfo probeInfo, int currentProgress, int maxProgress, @Nullable String message) {
        this.addProgressData(probeInfo, currentProgress, maxProgress, null, null, message);
    }

    private void addProgressData(IProbeInfo probeInfo, int currentProgress, int maxProgress, @Nullable Integer hexColor, @Nullable Integer tintHexColor, @Nullable String message) {
        float progress = (float)currentProgress / (float)maxProgress * 100.0f;
        IProgressStyle progressStyle = probeInfo.defaultProgressStyle().suffix("%");
        if (hexColor != null) {
            progressStyle.filledColor(hexColor.intValue()).alternateFilledColor((tintHexColor != null ? tintHexColor : hexColor).intValue());
        } else if (tintHexColor != null) {
            progressStyle.filledColor(tintHexColor.intValue()).alternateFilledColor(tintHexColor.intValue());
        }
        if (message != null) {
            probeInfo.text(message);
        }
        probeInfo.progress((int)progress, 100, progressStyle);
    }

    private void addRfData(IProbeInfo probeInfo, int energy, int maxEnergy) {
        ProbeConfig config = Config.getDefaultConfig();
        if (config.getRFMode() == 1) {
            probeInfo.progress(energy, maxEnergy, probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
        } else {
            probeInfo.text(TextStyleClass.PROGRESS + "RF: " + ElementProgress.format((long)energy, (NumberFormat)Config.rfFormat, (String)"RF"));
        }
    }

    static {
        Field moEggField = null;
        Field iceFireDragonforgeInput = null;
        Method harvestApiaryMethod = null;
        Method harvestGroundTrapMethod = null;
        Method harvestWaterTrapMethod = null;
        Method iceFireDragonforgeBrick = null;
        if (ModIds.MO_CREATURES.isLoaded) {
            try {
                moEggField = MoCEntityEgg.class.getDeclaredField("tCounter");
                moEggField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Mia.LOGGER.error("Cannot access MoCEntityEgg tCounter field, no hatching progress will be displayed");
            }
        }
        if (ModIds.ICE_AND_FIRE.isLoaded) {
            try {
                iceFireDragonforgeInput = TileEntityDragonforgeInput.class.getDeclaredField("core");
                iceFireDragonforgeInput.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Mia.LOGGER.error("Cannot access TileEntityDragonforgeInput core field, no smelting progress will be displayed");
            }
            try {
                iceFireDragonforgeBrick = TileEntityDragonforgeBrick.class.getDeclaredMethod("getConnectedTileEntity", new Class[0]);
                iceFireDragonforgeBrick.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Mia.LOGGER.error("Cannot access TileEntityDragonforgeBrick getConnectedTileEntity() method, no smelting progress will be displayed");
            }
        }
        if (ModIds.HARVESTCRAFT.isLoaded) {
            try {
                harvestApiaryMethod = TileEntityApiary.class.getDeclaredMethod("getRunTime", new Class[0]);
                harvestApiaryMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Mia.LOGGER.error("Cannot access TileEntityApiary getRunTime() method, no progress will be displayed");
            }
            try {
                harvestGroundTrapMethod = TileEntityGroundTrap.class.getDeclaredMethod("getRunTime", new Class[0]);
                harvestGroundTrapMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Mia.LOGGER.error("Cannot access TileEntityGroundTrap getRunTime() method, no progress will be displayed");
            }
            try {
                harvestWaterTrapMethod = TileEntityWaterTrap.class.getDeclaredMethod("getRunTime", new Class[0]);
                harvestWaterTrapMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Mia.LOGGER.error("Cannot access TileEntityWaterTrap getRunTime() method, no progress will be displayed");
            }
        }
        moEggProgress = moEggField;
        iceFireDragonforgeInputCore = iceFireDragonforgeInput;
        harvestApiaryRunTime = harvestApiaryMethod;
        harvestGroundTrapRunTime = harvestGroundTrapMethod;
        harvestWaterTrapRunTime = harvestWaterTrapMethod;
        iceFireDragonforgeBrickCore = iceFireDragonforgeBrick;
    }
}

