/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.BrewerManager;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.TeConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.thermalexpansion.IThermalExpansionIntegration;
import com.github.sokyranthedragon.mia.integrations.thermalexpansion.QuarkTEIntegration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class ThermalExpansion
implements IBaseMod {
    private List<IThermalExpansionIntegration> modIntegrations = new LinkedList<IThermalExpansionIntegration>();

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (TeConfiguration.enableQuarkIntegration && ModIds.QUARK.isLoaded) {
            modIntegration.accept(ModIds.QUARK, new QuarkTEIntegration());
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!TeConfiguration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof IThermalExpansionIntegration) {
            this.modIntegrations.add((IThermalExpansionIntegration)integration);
            return;
        }
        Mia.LOGGER.warn("Incorrect Thermal Foundation integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (TeConfiguration.teAdditionsEnabled && !MiaConfig.disableAllRecipes) {
            int energy = 6000;
            ItemStack ingot = new ItemStack(Items.field_151042_j);
            SmelterManager.addRecycleRecipe((int)energy, (ItemStack)new ItemStack((Item)Items.field_151020_U), (ItemStack)ingot, (int)2);
            SmelterManager.addRecycleRecipe((int)energy, (ItemStack)new ItemStack((Item)Items.field_151023_V), (ItemStack)ingot, (int)4);
            SmelterManager.addRecycleRecipe((int)energy, (ItemStack)new ItemStack((Item)Items.field_151022_W), (ItemStack)ingot, (int)3);
            SmelterManager.addRecycleRecipe((int)energy, (ItemStack)new ItemStack((Item)Items.field_151029_X), (ItemStack)ingot, (int)2);
        }
        if (!this.modIntegrations.isEmpty() && !MiaConfig.disableAllRecipes) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"ThermalExpansion addRecipes", (int)this.modIntegrations.size());
            for (IThermalExpansionIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                integration.addRecipes();
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.modIntegrations.isEmpty() && !MiaConfig.disableAllRecipes) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"ThermalExpansion addPostInitRecipes", (int)this.modIntegrations.size());
            for (IThermalExpansionIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                integration.addPostInitRecipes();
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    public static void addBrewingRecipe(@Nonnull PotionType result, @Nullable PotionType previousLevel, @Nonnull ItemStack ingredient) {
        if (!ModIds.THERMAL_EXPANSION.isLoaded) {
            return;
        }
        if (previousLevel == null) {
            BrewerManager.addSwapPotionRecipes((PotionType)result);
        } else {
            BrewerManager.addDefaultPotionRecipes((PotionType)previousLevel, (ItemStack)ingredient, (PotionType)result);
        }
    }

    public static void addEnchantingRecipe(ItemStack input, @Nonnull String enchantment, int tier) {
        if (!ModIds.THERMAL_EXPANSION.isLoaded) {
            return;
        }
        EnchanterManager.addDefaultEnchantmentRecipe((ItemStack)input, (String)enchantment, (int)tier);
    }
}

