/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.MiaCreativeTab;
import com.github.sokyranthedragon.mia.capabilities.MusicPlayerCapabilityProvider;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.handlers.MusicPlayerStackHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemMusicPlayer
extends Item
implements IBauble {
    public ItemMusicPlayer() {
        this.func_77625_d(1);
        this.setRegistryName("mia", "music_player");
        this.func_77655_b("music_player");
        if (MiaConfig.miaCreativeTab) {
            this.func_77637_a(MiaCreativeTab.INSTANCE);
        } else {
            this.func_77637_a(CreativeTabs.field_78040_i);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new MusicPlayerCapabilityProvider();
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        MusicPlayerStackHandler capability;
        NBTTagCompound nbt = super.getNBTShareTag(stack);
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if ((capability = (MusicPlayerStackHandler)stack.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null)) != null) {
            nbt.func_74782_a("Capability", (NBTBase)capability.serializeNBT());
        }
        return nbt;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null && nbt.func_150297_b("Capability", 10)) {
            NBTTagCompound capabilityNbt = nbt.func_74775_l("Capability");
            nbt.func_82580_o("Capability");
            MusicPlayerStackHandler capability = (MusicPlayerStackHandler)stack.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
            if (capability != null) {
                capability.deserializeNBT(capabilityNbt);
            }
        }
        super.readNBTShareTag(stack, nbt);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        MusicPlayerStackHandler capability = (MusicPlayerStackHandler)item.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
        if ((hand == EnumHand.MAIN_HAND || player.func_184614_ca().func_190926_b()) && capability != null) {
            if (!world.field_72995_K) {
                player.openGui((Object)Mia.instance, 3, world, hand.ordinal(), 0, 0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)item);
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.TRINKET;
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
    }
}

