/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.util.IAccessoryInventory;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemRingKobold
extends Item
implements IBauble {
    public ItemRingKobold() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setRegistryName("mia", "kobold_ring");
        this.func_77655_b("ring_of_the_kobold");
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (!ModIds.BAUBLES.isLoaded && !ModIds.AETHER.isLoaded) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (!world.field_72995_K) {
            IAccessoryInventory accessoryInventory;
            boolean equipped = false;
            if (ModIds.BAUBLES.isLoaded) {
                IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
                for (int i = 0; i < baubles.getSlots(); ++i) {
                    if (!baubles.getStackInSlot(i).func_190926_b() || !baubles.isItemValidForSlot(i, player.func_184586_b(hand), (EntityLivingBase)player)) continue;
                    baubles.setStackInSlot(i, player.func_184586_b(hand).func_77946_l());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                    this.onEquipped(player.func_184586_b(hand), (EntityLivingBase)player);
                    equipped = true;
                    break;
                }
            }
            if (!equipped && ModIds.AETHER.isLoaded && (accessoryInventory = AetherAPI.getInstance().get(player).getAccessoryInventory()).setAccessorySlot(player.func_184586_b(hand))) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
                this.onEquipped(player.func_184586_b(hand), (EntityLivingBase)player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        float size = SizeUtils.getEntitySize(player);
        if (size > 0.5f) {
            SizeUtils.setEntitySize(player, Math.max(0.5f, size - 0.0025f));
        } else if (size < 0.5f) {
            SizeUtils.setEntitySize(player, Math.min(0.5f, size + 0.0025f));
        }
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return ModIds.BAUBLES.isLoaded || ModIds.AETHER.isLoaded;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.RARE;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
    }
}

