/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.network;

import com.github.sokyranthedragon.mia.capabilities.MusicPlayerCapabilityProvider;
import com.github.sokyranthedragon.mia.handlers.MusicPlayerStackHandler;
import com.github.sokyranthedragon.mia.utilities.InventoryUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncMusicPlayer
implements IMessage {
    private int slotType;
    private int slotInventory;
    private int slotMusicPlayer;
    public boolean repeat;
    public boolean autoplay;
    public boolean shuffle;
    @Nullable
    private UUID uuid = null;

    public MessageSyncMusicPlayer() {
    }

    public MessageSyncMusicPlayer(int slotType, int slotInventory, int slotMusicPlayer, boolean repeat, boolean autoplay, boolean shuffle) {
        this.slotType = slotType;
        this.slotInventory = slotInventory;
        this.slotMusicPlayer = slotMusicPlayer;
        this.repeat = repeat;
        this.autoplay = autoplay;
        this.shuffle = shuffle;
    }

    public MessageSyncMusicPlayer(int slotType, int slotInventory, int slotMusicPlayer, boolean repeat, boolean autoplay, boolean shuffle, @Nullable UUID uuid) {
        this(slotType, slotInventory, slotMusicPlayer, repeat, autoplay, shuffle);
        this.uuid = uuid;
    }

    public MessageSyncMusicPlayer(int slotType, int slotInventory, MusicPlayerStackHandler musicPlayer, boolean updateUuid) {
        this(slotType, slotInventory, musicPlayer.getCurrentSongSlot(), musicPlayer.repeat, musicPlayer.autoplay, musicPlayer.shuffle);
        if (updateUuid) {
            this.uuid = musicPlayer.itemUuid;
        }
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.slotType = ByteBufUtils.readVarInt((ByteBuf)byteBuf, (int)1);
        if (this.slotType > 1 && this.slotType != 4) {
            this.slotInventory = ByteBufUtils.readVarInt((ByteBuf)byteBuf, (int)1);
        }
        this.slotMusicPlayer = ByteBufUtils.readVarInt((ByteBuf)byteBuf, (int)5);
        byte data = byteBuf.readByte();
        this.repeat = (data & 1) != 0;
        this.autoplay = (data & 2) != 0;
        boolean bl = this.shuffle = (data & 4) != 0;
        if ((data & 8) != 0) {
            this.uuid = new UUID(byteBuf.readLong(), byteBuf.readLong());
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        ByteBufUtils.writeVarInt((ByteBuf)byteBuf, (int)this.slotType, (int)1);
        if (this.slotType > 1 && this.slotType != 4) {
            ByteBufUtils.writeVarInt((ByteBuf)byteBuf, (int)this.slotInventory, (int)1);
        }
        ByteBufUtils.writeVarInt((ByteBuf)byteBuf, (int)this.slotMusicPlayer, (int)5);
        byte data = 0;
        if (this.repeat) {
            data = (byte)(data | 1);
        }
        if (this.autoplay) {
            data = (byte)(data | 2);
        }
        if (this.shuffle) {
            data = (byte)(data | 4);
        }
        if (this.uuid != null) {
            data = (byte)(data | 0x1000);
            byteBuf.writeByte((int)data);
            byteBuf.writeLong(this.uuid.getMostSignificantBits());
            byteBuf.writeLong(this.uuid.getLeastSignificantBits());
        } else {
            byteBuf.writeByte((int)data);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSyncMusicPlayer, IMessage> {
        public IMessage onMessage(MessageSyncMusicPlayer message, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ItemStack item = InventoryUtils.getItemFromPlayer((EntityPlayer)player, message.slotType, message.slotInventory);
                MusicPlayerStackHandler capability = (MusicPlayerStackHandler)item.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
                if (capability != null) {
                    capability.setCurrentSongSlot(message.slotMusicPlayer);
                    capability.repeat = message.repeat;
                    capability.autoplay = message.autoplay;
                    capability.shuffle = message.shuffle;
                    if (message.uuid != null) {
                        capability.itemUuid = message.uuid;
                    }
                }
            });
            return null;
        }
    }
}

