/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.potions;

import com.github.sokyranthedragon.mia.core.MiaItems;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.potions.BasePotion;
import com.github.sokyranthedragon.mia.potions.ModPotions;
import com.github.sokyranthedragon.mia.utilities.BaublesUtils;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

public class SizeStabilizationPotion
extends BasePotion {
    public SizeStabilizationPotion() {
        super(false, 0xE1E1E1);
        this.setRegistryName(new ResourceLocation("mia", "size_stabilization"));
        this.func_76390_b("effect.size_stabilization");
        this.setEffectIcon(new ResourceLocation("mia", "textures/gui/mia/size_neutral.png"));
    }

    @ParametersAreNonnullByDefault
    public void func_76394_a(EntityLivingBase entityLivingBaseIn, int amplifier) {
        float size = SizeUtils.getEntitySize(entityLivingBaseIn);
        float targetSize = 1.0f;
        if (ModIds.BAUBLES.isLoaded && entityLivingBaseIn instanceof EntityPlayer && BaublesUtils.isBaubleActiveAFO((EntityPlayer)entityLivingBaseIn, MiaItems.koboldRing)) {
            targetSize = 0.5f;
        }
        if (size > targetSize) {
            SizeUtils.setEntitySize(entityLivingBaseIn, Math.max(targetSize, size - (float)(amplifier + 1) * 0.0025f));
        } else if (size < targetSize) {
            SizeUtils.setEntitySize(entityLivingBaseIn, Math.min(targetSize, size + (float)(amplifier + 1) * 0.0025f));
        } else {
            PotionEffect effect = entityLivingBaseIn.func_70660_b(ModPotions.sizeStabilizationPotion);
            if (effect == null || effect.func_76459_b() > 100) {
                entityLivingBaseIn.func_184589_d(ModPotions.sizeStabilizationPotion);
                entityLivingBaseIn.func_70690_d(new PotionEffect(ModPotions.sizeStabilizationPotion, 100));
            }
        }
    }
}

