/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.tile;

import com.gendeathrow.hatchery.core.init.ModItems;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.tile.TileBaseInventory;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEggSorter
extends TileBaseInventory
implements ITickable {
    private static final int[] slots = IntStream.rangeClosed(0, 8).toArray();
    private String eggEntityId = null;

    public TileEggSorter() {
        super(slots.length);
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return slots;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return index >= 6;
    }

    public int func_70302_i_() {
        return slots.length;
    }

    @Override
    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        if (this.func_191420_l()) {
            this.eggEntityId = null;
        }
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack stack = super.func_70304_b(index);
        if (this.func_191420_l()) {
            this.eggEntityId = null;
        }
        return stack;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        ItemStack inventoryStack = (ItemStack)this.stacks.get(index);
        boolean areItemStacksEqual = !stack.func_190926_b() && stack.func_77969_a(inventoryStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)inventoryStack);
        this.stacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (this.eggEntityId == null && !stack.func_190926_b()) {
            this.eggEntityId = stack.func_77978_p().func_74775_l("storedEntity").func_74779_i("Type");
        } else if (this.eggEntityId != null && stack.func_190926_b() && this.func_191420_l()) {
            this.eggEntityId = null;
        }
        if (index <= 2 && !areItemStacksEqual) {
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (index > 2) {
            return false;
        }
        if (!TileEggSorter.isItemValid(stack)) {
            return false;
        }
        if (this.eggEntityId != null && !stack.func_77978_p().func_74775_l("storedEntity").func_74779_i("Type").equals(this.eggEntityId)) {
            return false;
        }
        ItemStack egg = (ItemStack)this.stacks.get(index);
        return egg.func_190926_b() || egg.func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)egg, (ItemStack)stack);
    }

    public static boolean isItemValid(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.hatcheryEgg) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("storedEntity")) {
            return false;
        }
        if (!(nbt = nbt.func_74775_l("storedEntity")).func_74764_b("Growth")) {
            return false;
        }
        if (!nbt.func_74764_b("Gain")) {
            return false;
        }
        if (!nbt.func_74764_b("Strength")) {
            return false;
        }
        return nbt.func_74764_b("Type");
    }

    public void func_73660_a() {
        boolean[] isDirty = new boolean[]{false};
        for (int i = 0; i < 3 && !this.processEgg(i, isDirty); ++i) {
        }
        if (isDirty[0]) {
            this.func_70296_d();
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return "tile.egg_sorter.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.stacks);
        for (ItemStack egg : this.stacks) {
            if (egg == ItemStack.field_190927_a) continue;
            this.eggEntityId = egg.func_77978_p().func_74775_l("storedEntity").func_74779_i("Type");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.stacks);
        return nbt;
    }

    @Override
    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.egg_sorter.name", new Object[0]);
    }

    private boolean processEgg(int eggIndex, boolean[] isDirty) {
        return this.processEgg(eggIndex, isDirty, 0);
    }

    private boolean processEgg(int eggIndex, boolean[] isDirty, int depth) {
        NBTTagCompound inventoryNbt;
        int k;
        ItemStack stack = (ItemStack)this.stacks.get(eggIndex);
        if (depth > 10) {
            Mia.LOGGER.warn("Recursive call in egg sorter reached maximum depth, sorting stopped. This shouldn't happen. Please report this to mod developer.");
            isDirty[0] = true;
            this.stacks.set(eggIndex, (Object)ItemStack.field_190927_a);
            if (((ItemStack)this.stacks.get(6)).func_190926_b()) {
                this.stacks.set(6, (Object)stack);
            } else if (((ItemStack)this.stacks.get(7)).func_190926_b()) {
                this.stacks.set(7, (Object)stack);
            } else if (((ItemStack)this.stacks.get(8)).func_190926_b()) {
                this.stacks.set(8, (Object)stack);
            }
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        if (!(((ItemStack)this.stacks.get(6)).func_190926_b() || ((ItemStack)this.stacks.get(7)).func_190926_b() || ((ItemStack)this.stacks.get(8)).func_190926_b())) {
            return true;
        }
        NBTTagCompound nbt = stack.func_77978_p().func_74775_l("storedEntity");
        int growth = nbt.func_74762_e("Growth");
        int gain = nbt.func_74762_e("Gain");
        int strength = nbt.func_74762_e("Strength");
        int slotMatch = 0;
        int improvement = 0;
        int improvementTotal = 0;
        for (k = 3; k < 6; ++k) {
            int tempImprovement;
            int total;
            ItemStack inventoryStack = (ItemStack)this.stacks.get(k);
            if (inventoryStack.func_190926_b()) {
                if (slotMatch != 0) continue;
                slotMatch = k;
                continue;
            }
            inventoryNbt = inventoryStack.func_77978_p().func_74775_l("storedEntity");
            int inventoryGrowth = inventoryNbt.func_74762_e("Growth");
            int inventoryGain = inventoryNbt.func_74762_e("Gain");
            int inventoryStrength = inventoryNbt.func_74762_e("Strength");
            if (stack.func_77969_a(inventoryStack) && growth == inventoryGrowth && gain == inventoryGain && strength == inventoryStrength && inventoryStack.func_190916_E() < this.func_70297_j_()) {
                total = stack.func_190916_E() + inventoryStack.func_190916_E();
                if (total <= this.func_70297_j_()) {
                    inventoryStack.func_190920_e(total);
                    stack = ItemStack.field_190927_a;
                    this.stacks.set(eggIndex, (Object)ItemStack.field_190927_a);
                    isDirty[0] = true;
                    break;
                }
                inventoryStack.func_190920_e(this.func_70297_j_());
                stack.func_190920_e(total - this.func_70297_j_());
                continue;
            }
            total = growth + gain + strength;
            int inventoryTotal = inventoryGrowth + inventoryGain + inventoryStrength;
            int tempImprovementTotal = total - inventoryTotal;
            switch (k) {
                default: {
                    tempImprovement = growth - inventoryGrowth;
                    break;
                }
                case 4: {
                    tempImprovement = gain - inventoryGain;
                    break;
                }
                case 5: {
                    tempImprovement = strength - inventoryStrength;
                }
            }
            if (tempImprovement > improvement) {
                improvement = tempImprovement;
                improvementTotal = tempImprovementTotal;
                slotMatch = k;
                continue;
            }
            if (tempImprovement != improvement || tempImprovementTotal <= improvementTotal) continue;
            improvementTotal = tempImprovementTotal;
            slotMatch = k;
        }
        if (slotMatch != 0 && !stack.func_190926_b()) {
            this.stacks.set(eggIndex, this.stacks.get(slotMatch));
            this.stacks.set(slotMatch, (Object)stack);
            this.processEgg(eggIndex, isDirty, ++depth);
            isDirty[0] = true;
        } else if (stack.func_190926_b()) {
            this.stacks.set(eggIndex, (Object)ItemStack.field_190927_a);
            isDirty[0] = true;
        } else {
            for (k = 6; k < 9; ++k) {
                int maxSize;
                ItemStack outputStack = (ItemStack)this.stacks.get(k);
                if (outputStack.func_190926_b()) {
                    this.stacks.set(k, (Object)stack);
                    this.stacks.set(eggIndex, (Object)ItemStack.field_190927_a);
                    isDirty[0] = true;
                    break;
                }
                inventoryNbt = outputStack.func_77978_p().func_74775_l("storedEntity");
                int outputGrowth = inventoryNbt.func_74762_e("Growth");
                int outputGain = inventoryNbt.func_74762_e("Gain");
                int outputStrength = inventoryNbt.func_74762_e("Strength");
                if (!outputStack.func_77969_a(stack) || growth != outputGrowth || gain != outputGain || strength != outputStrength || (maxSize = 64 - outputStack.func_190916_E()) <= 0) continue;
                ItemStack split = stack.func_77979_a(maxSize);
                outputStack.func_190920_e(outputStack.func_190916_E() + split.func_190916_E());
                if (!stack.func_190926_b()) continue;
                this.stacks.set(eggIndex, (Object)ItemStack.field_190927_a);
                isDirty[0] = true;
                break;
            }
        }
        return false;
    }
}

