/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.tile;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.sokyranthedragon.mia.integrations.theoneprobe.ITileProbeProgress;
import com.github.sokyranthedragon.mia.tile.TileBaseInventory;
import com.github.sokyranthedragon.mia.utilities.ExtraUtilitiesUtils;
import com.github.sokyranthedragon.mia.utilities.HatcheryUtils;
import com.github.sokyranthedragon.mia.utilities.ThermalExpansionUtils;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TilePixieDustExtractor
extends TileBaseInventory
implements ITickable,
ITileProbeProgress {
    private static final int[] slots = IntStream.rangeClosed(0, 10).toArray();
    public int dustProgress = 0;
    public int pixiesTotal = 0;

    public TilePixieDustExtractor() {
        super(slots.length);
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return slots;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return index < 10 && this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return index == 10;
    }

    public int func_70302_i_() {
        return slots.length;
    }

    @Override
    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        this.updatePixieTotal();
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack stack = super.func_70304_b(index);
        this.updatePixieTotal();
        return stack;
    }

    @Override
    public int func_174887_a_(int id) {
        return id == 0 ? this.dustProgress : 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.dustProgress = value;
        }
    }

    @Override
    public int func_174890_g() {
        return 1;
    }

    protected void updatePixieTotal() {
        this.pixiesTotal = 0;
        for (int i = 0; i < this.func_70302_i_() - 1; ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            ++this.pixiesTotal;
        }
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.updatePixieTotal();
        if (index <= 9) {
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (index >= 10) {
            return false;
        }
        if (!((ItemStack)this.stacks.get(index)).func_190926_b()) {
            return false;
        }
        return TilePixieDustExtractor.isItemValid(stack);
    }

    public static boolean isItemValid(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() == Item.func_150898_a((Block)IafBlockRegistry.jar_pixie)) {
            return true;
        }
        return ThermalExpansionUtils.isItemStackMorbWithMob(stack, "iceandfire:if_pixie") || HatcheryUtils.isItemAnimalNetWithMob(stack, "iceandfire:if_pixie") || ExtraUtilitiesUtils.isItemLassoWithMob(stack, "iceandfire:if_pixie");
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.dustProgress = compound.func_74762_e("DustProgress");
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, (NonNullList)this.stacks);
        super.func_145839_a(compound);
        this.updatePixieTotal();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("DustProgress", this.dustProgress);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, (NonNullList)this.stacks);
        return compound;
    }

    public void func_73660_a() {
        if (this.pixiesTotal == 0) {
            this.dustProgress = 0;
            return;
        }
        ItemStack dust = (ItemStack)this.stacks.get(10);
        if (dust.func_190926_b() || dust.func_190916_E() < dust.func_77976_d()) {
            this.dustProgress += this.pixiesTotal;
            while (this.dustProgress >= 24000) {
                this.dustProgress -= 24000;
                if (dust.func_190926_b()) {
                    this.stacks.set(10, (Object)new ItemStack(IafItemRegistry.pixie_dust));
                } else {
                    dust.func_190920_e(dust.func_190916_E() + 1);
                }
                this.func_70296_d();
            }
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return "tile.pixie_dust_extractor.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.pixie_dust_extractor.name", new Object[0]);
    }

    @Override
    public int getProgress() {
        return this.dustProgress;
    }

    @Override
    public int getProgressMax() {
        return 24000;
    }

    @Override
    public Integer getProgressHexColor() {
        return -231982;
    }

    @Override
    public Integer getProgressTintHexColor() {
        return -1939011;
    }
}

