/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.utilities;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.gildedgames.the_aether.api.AetherAPI;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.meteor.extrabotany.common.item.ModItems;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.common.item.ItemBaubleBox;

@ParametersAreNonnullByDefault
public class BaublesUtils {
    private BaublesUtils() {
    }

    public static boolean isBaubleActiveAFO(EntityPlayer player, @Nullable Item item) {
        if (item == null) {
            return false;
        }
        if (ModIds.BAUBLES.isLoaded && (ModIds.EXTRABOTANY.isLoaded && ModIds.BOTANIA.isLoaded ? BaublesUtils.baublesCheck(player, item) : BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)item) >= 0)) {
            return true;
        }
        return ModIds.AETHER.isLoaded && !BaublesUtils.getAetherStack(player, item).func_190926_b();
    }

    public static boolean baublesCheck(EntityPlayer player, Item item) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        int maxSize = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (handler.getStackInSlot(slot).func_190926_b()) continue;
            Item temp = handler.getStackInSlot(slot).func_77973_b();
            if (temp == item) {
                return true;
            }
            if (temp == ModItems.allforone) {
                maxSize = Integer.MAX_VALUE;
                continue;
            }
            if (temp != ModItems.elvenking) continue;
            maxSize = Math.max(3, maxSize);
        }
        if (maxSize == 0) {
            return false;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack box = player.field_71071_by.func_70301_a(i);
            if (!(box.func_77973_b() instanceof ItemBaubleBox) || !player.field_71071_by.func_70431_c(box)) continue;
            IItemHandler newInv = (IItemHandler)box.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (newInv == null) {
                return false;
            }
            maxSize = Math.min(maxSize, newInv.getSlots());
            for (int slot = 0; slot < maxSize; ++slot) {
                if (newInv.getStackInSlot(slot).func_77973_b() != item) continue;
                return true;
            }
            break;
        }
        return false;
    }

    public static ItemStack getAetherStack(EntityPlayer player, Item item) {
        for (ItemStack accessory : AetherAPI.getInstance().get(player).getAccessoryInventory().getAccessories()) {
            if (accessory.func_77973_b() != item) continue;
            return accessory;
        }
        return ItemStack.field_190927_a;
    }
}

