/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.utilities;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.util.IAccessoryInventory;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.google.common.collect.ImmutableSet;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutableTriple;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class InventoryUtils {
    public static void dropInventoryItems(World worldIn, BlockPos pos, IInventory inventory) {
        InventoryUtils.dropInventoryItems(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), inventory);
    }

    public static void dropInventoryItems(World worldIn, Entity entityAt, IInventory inventory) {
        InventoryUtils.dropInventoryItems(worldIn, entityAt.field_70165_t, entityAt.field_70163_u, entityAt.field_70161_v, inventory);
    }

    private static void dropInventoryItems(World worldIn, double x, double y, double z, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            while (!itemstack.func_190926_b()) {
                ItemStack dropStack = itemstack.func_77979_a(itemstack.func_77976_d());
                if (dropStack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)worldIn, (double)x, (double)y, (double)z, (ItemStack)itemstack);
            }
        }
    }

    public static ImmutableTriple<ItemStack, Integer, Integer> findItemInInventory(EntityPlayer player, Item targetItem) {
        ItemStack item = ItemStack.field_190927_a;
        int type = 0;
        int slot = -1;
        if (ModIds.BAUBLES.isLoaded && (slot = BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)targetItem)) >= 0) {
            item = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
            type = 3;
        }
        if (ModIds.AETHER.isLoaded && item.func_190926_b()) {
            IAccessoryInventory accessoryInventory = AetherAPI.getInstance().get(player).getAccessoryInventory();
            NonNullList accessories = accessoryInventory.getAccessories();
            for (slot = 0; slot < accessories.size(); ++slot) {
                ItemStack accessory = (ItemStack)accessories.get(slot);
                if (accessory.func_77973_b() != targetItem) continue;
                item = accessory;
                type = 5;
            }
        }
        if (item.func_190926_b()) {
            if (player.func_184614_ca().func_77973_b() == targetItem) {
                item = player.func_184614_ca();
                type = 0;
            } else if (player.func_184592_cb().func_77973_b() == targetItem) {
                item = player.func_184592_cb();
                type = 1;
            } else {
                NonNullList inventory = player.field_71071_by.field_70462_a;
                int inventorySize = inventory.size();
                for (int i = 0; i < inventorySize; ++i) {
                    ItemStack inventoryItem = (ItemStack)inventory.get(i);
                    if (inventoryItem.func_77973_b() != targetItem) continue;
                    item = inventoryItem;
                    type = 2;
                    slot = i;
                    break;
                }
            }
        }
        return new ImmutableTriple((Object)item, (Object)type, (Object)slot);
    }

    public static ImmutableSet<ItemStack> getAllItemsOfType(EntityPlayer player, Item targetItem) {
        ImmutableSet.Builder set = ImmutableSet.builder();
        if (ModIds.BAUBLES.isLoaded) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stack = baubles.getStackInSlot(i);
                if (stack.func_77973_b() != targetItem) continue;
                set.add((Object)stack);
            }
        }
        if (ModIds.AETHER.isLoaded) {
            for (ItemStack accessory : AetherAPI.getInstance().get(player).getAccessoryInventory().getAccessories()) {
                if (accessory.func_77973_b() != targetItem) continue;
                set.add((Object)accessory);
            }
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != targetItem) continue;
            set.add((Object)stack);
        }
        if (player.func_184592_cb().func_77973_b() == targetItem) {
            set.add((Object)player.func_184592_cb());
        }
        return set.build();
    }

    public static ItemStack getItemFromPlayer(EntityPlayer player, int type, int slot) {
        ItemStack itemStack = ItemStack.field_190927_a;
        switch (type) {
            case 0: {
                itemStack = player.func_184614_ca();
                break;
            }
            case 1: {
                itemStack = player.func_184592_cb();
                break;
            }
            case 2: {
                itemStack = player.field_71071_by.func_70301_a(slot);
                break;
            }
            case 3: {
                if (!ModIds.BAUBLES.isLoaded) break;
                itemStack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                break;
            }
            case 4: {
                itemStack = player.field_71071_by.func_70445_o();
                break;
            }
            case 5: {
                if (!ModIds.AETHER.isLoaded) break;
                itemStack = AetherAPI.getInstance().get(player).getAccessoryInventory().func_70301_a(slot);
            }
        }
        return itemStack;
    }
}

