/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.utilities;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemStackUtils {
    private ItemStackUtils() {
    }

    public static Optional<ItemStack> getStack(String id, String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id + ":" + name));
        return item != null ? Optional.of(new ItemStack(item, amount, meta)) : Optional.empty();
    }

    public static Optional<ItemStack> getStack(ModIds id, String name, int amount, int meta) {
        return ItemStackUtils.getStack(id.modId, name, amount, meta);
    }

    public static Optional<ItemStack> getStack(ModIds id, String name, int amount) {
        return ItemStackUtils.getStack(id, name, amount, 0);
    }

    public static Optional<ItemStack> getStack(ModIds id, String name) {
        return ItemStackUtils.getStack(id, name, 1);
    }

    public static boolean areItemStackEqualIgnoreCount(ItemStack first, ItemStack second) {
        if (first.func_190926_b() && second.func_190926_b()) {
            return true;
        }
        if (first.func_190926_b() || second.func_190926_b()) {
            return false;
        }
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        if (first.func_77952_i() != second.func_77952_i()) {
            return false;
        }
        NBTTagCompound tagFirst = first.func_77978_p();
        NBTTagCompound tagSecond = second.func_77978_p();
        if (tagFirst == null && tagSecond != null) {
            return false;
        }
        return (tagFirst == null || tagFirst.equals((Object)tagSecond)) && first.areCapsCompatible(second);
    }
}

