/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.utilities;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;

public class LootUtils {
    private LootUtils() {
    }

    public static void addDtLoot(LootPool loot, Block block, LootFunction ... functions) {
        LootUtils.addDtLoot(loot, Item.func_150898_a((Block)block), 5, functions);
    }

    public static void addDtLoot(LootPool loot, Block block, String entryName, LootFunction ... functions) {
        LootUtils.addDtLoot(loot, Item.func_150898_a((Block)block), entryName, 5, functions);
    }

    public static void addDtLoot(LootPool loot, Item item, LootFunction ... functions) {
        LootUtils.addDtLoot(loot, item, 5, functions);
    }

    public static void addDtLoot(LootPool loot, Item item, String entryName, LootFunction ... functions) {
        LootUtils.addDtLoot(loot, item, entryName, 5, functions);
    }

    public static void addDtLoot(LootPool loot, Block block, int weight, LootFunction ... functions) {
        LootUtils.addDtLoot(loot, Item.func_150898_a((Block)block), weight, functions);
    }

    public static void addDtLoot(LootPool loot, Block block, String entryName, int weight, LootFunction ... functions) {
        LootUtils.addDtLoot(loot, Item.func_150898_a((Block)block), entryName, weight, functions);
    }

    public static void addDtLoot(LootPool loot, Item item, int weight, LootFunction ... functions) {
        LootUtils.addDtLoot(loot, item, "", weight, functions);
    }

    public static void addDtLoot(LootPool loot, Item item, String entryName, int weight, LootFunction ... functions) {
        loot.addEntry((LootEntry)new LootEntryItem(item, weight, 0, functions, new LootCondition[0], item.func_77658_a() + entryName));
    }

    public static LootFunction[] getDtToolFunctions() {
        return new LootFunction[]{LootUtils.setDamageFunction(0.5f, 1.0f), LootUtils.enchantWithLevelsFunction(0.2f, 30, true)};
    }

    public static LootFunction setDamageFunction(float count) {
        return LootUtils.setDamageFunction(count, count);
    }

    public static LootFunction setDamageFunction(float min, float max) {
        return new SetDamage(new LootCondition[0], new RandomValueRange(min, max));
    }

    public static LootFunction enchantWithLevelsFunction(float chance, int level, boolean isTreasure) {
        return LootUtils.enchantWithLevelsFunction(chance, level, level, isTreasure);
    }

    public static LootFunction enchantWithLevelsFunction(float chance, int minLevel, int maxLevel, boolean isTreasure) {
        return new EnchantWithLevels(new LootCondition[]{new RandomChance(chance)}, new RandomValueRange((float)minLevel, (float)maxLevel), isTreasure);
    }

    public static LootFunction setMetadataFunction(int value) {
        return LootUtils.setMetadataFunction(value, value);
    }

    public static LootFunction setMetadataFunction(int min, int max) {
        return new SetMetadata(new LootCondition[0], new RandomValueRange((float)min, (float)max));
    }

    public static LootFunction setCountFunction(int count) {
        return LootUtils.setCountFunction(count, count);
    }

    public static LootFunction setCountFunction(int min, int max) {
        return new SetCount(new LootCondition[0], new RandomValueRange((float)min, (float)max));
    }
}

