/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.utilities;

import com.github.sokyranthedragon.mia.MiaCreativeTab;
import com.github.sokyranthedragon.mia.block.IMetaBlock;
import com.github.sokyranthedragon.mia.block.base.BlockBaseDoor;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.core.MiaItems;
import com.github.sokyranthedragon.mia.items.itemblocks.ItemBlockDoor;
import com.github.sokyranthedragon.mia.items.itemblocks.ItemBlockMeta;
import com.github.sokyranthedragon.mia.items.itemblocks.ItemSlabMeta;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@ParametersAreNullableByDefault
public class RegisterUtils {
    private RegisterUtils() {
    }

    public static void registerItemblockSlab(BlockSlab singleSlab, BlockSlab doubleSlab, @Nonnull IForgeRegistry<Item> registry) {
        if (singleSlab != null && doubleSlab != null && singleSlab.getRegistryName() != null) {
            if (singleSlab instanceof IMetaBlock) {
                registry.register(new ItemSlabMeta((Block)((IMetaBlock)singleSlab), singleSlab, doubleSlab).setRegistryName(singleSlab.getRegistryName()));
            } else {
                registry.register(new ItemSlab((Block)singleSlab, singleSlab, doubleSlab).setRegistryName(singleSlab.getRegistryName()));
            }
        }
    }

    public static void registerItemblock(Block block, @Nonnull IForgeRegistry<Item> registry) {
        if (block != null && block.getRegistryName() != null) {
            if (block instanceof BlockBaseDoor) {
                Item item = ((Item)new ItemBlockDoor(block).setRegistryName(block.getRegistryName())).func_77655_b(block.func_149739_a().substring("tile.".length()));
                if (MiaConfig.miaCreativeTab) {
                    item.func_77637_a((CreativeTabs)MiaCreativeTab.INSTANCE);
                } else {
                    item.func_77637_a(block.func_149708_J());
                }
                ((BlockBaseDoor)block).setDoorsItem(item);
                MiaItems.registerItem(item, registry);
            } else if (block instanceof IMetaBlock) {
                registry.register(new ItemBlockMeta((Block)((IMetaBlock)block)).setRegistryName(block.getRegistryName()));
            } else {
                registry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemblockRenderer(Block block) {
        if (block instanceof BlockBaseDoor) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
            RegisterUtils.registerItemRenderer(((BlockBaseDoor)block).getDoorsItem());
        } else if (block instanceof IMetaBlock) {
            for (int i = 0; i <= ((IMetaBlock)block).getMaxMeta(); ++i) {
                RegisterUtils.registerItemblockRenderer(block, i);
            }
        } else {
            RegisterUtils.registerItemblockRenderer(block, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemblockRenderer(Block block, int metadata) {
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            RegisterUtils.registerItemRenderer(item, metadata);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenderer(Item item) {
        RegisterUtils.registerItemRenderer(item, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenderer(Item item, int metadata) {
        ResourceLocation registryName;
        if (item != null && item != Items.field_190931_a && (registryName = item.getRegistryName()) != null) {
            if (item instanceof IMetaBlock) {
                String defaultVariant = ((IMetaBlock)item).getDefaultVariantValue();
                if (defaultVariant != null) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(registryName, defaultVariant));
                } else {
                    String variantName = ((IMetaBlock)item).getVariantName();
                    String variantValue = ((IMetaBlock)item).getNameFromMeta(metadata);
                    if (variantName == null) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(registryName + "_" + variantValue, "inventory"));
                    } else {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(registryName, variantName + "=" + variantValue));
                    }
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(registryName, "inventory"));
            }
        }
    }
}

