/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.utilities.size;

import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.enchantments.EnchantmentKobold;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.FakePlayer;

public class SizeUtils {
    public static UUID uuidHeight = UUID.fromString("5440b01a-974f-4495-bb9a-c7c87424bca4");
    public static UUID uuidWidth = UUID.fromString("3949d2ed-b6cc-4330-9c13-98777f48ea51");
    public static UUID uuidReach1 = UUID.fromString("854e0004-c218-406c-a9e2-590f1846d80b");
    public static UUID uuidReach2 = UUID.fromString("216080dc-22d3-4eff-a730-190ec0210d5c");
    public static UUID uuidHealth = UUID.fromString("3b901d47-2d30-495c-be45-f0091c0f6fb2");
    public static UUID uuidStrength = UUID.fromString("558f55be-b277-4091-ae9b-056c7bc96e84");
    public static UUID uuidSpeed = UUID.fromString("f2fb5cda-3fbe-4509-a0af-4fc994e6aeca");
    public static UUID uuidSwimSpeed = UUID.fromString("d88a6e6c-faa9-4337-bb7d-73451500f78f");
    public static boolean isSizeComponentEnabled = false;

    private SizeUtils() {
    }

    public static float getEntitySize(EntityLivingBase entity) {
        AttributeModifier height;
        if (entity instanceof FakePlayer) {
            return 1.0f;
        }
        AbstractAttributeMap entityAttributes = entity.func_110140_aT();
        float size = 1.0f;
        IAttributeInstance heightAttribute = entityAttributes.func_111152_a(ArtemisLibAttributes.ENTITY_HEIGHT.func_111108_a());
        if (heightAttribute != null && (height = heightAttribute.func_111127_a(uuidHeight)) != null) {
            size = (float)height.func_111164_d() + 1.0f;
        }
        return size;
    }

    public static void changeEntitySizeBy(EntityLivingBase entity, float changeValue) {
        SizeUtils.setEntitySize(entity, SizeUtils.getEntitySize(entity) + changeValue);
    }

    public static void setEntitySize(EntityLivingBase entity, float size) {
        SizeUtils.setEntitySize(entity, size, false);
    }

    public static void setEntitySize(EntityLivingBase entity, float size, boolean ignoreSizeMatch) {
        float maxSize;
        if (!isSizeComponentEnabled) {
            return;
        }
        if (entity instanceof FakePlayer) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            size = MathHelper.func_76131_a((float)size, (float)GenericAdditionsConfig.sizeModule.minPlayerSize, (float)GenericAdditionsConfig.sizeModule.maxPlayerSize);
            maxSize = GenericAdditionsConfig.sizeModule.maxPlayerSize;
        } else if (GenericAdditionsConfig.sizeModule.canScaleMobs && Arrays.stream(GenericAdditionsConfig.sizeModule.bannedEntitiesSize).noneMatch(x -> {
            ResourceLocation e = EntityList.func_191301_a((Entity)entity);
            return e == null || x.equals(e.toString());
        })) {
            size = MathHelper.func_76131_a((float)size, (float)GenericAdditionsConfig.sizeModule.minMobSize, (float)GenericAdditionsConfig.sizeModule.maxMobSize);
            maxSize = GenericAdditionsConfig.sizeModule.maxMobSize;
        } else {
            if (SizeUtils.getEntitySize(entity) == 1.0f) {
                return;
            }
            maxSize = 1.0f;
            size = 1.0f;
        }
        if (!ignoreSizeMatch && size == SizeUtils.getEntitySize(entity)) {
            return;
        }
        HashMultimap sharedAttributes = HashMultimap.create((int)5, (int)1);
        HashMultimap bigAttributes = HashMultimap.create();
        HashMultimap smallAttributes = HashMultimap.create();
        sharedAttributes.put((Object)ArtemisLibAttributes.ENTITY_HEIGHT.func_111108_a(), (Object)new AttributeModifier(uuidHeight, "Player Height", (double)(size - 1.0f), 2));
        sharedAttributes.put((Object)ArtemisLibAttributes.ENTITY_WIDTH.func_111108_a(), (Object)new AttributeModifier(uuidWidth, "Player Width", MathHelper.func_151237_a((double)(size - 1.0f), (double)-0.6, (double)maxSize), 2));
        if (size < 1.0f && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            size = EnchantmentKobold.getSizeModifier(player, size);
        }
        if (GenericAdditionsConfig.sizeModule.scaleMovementSpeed) {
            sharedAttributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuidSpeed, "Player Speed", (double)((size - 1.0f) / 2.0f), 2));
        }
        if (GenericAdditionsConfig.sizeModule.scaleStrength) {
            sharedAttributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuidStrength, "Player Strength", (double)(size - 1.0f), 0));
        }
        if (GenericAdditionsConfig.sizeModule.scaleMaxHealth) {
            sharedAttributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(uuidHealth, "Player Health", (double)Math.min(1024.0f, (size - 1.0f) * GenericAdditionsConfig.sizeModule.healthMultiplier), 2));
        }
        if (GenericAdditionsConfig.sizeModule.scaleSwimSpeed) {
            sharedAttributes.put((Object)EntityLivingBase.SWIM_SPEED.func_111108_a(), (Object)new AttributeModifier(uuidSwimSpeed, "Player Swim Speed", (double)((size - 1.0f) / 4.0f), 2));
        }
        if (GenericAdditionsConfig.sizeModule.scaleReachDistance && entity instanceof EntityPlayer) {
            bigAttributes.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuidReach1, "Player Reach 1", (double)(size - 1.0f), 2));
            smallAttributes.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuidReach2, "Player Reach 2", -MathHelper.func_151237_a((double)(size - 1.0f), (double)0.33, (double)Double.MAX_VALUE), 2));
            if (size > 1.0f) {
                entity.func_110140_aT().func_111147_b((Multimap)bigAttributes);
            } else {
                entity.func_110140_aT().func_111148_a((Multimap)bigAttributes);
            }
            if (size < 1.0f) {
                entity.func_110140_aT().func_111147_b((Multimap)smallAttributes);
            } else {
                entity.func_110140_aT().func_111148_a((Multimap)smallAttributes);
            }
        }
        float startingHealth = entity.func_110138_aP();
        entity.func_110140_aT().func_111147_b((Multimap)sharedAttributes);
        if (GenericAdditionsConfig.sizeModule.scaleCurrentHealthWhenGrowing && entity.func_110138_aP() > startingHealth) {
            float healthPercent = entity.func_110143_aJ() / startingHealth;
            entity.func_70606_j(Math.max(entity.func_110138_aP() * healthPercent, 0.5f));
        }
    }

    public static void validateEntitySize(EntityLivingBase entity) {
        SizeUtils.setEntitySize(entity, SizeUtils.getEntitySize(entity), true);
    }

    public static boolean canEntityBeScaled(EntityLivingBase entity) {
        if (entity instanceof FakePlayer) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            return true;
        }
        if (!GenericAdditionsConfig.sizeModule.canScaleMobs) {
            return false;
        }
        return Arrays.stream(GenericAdditionsConfig.sizeModule.bannedEntitiesSize).noneMatch(x -> {
            ResourceLocation e = EntityList.func_191301_a((Entity)entity);
            return e == null || x.equals(e.toString());
        });
    }
}

