/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.client.libs;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class CombinedLayeredColorMaskTexture
extends AbstractTexture {
    private final ResourceLocation location;
    private final ResourceLocation location2;
    private final int progression;
    private final int max;
    private boolean isPlayer;

    public CombinedLayeredColorMaskTexture(ResourceLocation location, ResourceLocation location2, int progression, int max, boolean isPlayer) {
        this.location = location;
        this.location2 = location2;
        this.progression = progression;
        this.max = max;
        this.isPlayer = isPlayer;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        Closeable iresource = null;
        BufferedImage bufferedimage1 = null;
        IResource iresource2 = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.location2);
        BufferedImage bufferedimage2 = TextureUtil.func_177053_a((InputStream)iresource2.func_110527_b());
        int i = bufferedimage1.getType();
        if (i == 0) {
            i = 6;
        }
        BufferedImage bufferedimage = new BufferedImage(bufferedimage1.getWidth(), bufferedimage1.getHeight(), i);
        for (int y = 0; y < bufferedimage1.getHeight(); ++y) {
            for (int x = 0; x < bufferedimage1.getWidth(); ++x) {
                int j1 = bufferedimage1.getRGB(x, y);
                if ((j1 & 0xFF000000) == 0) continue;
                int modelColor = bufferedimage1.getRGB(x, y);
                if (y <= this.progression * bufferedimage1.getWidth() / this.max) {
                    int material = bufferedimage2.getRGB(x % bufferedimage2.getWidth(), y % bufferedimage2.getHeight());
                    int model_red = (modelColor & 0xFF0000) >> 16;
                    int material_red = (material & 0xFF0000) >> 16;
                    int model_green = (modelColor & 0xFF00) >> 8;
                    int material_green = (material & 0xFF00) >> 8;
                    int model_blue = (modelColor & 0xFF) >> 0;
                    int material_blue = (material & 0xFF) >> 0;
                    double blackAndWhite = 0.3 * (double)model_red + 0.59 * (double)model_green + 0.11 * (double)model_blue;
                    blackAndWhite = 255.0 - (255.0 - blackAndWhite) / 1.0;
                    int bake_red = (int)((float)blackAndWhite * (float)material_red / 255.0f);
                    int bake_green = (int)((float)blackAndWhite * (float)material_green / 255.0f);
                    int bake_blue = (int)((float)blackAndWhite * (float)material_blue / 255.0f);
                    int bake_color = (modelColor & 0xFF000000 | bake_red << 16 | bake_green << 8 | bake_blue) & 0xFFFFFF;
                    bufferedimage.setRGB(x, y, 0xFF000000 | bake_color);
                    continue;
                }
                bufferedimage.setRGB(x, y, 0xFF000000 | modelColor);
            }
        }
        TextureUtil.func_110987_a((int)this.func_110552_b(), (BufferedImage)bufferedimage);
        if (iresource != null) {
            IOUtils.closeQuietly(iresource);
        }
        IOUtils.closeQuietly((Closeable)iresource2);
    }
}

