/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.client.libs;

import fr.wind_blade.isorropia.client.model.DynamicStaticModel;
import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.IsorropiaAPI;
import fr.wind_blade.isorropia.common.blocks.BlocksIS;
import fr.wind_blade.isorropia.common.capabilities.LivingBaseCapability;
import fr.wind_blade.isorropia.common.events.KeyHandler;
import fr.wind_blade.isorropia.common.items.misc.ItemLens;
import fr.wind_blade.isorropia.common.lenses.Lens;
import fr.wind_blade.isorropia.common.lenses.LensManager;
import fr.wind_blade.isorropia.common.network.LensChangeMessage;
import fr.wind_blade.isorropia.common.research.recipes.CurativeInfusionRecipe;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IRevealer;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.client.gui.GuiResearchPage;
import thaumcraft.client.lib.UtilsFX;

@SideOnly(value=Side.CLIENT)
public class RenderEventHandler {
    public static final ResourceLocation LIGO_TEX = new ResourceLocation("isorropia", "textures/misc/ligo.png");
    public static IBakedModel jar_soul = null;
    private static Lens theRightLens;
    private static final fociHUD fociLeft;
    private static Lens theLeftLens;
    private static float radialHudScale;
    private static final fociHUD fociRight;
    public static ResourceLocation TEX_VIS;
    public static ResourceLocation TEX_PAR;
    ResourceLocation tex4 = new ResourceLocation("thaumcraft", "textures/gui/paper.png");
    public static List<String> texts;
    public static Method tip;

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        ModelResourceLocation mrl = new ModelResourceLocation(BlocksIS.blockJarSoul.getRegistryName(), "inventory");
        jar_soul = (IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl);
        event.getModelRegistry().func_82595_a((Object)mrl, (Object)new DynamicStaticModel(jar_soul, Item.func_150898_a((Block)BlocksIS.blockJarSoul)));
    }

    @SubscribeEvent
    public static void onOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            fociRight.handleFociRadial(Minecraft.func_71410_x(), System.nanoTime() / 1000000L, (RenderGameOverlayEvent)event);
            fociLeft.handleFociRadial(Minecraft.func_71410_x(), System.nanoTime() / 1000000L, (RenderGameOverlayEvent)event);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            WorldClient worldClient = Minecraft.func_71410_x().field_71441_e;
            EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
            ItemStack revealer = LensManager.getRevealer((EntityPlayer)entityPlayerSP);
            if (!revealer.func_190926_b() && revealer.func_77942_o() && revealer.func_77978_p().func_74779_i("LeftLens") != null) {
                boolean doubleLens;
                theLeftLens = LensManager.getLens(revealer, LensManager.LENSSLOT.LEFT);
                theRightLens = LensManager.getLens(revealer, LensManager.LENSSLOT.RIGHT);
                boolean bl = doubleLens = theRightLens != null && ((Object)((Object)theRightLens)).equals((Object)theLeftLens);
                if (theLeftLens != null) {
                    theLeftLens.handleRenderGameOverlay((World)worldClient, (EntityPlayer)entityPlayerSP, event.getResolution(), doubleLens, event.getPartialTicks());
                }
                if (!doubleLens && theRightLens != null) {
                    theRightLens.handleRenderGameOverlay((World)worldClient, (EntityPlayer)entityPlayerSP, event.getResolution(), false, event.getPartialTicks());
                }
            }
            LivingBaseCapability cap = Common.getCap((EntityLivingBase)entityPlayerSP);
            if (cap.petrification > 0) {
                float flag = 1.0f - (100.0f - (float)cap.petrification) / 100.0f;
                float width = (float)event.getResolution().func_78327_c();
                float height = (float)event.getResolution().func_78324_d();
                float f2 = height / 34.0f;
                float f3 = width / 34.0f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179112_b((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)flag);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/blocks/cobblestone.png"));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181666_a(1.0f, 1.0f, 1.0f, 0.1f);
                buffer.func_181662_b(0.0, (double)f2, 1.0).func_187315_a(0.0, (double)height).func_181675_d();
                buffer.func_181662_b((double)f3, (double)f2, 1.0).func_187315_a((double)width, (double)height).func_181675_d();
                buffer.func_181662_b((double)f3, 0.0, 1.0).func_187315_a((double)width, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onDrawGui(GuiScreenEvent.DrawScreenEvent event) {
        GuiScreen screen = event.getGui();
        if (screen instanceof GuiResearchPage) {
            Field index = ReflectionHelper.findField(GuiResearchPage.class, (String[])new String[]{"recipePage"});
            Field recipes = ReflectionHelper.findField(GuiResearchPage.class, (String[])new String[]{"recipeLists"});
            Field shown = ReflectionHelper.findField(GuiResearchPage.class, (String[])new String[]{"shownRecipe"});
            try {
                Object recipe;
                int recipePage = (Integer)index.get(screen);
                LinkedHashMap maps = (LinkedHashMap)recipes.get(screen);
                ResourceLocation loc = (ResourceLocation)shown.get(screen);
                if (maps == null || loc == null) {
                    return;
                }
                List list = (List)maps.get(loc);
                if (list != null && !list.isEmpty() && (recipe = list.get(recipePage % list.size())) instanceof CurativeInfusionRecipe) {
                    RenderEventHandler.drawCurativeInfusionRecipe((CurativeInfusionRecipe)((Object)recipe), event);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onToolTip(ItemTooltipEvent event) {
        ArrayList tooltip = (ArrayList)event.getToolTip();
        ItemStack stack = event.getItemStack();
        if (stack.func_77942_o() && (stack.func_77973_b() instanceof IGoggles || stack.func_77973_b() instanceof IRevealer)) {
            String lens = stack.func_77978_p().func_74779_i(LensManager.LENSSLOT.LEFT.getName());
            if (!lens.isEmpty()) {
                tooltip.add(1, TextFormatting.YELLOW + I18n.func_135052_a((String)("lens." + ((Lens)IsorropiaAPI.lensRegistry.getValue(new ResourceLocation(lens))).getTranslationKey()), (Object[])new Object[0]));
            }
            if (!(lens = stack.func_77978_p().func_74779_i(LensManager.LENSSLOT.RIGHT.getName())).isEmpty()) {
                tooltip.add(1, TextFormatting.YELLOW + I18n.func_135052_a((String)("lens." + ((Lens)IsorropiaAPI.lensRegistry.getValue(new ResourceLocation(lens))).getTranslationKey()), (Object[])new Object[0]));
            }
        }
    }

    public static void drawCurativeInfusionRecipe(CurativeInfusionRecipe recipe, GuiScreenEvent.DrawScreenEvent event) {
        GuiScreen screen = event.getGui();
        int x = (screen.field_146294_l - 256) / 2 + 128;
        int y = (screen.field_146295_m - 256) / 2 + 128;
        if (recipe.getVis() > 0.0f) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String text = String.valueOf((int)recipe.getVis());
            int offset = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, x - offset / 2 + 70, y - 45, 0x505050);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEX_VIS);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            GL11.glTranslatef((float)x, (float)(y - 55), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            screen.func_73729_b(30, 0, 68, 76, 12, 12);
            GL11.glPopMatrix();
        }
        if (recipe.getCelestialAura() != 0) {
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(recipe.getCelestialBody().getTex());
            GL11.glTranslatef((float)(x + 56), (float)(y - 17), (float)0.0f);
            GL11.glScalef((float)0.12f, (float)0.12f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
            screen.func_73729_b(30, 0, 46, 45, 161, 162);
            GL11.glPopMatrix();
        }
        if (recipe.getFluxRejection() > 0.0f) {
            GuiResearchBrowser.drawForbidden((double)x, (double)(y - 70));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderLast(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack revealer = LensManager.getRevealer((EntityPlayer)player);
        if (!revealer.func_190926_b() && revealer.func_77942_o() && revealer.func_77978_p().func_74779_i("LeftLens") != null) {
            boolean doubleLens;
            theLeftLens = LensManager.getLens(revealer, LensManager.LENSSLOT.LEFT);
            theRightLens = LensManager.getLens(revealer, LensManager.LENSSLOT.RIGHT);
            boolean bl = doubleLens = theRightLens != null && ((Object)((Object)theRightLens)).equals((Object)theLeftLens);
            if (theLeftLens != null) {
                theLeftLens.handleRenderWorldLast(player.field_70170_p, (EntityPlayer)player, doubleLens, event.getPartialTicks());
            }
            if (!doubleLens && theRightLens != null) {
                theRightLens.handleRenderWorldLast(player.field_70170_p, (EntityPlayer)player, false, event.getPartialTicks());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderPlayerEvent(RenderHandEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void preRenderLiving(RenderLivingEvent.Pre<EntityLivingBase> event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void postRenderLiving(RenderLivingEvent.Post<EntityLivingBase> event) {
    }

    protected static float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    static {
        fociLeft = new fociHUD(LensManager.LENSSLOT.LEFT);
        fociRight = new fociHUD(LensManager.LENSSLOT.RIGHT);
        TEX_VIS = new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png");
        TEX_PAR = new ResourceLocation("thaumcraft", "textures/misc/particles.png");
        texts = Arrays.asList("wandtable.text1");
    }

    public static class fociHUD {
        private static final ResourceLocation radial = new ResourceLocation("thaumcraft", "textures/misc/radial.png");
        private static final ResourceLocation radial2 = new ResourceLocation("thaumcraft", "textures/misc/radial2.png");
        static final TreeMap<ResourceLocation, Integer> foci = new TreeMap();
        static final HashMap<ResourceLocation, ItemStack> lensStack = new HashMap();
        HashMap<ResourceLocation, Boolean> lensHover;
        HashMap<ResourceLocation, Float> fociScale = new HashMap();
        static final HashMap<ResourceLocation, Integer> lensSlot = new HashMap();
        final LensManager.LENSSLOT type;
        long lastTime;
        boolean lastState;

        public fociHUD(LensManager.LENSSLOT type) {
            this.lensHover = new HashMap();
            this.type = type;
            this.lastTime = 0L;
            this.lastState = false;
        }

        @SideOnly(value=Side.CLIENT)
        public void handleFociRadial(Minecraft mc, long time, RenderGameOverlayEvent event) {
            if (KeyHandler.radialActive || radialHudScale > 0.0f) {
                Object lens;
                if (KeyHandler.radialActive) {
                    if (mc.field_71462_r != null) {
                        KeyHandler.radialActive = false;
                        KeyHandler.radialLock = true;
                        mc.func_71381_h();
                        mc.func_71364_i();
                        return;
                    }
                    if (radialHudScale == 0.0f) {
                        foci.clear();
                        lensStack.clear();
                        this.lensHover.clear();
                        this.fociScale.clear();
                        lensSlot.clear();
                        ItemStack item = null;
                        for (int a = 0; a < mc.field_71439_g.field_71071_by.field_70462_a.size(); ++a) {
                            item = (ItemStack)mc.field_71439_g.field_71071_by.field_70462_a.get(a);
                            if (!item.func_190926_b() && item.func_77973_b() instanceof ItemLens) {
                                lens = (ItemLens)item.func_77973_b();
                                foci.put(((ItemLens)((Object)lens)).getLens().getRegistryName(), a);
                                lensStack.put(((ItemLens)((Object)lens)).getLens().getRegistryName(), item.func_77946_l());
                                this.fociScale.put(((ItemLens)((Object)lens)).getLens().getRegistryName(), Float.valueOf(1.0f));
                                this.lensHover.put(((ItemLens)((Object)lens)).getLens().getRegistryName(), false);
                                lensSlot.put(((ItemLens)((Object)lens)).getLens().getRegistryName(), a);
                            }
                            if (foci.size() <= 0 || !mc.field_71415_G) continue;
                            mc.field_71415_G = false;
                            mc.field_71417_B.func_74373_b();
                        }
                    }
                } else if (mc.field_71462_r == null && this.lastState) {
                    if (Display.isActive() && !mc.field_71415_G) {
                        mc.field_71415_G = true;
                        mc.field_71417_B.func_74372_a();
                    }
                    this.lastState = false;
                }
                this.renderFocusRadialHUD(event.getResolution().func_78327_c(), event.getResolution().func_78324_d(), time, event.getPartialTicks());
                if (time > this.lastTime) {
                    for (ResourceLocation key : this.lensHover.keySet()) {
                        if (this.lensHover.get(key).booleanValue()) {
                            if (!KeyHandler.radialActive && !KeyHandler.radialLock) {
                                if (lensSlot.containsKey(key)) {
                                    lens = (Lens)IsorropiaAPI.lensRegistry.getValue(key);
                                    LensManager.putLens((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Lens)((Object)lens), this.type);
                                    Common.INSTANCE.sendToServer((IMessage)new LensChangeMessage((Lens)((Object)lens), lensSlot.get(key), this.type));
                                }
                                KeyHandler.radialLock = true;
                            }
                            if (this.fociScale.get(key).floatValue() >= 1.3f) continue;
                            this.fociScale.put(key, Float.valueOf(this.fociScale.get(key).floatValue() + 0.025f));
                            continue;
                        }
                        if (this.fociScale.get(key).floatValue() <= 1.0f) continue;
                        this.fociScale.put(key, Float.valueOf(this.fociScale.get(key).floatValue() - 0.025f));
                    }
                    if (!KeyHandler.radialActive) {
                        radialHudScale = radialHudScale - 0.05f;
                    } else if (radialHudScale < 1.0f) {
                        radialHudScale = Math.min(radialHudScale = radialHudScale + 0.05f, 1.0f);
                    }
                    if (radialHudScale < 0.0f) {
                        radialHudScale = 0.0f;
                        KeyHandler.radialLock = false;
                    }
                    this.lastTime = time + 5L;
                    this.lastState = KeyHandler.radialActive;
                }
            }
        }

        public void renderFocusRadialHUD(double sw, double sh, long time, float partialTicks) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderItem ri = Minecraft.func_71410_x().func_175599_af();
            ItemStack goggles = LensManager.getRevealer((EntityPlayer)mc.field_71439_g);
            if (goggles == null) {
                return;
            }
            Lens lens = null;
            if (goggles.func_77978_p() != null) {
                lens = (Lens)IsorropiaAPI.lensRegistry.getValue(new ResourceLocation(goggles.func_77978_p().func_74779_i(this.type.getName())));
            }
            int i = (int)((double)Mouse.getEventX() * sw / (double)mc.field_71443_c);
            int j = (int)(sh - (double)Mouse.getEventY() * sh / (double)mc.field_71440_d - 1.0);
            int k = Mouse.getEventButton();
            if (lensStack.size() == 0) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)sw, (double)sh, (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(sw / 2.0), (double)(sh / 2.0), (double)0.0);
            ItemStack tt = null;
            float width = 16.0f + (float)lensStack.size() * 2.5f;
            GL11.glTranslatef((float)this.type.getAngle(), (float)0.0f, (float)0.0f);
            mc.field_71446_o.func_110577_a(radial);
            GL11.glPushMatrix();
            if (this.type.equals((Object)LensManager.LENSSLOT.LEFT)) {
                GL11.glRotatef((float)(-(partialTicks + (float)(mc.field_71439_g.field_70173_aa % 720) / 2.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GL11.glRotatef((float)(partialTicks + (float)(mc.field_71439_g.field_70173_aa % 720) / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            UtilsFX.renderQuadCentered((int)1, (int)1, (int)0, (float)(width * 2.75f * radialHudScale), (float)0.5f, (float)0.5f, (float)0.5f, (int)200, (int)771, (float)0.5f);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
            mc.field_71446_o.func_110577_a(radial2);
            GL11.glPushMatrix();
            if (this.type.equals((Object)LensManager.LENSSLOT.LEFT)) {
                GL11.glRotatef((float)(partialTicks + (float)(mc.field_71439_g.field_70173_aa % 720) / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GL11.glRotatef((float)(-(partialTicks + (float)(mc.field_71439_g.field_70173_aa % 720) / 2.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            UtilsFX.renderQuadCentered((int)1, (int)1, (int)0, (float)(width * 2.55f * radialHudScale), (float)0.5f, (float)0.5f, (float)0.5f, (int)200, (int)771, (float)0.5f);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
            if (lens != null) {
                GL11.glPushMatrix();
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                ItemLens itemLens = lens.getItemLens();
                ItemStack item = new ItemStack((Item)itemLens);
                item.func_77982_d(null);
                ri.func_175042_a(item, -8, -8);
                RenderHelper.func_74518_a();
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
                int mx = (int)((double)i - sw / 2.0);
                int my = (int)((double)j - sh / 2.0);
                if (mx >= -10 && mx <= 10 && my >= -10 && my <= 10) {
                    tt = new ItemStack((Item)lens.getItemLens());
                }
            }
            GL11.glScaled((double)radialHudScale, (double)radialHudScale, (double)radialHudScale);
            float currentRot = -90.0f * radialHudScale;
            float pieSlice = 360.0f / (float)lensStack.size();
            ResourceLocation key = foci.firstKey();
            for (int a = 0; a < lensStack.size(); ++a) {
                double xx = MathHelper.func_76134_b((float)(currentRot / 180.0f * 3.141593f)) * width;
                double yy = MathHelper.func_76126_a((float)(currentRot / 180.0f * 3.141593f)) * width;
                currentRot += pieSlice;
                GL11.glPushMatrix();
                if (this.type.equals((Object)LensManager.LENSSLOT.LEFT)) {
                    GL11.glTranslated((double)xx, (double)yy, (double)100.0);
                } else {
                    GL11.glTranslated((double)(-xx), (double)yy, (double)100.0);
                }
                if (this.fociScale.get(key) == null) {
                    this.fociScale.put(key, Float.valueOf(1.0f));
                }
                GL11.glScalef((float)this.fociScale.get(key).floatValue(), (float)this.fociScale.get(key).floatValue(), (float)this.fociScale.get(key).floatValue());
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                ItemStack item2 = lensStack.get(key).func_77946_l();
                item2.func_77982_d(null);
                ri.func_175042_a(item2, -8, -8);
                RenderHelper.func_74518_a();
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
                if (!KeyHandler.radialLock && KeyHandler.radialActive) {
                    int mx2 = this.type.equals((Object)LensManager.LENSSLOT.LEFT) ? (int)((double)i - sw / 2.0 - xx + (double)(-this.type.getAngle())) : (int)((double)i - sw / 2.0 - -xx + (double)(-this.type.getAngle()));
                    int my2 = (int)((double)j - sh / 2.0 - yy);
                    if (mx2 >= -10 && mx2 <= 10 && my2 >= -10 && my2 <= 10) {
                        this.lensHover.put(key, true);
                        tt = lensStack.get(key);
                        if (k == 0) {
                            KeyHandler.radialActive = false;
                            KeyHandler.radialLock = true;
                            if (!lensSlot.containsKey(key)) break;
                            Lens lens1 = (Lens)IsorropiaAPI.lensRegistry.getValue(key);
                            LensManager.putLens((EntityPlayer)Minecraft.func_71410_x().field_71439_g, lens1, this.type);
                            Common.INSTANCE.sendToServer((IMessage)new LensChangeMessage(lens1, lensSlot.get(key), this.type));
                            break;
                        }
                    } else {
                        this.lensHover.put(key, false);
                    }
                }
                key = foci.higherKey(key);
            }
            GL11.glPopMatrix();
            if (tt != null) {
                UtilsFX.drawCustomTooltip((GuiScreen)mc.field_71462_r, (FontRenderer)mc.field_71466_p, (List)tt.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED), (int)0, (int)20, (int)11);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }
}

