/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.client.renderer.entities;

import fr.wind_blade.isorropia.common.entities.EntityDopeSquid;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;

public class RenderDopeSquid
extends RenderLiving<EntityDopeSquid> {
    private static final ResourceLocation SQUID_TEXTURES = new ResourceLocation("isorropia", "textures/entity/dope_squid.png");

    public RenderDopeSquid(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelSquid(), 0.7f);
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityDopeSquid entity) {
        return SQUID_TEXTURES;
    }

    protected void applyRotations(EntityDopeSquid entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        float f3 = entityLiving.prevSquidPitch + (entityLiving.squidPitch - entityLiving.prevSquidPitch) * partialTicks;
        float f4 = entityLiving.prevSquidYaw + (entityLiving.squidYaw - entityLiving.prevSquidYaw) * partialTicks;
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)f4, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.2f, (float)0.0f);
    }

    protected float handleRotationFloat(EntityDopeSquid livingBase, float partialTicks) {
        return livingBase.lastTentacleAngle + (livingBase.tentacleAngle - livingBase.lastTentacleAngle) * partialTicks;
    }
}

