/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.entities;

import fr.wind_blade.isorropia.common.items.ItemsIS;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aura.AuraHelper;

public class EntityJellyRabbit
extends EntityRabbit
implements IShearable {
    private static final DataParameter<String> aspect = EntityDataManager.func_187226_a(EntityJellyRabbit.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> jelly = EntityDataManager.func_187226_a(EntityJellyRabbit.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int JELLY_BY_TICKS = 8000;
    private static final int AURA_BY_JELLY = 100;
    private static final int cooldown = 80;
    private int count;
    private Color color = new Color(Aspect.ORDER.getColor());

    public EntityJellyRabbit(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(aspect, (Object)Aspect.ORDER.getTag());
        this.field_70180_af.func_187214_a(jelly, (Object)0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        Aspect[] displayAspects = (Aspect[])Aspect.aspects.values().toArray((Object[])new Aspect[0]);
        this.setAspect(displayAspects[this.field_70170_p.field_73012_v.nextInt(displayAspects.length)]);
        this.setJellySize(2);
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70143_R = 0.0f;
        if (this.field_70170_p.field_72995_K || this.getJellySize() > 8) {
            return;
        }
        if (this.count % 80 == 0) {
            if (this.getAspect() == Aspect.FLUX) {
                if (AuraHelper.getFlux((World)this.func_130014_f_(), (BlockPos)this.func_180425_c()) > 0.0f) {
                    AuraHelper.addVis((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)AuraHelper.drainFlux((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)10.0f, (boolean)false));
                }
            } else {
                AuraHelper.drainVis((World)this.func_130014_f_(), (BlockPos)this.func_180425_c(), (float)100.0f, (boolean)false);
            }
        }
        if (this.count >= 8000) {
            this.setJellySize(this.getJellySize() + 1);
            this.count = 0;
        }
        ++this.count;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getJellySize() > 0 && source != DamageSource.field_76380_i) {
            Entity entity = source.func_76346_g();
            if (entity != null) {
                double d1 = entity.field_70165_t - this.field_70165_t;
                double d0 = entity.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)this.field_70177_z);
                this.func_70653_a(entity, 0.4f, d1, d0);
                if (entity instanceof EntityLivingBase) {
                    this.func_70604_c((EntityLivingBase)entity);
                }
            }
            this.func_184185_a(this.getJellySize() > 0 ? SoundEvents.field_187880_fp : SoundEvents.field_187822_em, 1.0f, this.func_70647_i());
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(this.getJelly(), 0.0f);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public ItemStack getJelly() {
        ItemStack stack = new ItemStack((Item)ItemsIS.itemJelly);
        Aspect apsect = this.getAspect();
        if (apsect != null) {
            ItemsIS.itemJelly.setAspects(stack, new AspectList().add(apsect, 5));
        }
        this.setJellySize(this.getJellySize() - 1);
        return stack;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String tag = (String)this.field_70180_af.func_187225_a(aspect);
        String s = EntityList.func_75621_b((Entity)this);
        String name = "";
        if (s == null) {
            s = "generic";
        }
        name = tag == null || tag.isEmpty() ? I18n.func_135052_a((String)("entity." + s + ".name"), (Object[])new Object[0]) : (I18n.func_188566_a((String)("entity." + s + "." + tag + ".name")) ? I18n.func_135052_a((String)("entity." + s + "." + tag + ".name"), (Object[])new Object[0]) : I18n.func_135052_a((String)("entity." + s + ".aspect.name"), (Object[])new Object[]{tag}));
        return name;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        Aspect aspect = this.getAspect();
        compound.func_74778_a("tag", aspect != null ? aspect.getTag() : "");
        compound.func_74768_a("jelly", ((Integer)this.field_70180_af.func_187225_a(jelly)).intValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAspect(Aspect.getAspect((String)compound.func_74779_i("tag")));
        this.field_70180_af.func_187227_b(jelly, (Object)compound.func_74762_e("jelly"));
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.getJellySize() > 0;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(this.getJelly());
        return stacks;
    }

    public void setAspect(Aspect jellyAspect) {
        this.field_70180_af.func_187227_b(aspect, (Object)jellyAspect.getTag());
        if (this.field_70170_p.field_72995_K) {
            this.color = new Color(jellyAspect.getColor());
        }
    }

    public Aspect getAspect() {
        return Aspect.getAspect((String)((String)this.field_70180_af.func_187225_a(aspect)));
    }

    public int getJellySize() {
        return (Integer)this.field_70180_af.func_187225_a(jelly);
    }

    public void setJellySize(int newJellySize) {
        this.field_70180_af.func_187227_b(jelly, (Object)newJellySize);
    }

    public Color getColor() {
        return this.color;
    }
}

