/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.entities.ai;

import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.config.Config;
import fr.wind_blade.isorropia.common.network.ParticuleDestroyMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.world.taint.BlockTaintLog;
import thaumcraft.common.blocks.world.taint.ITaintBlock;

public class EntityAIEatTaint
extends EntityAIBase {
    public static final Map<Biome, BlockPlanks.EnumType> WOOD_IN_BIOMES = new HashMap<Biome, BlockPlanks.EnumType>();
    private EntityLiving living;
    private BlockPos targetPos;
    int cooldown;

    public EntityAIEatTaint(EntityLiving living) {
        this.living = living;
    }

    public boolean func_75250_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return this.findTaint();
    }

    private boolean findTaint() {
        this.targetPos = null;
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.living.func_180425_c().func_177982_a(-5, -2, -5), (BlockPos)this.living.func_180425_c().func_177982_a(5, 5, 5))) {
            if (this.living.field_70170_p.func_180495_p(pos).func_185904_a() != ThaumcraftMaterials.MATERIAL_TAINT || this.living.func_70661_as().func_75488_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) == null) continue;
            this.targetPos = pos;
            return true;
        }
        for (int tries = 0; tries < 30; ++tries) {
            int x2 = (int)this.living.field_70165_t + this.living.field_70170_p.field_73012_v.nextInt(17) - 8;
            int z = (int)this.living.field_70161_v + this.living.field_70170_p.field_73012_v.nextInt(17) - 8;
            int y2 = (int)this.living.field_70163_u + this.living.field_70170_p.field_73012_v.nextInt(5) - 2;
            if (!this.living.field_70170_p.func_175623_d(new BlockPos(x2, y2 + 1, z)) || this.living.field_70170_p.func_180495_p(new BlockPos(x2, y2, z)).func_185904_a() != ThaumcraftMaterials.MATERIAL_TAINT || this.living.func_70661_as().func_75488_a((double)x2, (double)y2, (double)z) == null) {
                continue;
            }
            this.targetPos = new BlockPos(x2, y2, z);
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.living.func_70661_as().func_75500_f() && this.targetPos != null && this.living.func_70661_as().func_179680_a(this.targetPos) != null;
    }

    public void func_75251_c() {
        this.targetPos = null;
        this.living.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        this.living.func_70671_ap().func_75650_a((double)this.targetPos.func_177958_n() + 0.5, (double)this.targetPos.func_177956_o() + 0.5, (double)this.targetPos.func_177952_p() + 0.5, 30.0f, 30.0f);
        double dist = this.living.func_70092_e((double)this.targetPos.func_177958_n() + 0.5, (double)this.targetPos.func_177956_o() + 0.5, (double)this.targetPos.func_177952_p() + 0.5);
        if (dist <= 4.0) {
            this.eatTaint();
        } else {
            this.living.func_70661_as().func_75492_a((double)this.targetPos.func_177958_n() + 0.5, (double)this.targetPos.func_177956_o() + 0.5, (double)this.targetPos.func_177952_p() + 0.5, 1.0);
        }
    }

    private void eatTaint() {
        IBlockState state = this.living.field_70170_p.func_180495_p(this.targetPos);
        if (state.func_185904_a() == ThaumcraftMaterials.MATERIAL_TAINT || state.func_177230_c() instanceof ITaintBlock) {
            if (state.func_177230_c() == BlocksTC.taintLog) {
                Biome biome = this.living.field_70170_p.func_180494_b(this.targetPos);
                BlockPlanks.EnumType type = WOOD_IN_BIOMES.containsKey(biome) ? WOOD_IN_BIOMES.get(biome) : BlockPlanks.EnumType.OAK;
                this.living.field_70170_p.func_175656_a(this.targetPos, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)type).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)((EnumFacing.Axis)state.func_177229_b((IProperty)BlockTaintLog.AXIS)))));
            } else if (state.func_177230_c() == BlocksTC.taintRock) {
                this.living.field_70170_p.func_175656_a(this.targetPos, Blocks.field_150348_b.func_176223_P());
            } else if (state.func_177230_c() == BlocksTC.taintSoil) {
                this.living.field_70170_p.func_175656_a(this.targetPos, Blocks.field_150346_d.func_176223_P());
            } else {
                this.living.field_70170_p.func_175698_g(this.targetPos);
            }
            Common.INSTANCE.sendToAllAround((IMessage)new ParticuleDestroyMessage(this.targetPos), new NetworkRegistry.TargetPoint(this.living.field_70170_p.field_73011_w.getDimension(), (double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p(), 10.0));
            this.living.func_184185_a(SoundEvents.field_187739_dZ, 0.2f, ((this.living.field_70170_p.field_73012_v.nextFloat() - this.living.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.living.func_70691_i(1.0f);
            this.cooldown = Config.taint_pig_cooldown;
        } else {
            this.func_75251_c();
        }
    }

    public void func_75249_e() {
        if (this.targetPos != null) {
            this.living.func_70661_as().func_75492_a((double)this.targetPos.func_177958_n() + 0.5, (double)this.targetPos.func_177956_o() + 0.5, (double)this.targetPos.func_177952_p() + 0.5, 1.0);
        }
    }

    static {
        WOOD_IN_BIOMES.put(Biomes.field_76770_e, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_76768_g, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_76784_u, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_76783_v, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_150584_S, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_150579_T, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_150578_U, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_150581_V, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_76781_i, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_185443_S, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_150590_f, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_185431_ac, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_185432_ad, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_185433_ae, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_185434_af, BlockPlanks.EnumType.SPRUCE);
        WOOD_IN_BIOMES.put(Biomes.field_150583_P, BlockPlanks.EnumType.BIRCH);
        WOOD_IN_BIOMES.put(Biomes.field_150582_Q, BlockPlanks.EnumType.BIRCH);
        WOOD_IN_BIOMES.put(Biomes.field_185448_Z, BlockPlanks.EnumType.BIRCH);
        WOOD_IN_BIOMES.put(Biomes.field_185429_aa, BlockPlanks.EnumType.BIRCH);
        WOOD_IN_BIOMES.put(Biomes.field_76782_w, BlockPlanks.EnumType.JUNGLE);
        WOOD_IN_BIOMES.put(Biomes.field_76792_x, BlockPlanks.EnumType.JUNGLE);
        WOOD_IN_BIOMES.put(Biomes.field_150574_L, BlockPlanks.EnumType.JUNGLE);
        WOOD_IN_BIOMES.put(Biomes.field_185446_X, BlockPlanks.EnumType.JUNGLE);
        WOOD_IN_BIOMES.put(Biomes.field_185447_Y, BlockPlanks.EnumType.JUNGLE);
        WOOD_IN_BIOMES.put(Biomes.field_150588_X, BlockPlanks.EnumType.ACACIA);
        WOOD_IN_BIOMES.put(Biomes.field_150587_Y, BlockPlanks.EnumType.ACACIA);
        WOOD_IN_BIOMES.put(Biomes.field_185435_ag, BlockPlanks.EnumType.ACACIA);
        WOOD_IN_BIOMES.put(Biomes.field_185436_ah, BlockPlanks.EnumType.ACACIA);
        WOOD_IN_BIOMES.put(Biomes.field_150585_R, BlockPlanks.EnumType.DARK_OAK);
        WOOD_IN_BIOMES.put(Biomes.field_185430_ab, BlockPlanks.EnumType.DARK_OAK);
    }
}

