/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.items.misc;

import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.IsorropiaAPI;
import fr.wind_blade.isorropia.common.items.IJellyAspectEffectProvider;
import fr.wind_blade.isorropia.common.items.ItemsIS;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public class ItemJelly
extends ItemFood
implements IEssentiaContainerItem {
    private static final int ASPECT_SIZE = 5;

    public ItemJelly() {
        super(0, false);
        this.setNoRepair();
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == Common.isorropiaCreativeTabs || tab == CreativeTabs.field_78027_g) {
            items.add((Object)new ItemStack((Item)this));
            for (Aspect tag : Aspect.aspects.values()) {
                ItemStack i = new ItemStack((Item)this);
                this.setAspects(i, new AspectList().add(tag, 5));
                items.add((Object)i);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return this.getAspects(stack) != null && !this.getAspects((ItemStack)stack).aspects.isEmpty() ? (this.getAspects(stack).getAspects()[0] == Aspect.FLUX ? I18n.func_135052_a((String)(this.func_77667_c(stack) + ".vitium.name"), (Object[])new Object[0]) : String.format(super.func_77653_i(stack), this.getAspects(stack).getAspects()[0].getName())) : I18n.func_135052_a((String)(this.func_77667_c(stack) + ".default.name"), (Object[])new Object[0]);
    }

    public AspectList getAspects(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            AspectList aspects = new AspectList();
            aspects.readFromNBT(itemstack.func_77978_p());
            return aspects.size() > 0 ? aspects : null;
        }
        return null;
    }

    public void setAspects(ItemStack itemstack, AspectList aspects) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        aspects.writeToNBT(itemstack.func_77978_p());
    }

    public boolean ignoreContainedAspects() {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ItemJelly.getProvider(itemstack).canBeEaten(playerIn, itemstack)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    protected void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        ItemJelly.getProvider(stack).onFoodEeaten(player, stack);
    }

    public int func_77626_a(ItemStack stack) {
        return ItemJelly.getProvider(stack).getEatDuration(stack);
    }

    public int func_150905_g(ItemStack stack) {
        return ItemJelly.getProvider(stack).getHungerReplinish(stack);
    }

    public float func_150906_h(ItemStack stack) {
        return ItemJelly.getProvider(stack).getSaturationReplinish(stack);
    }

    private static IJellyAspectEffectProvider getProvider(ItemStack stack) {
        AspectList aspects = ItemsIS.itemJelly.getAspects(stack);
        IJellyAspectEffectProvider provider = IsorropiaAPI.getJellyAspectEffect(aspects == null ? null : aspects.getAspects()[0]);
        return provider == null ? IsorropiaAPI.getJellyAspectEffect(null) : provider;
    }
}

